/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.agilebi.modeler.propforms.HierarchyPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyMetaData
extends AbstractMetaDataModelNode<LevelMetaData>
implements Serializable {
    private static final long serialVersionUID = 7063031303948537101L;
    String name;

    public HierarchyMetaData() {
    }

    public HierarchyMetaData(String name) {
        this.name = name;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.hierarchy.MISSING_NAME", new String[0]));
            this.valid = false;
        }
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.hierarchy.REQUIRES_AT_LEAST_ONE_LEVEL", new String[0]));
            this.valid = false;
        }
        HashMap<String, LevelMetaData> usedNames = new HashMap<String, LevelMetaData>();
        if (this.children.size() == 0) {
            this.valid = false;
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.hierarchy.REQUIRES_AT_LEAST_ONE_LEVEL", new String[0]));
        }
        for (LevelMetaData level : this.children) {
            this.valid &= level.isValid();
            this.validationMessages.addAll(level.getValidationMessages());
            if (usedNames.containsKey(level.getName())) {
                LevelMetaData l;
                this.valid = false;
                String dupeString = ModelerMessagesHolder.getMessages().getString("validation.hierarchy.DUPLICATE_LEVEL_NAMES", level.getName());
                this.validationMessages.add(dupeString);
                level.invalidate();
                if (!level.getValidationMessages().contains(dupeString)) {
                    level.getValidationMessages().add(dupeString);
                }
                if (!(l = (LevelMetaData)usedNames.get(level.getName())).isValid()) continue;
                l.invalidate();
                if (l.getValidationMessages().contains(dupeString)) continue;
                l.getValidationMessages().add(dupeString);
                continue;
            }
            usedNames.put(level.getName(), level);
        }
    }

    @Bindable
    public String toString() {
        return "Hierarchy Name: " + this.name;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_hierarchy_icon.png";
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return HierarchyPropertiesForm.class;
    }

    @Override
    public void onAdd(LevelMetaData child) {
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(LevelMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(HierarchyMetaData obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchyMetaData other = obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        boolean isSupportedType = false;
        boolean bl = isSupportedType = obj instanceof AvailableField || obj instanceof LevelMetaData || obj instanceof MeasureMetaData || obj instanceof MemberPropertyMetaData;
        if (isSupportedType) {
            if (this.size() == 0) {
                return true;
            }
            LevelMetaData level = (LevelMetaData)this.get(0);
            if (level.getLogicalColumn() == null) {
                return false;
            }
            String myTableId = level.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId();
            if (obj instanceof AvailableField) {
                AvailableField field = (AvailableField)obj;
                return myTableId.equals(field.getPhysicalColumn().getPhysicalTable().getId());
            }
            if (obj instanceof ColumnBackedNode) {
                ColumnBackedNode field = (ColumnBackedNode)obj;
                return myTableId.equals(field.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId());
            }
        }
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            ColumnBackedNode node;
            LevelMetaData level = null;
            if (data instanceof AvailableField) {
                node = this.getWorkspace().createColumnBackedNode((AvailableField)data, ModelerPerspective.ANALYSIS);
                level = this.getWorkspace().createLevelForParentWithNode(this, node);
            } else if (data instanceof LevelMetaData) {
                level = (LevelMetaData)data;
                level.setParent(this);
            } else if (data instanceof ColumnBackedNode) {
                node = (ColumnBackedNode)data;
                level = this.getWorkspace().createLevelForParentWithNode(this, node);
                level.setName(node.getName());
            } else {
                throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
            }
            if (this.size() > 0) {
                LogicalTable existingTable = ((LevelMetaData)this.get(0)).getLogicalColumn().getLogicalTable();
                if (level.getLogicalColumn().getLogicalTable().getId() != existingTable.getId()) {
                    throw new IllegalStateException(ModelerMessagesHolder.getMessages().getString("DROP.ERROR.TWO_TABLES_IN_HIERARCHY", new String[0]));
                }
            }
            return level;
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

