/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.BaseColumnBackedMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.agilebi.modeler.propforms.LevelsPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelMetaData
extends BaseColumnBackedMetaData<MemberPropertyMetaData>
implements Serializable {
    private static final long serialVersionUID = -8026104295937064671L;
    private static final String IMAGE = "images/sm_level_icon.png";
    private HierarchyMetaData parent;

    public LevelMetaData() {
        super.setUniqueList(true);
    }

    public LevelMetaData(HierarchyMetaData parent, String name) {
        super(name);
        super.setUniqueList(true);
        this.parent = parent;
    }

    @Bindable
    public String toString() {
        return "Level Name: " + this.name + "\nColumn Name: " + this.columnName;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return IMAGE;
    }

    public HierarchyMetaData getParent() {
        return this.parent;
    }

    public void setParent(HierarchyMetaData md) {
        this.parent = md;
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return LevelsPropertiesForm.class;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.uniqueMembers == null ? 0 : this.uniqueMembers.hashCode());
        return result;
    }

    public boolean equals(LevelMetaData obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LevelMetaData other = obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        MemberPropertyMetaData field;
        if (this.getLogicalColumn() == null) {
            return false;
        }
        String myTableId = this.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId();
        if (obj instanceof AvailableField) {
            AvailableField field2 = (AvailableField)obj;
            return myTableId.equals(field2.getPhysicalColumn().getPhysicalTable().getId());
        }
        if (obj instanceof MemberPropertyMetaData && (field = (MemberPropertyMetaData)obj).getLogicalColumn() != null) {
            return myTableId.equals(field.getLogicalColumn().getPhysicalColumn().getPhysicalTable().getId());
        }
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            MemberPropertyMetaData memberProp = null;
            if (data instanceof AvailableField) {
                ColumnBackedNode node = this.getWorkspace().createColumnBackedNode((AvailableField)data, ModelerPerspective.ANALYSIS);
                memberProp = this.getWorkspace().createMemberPropertyForParentWithNode(this, node);
            } else if (data instanceof MemberPropertyMetaData) {
                memberProp = (MemberPropertyMetaData)data;
                memberProp.setParent(this);
            } else {
                throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
            }
            LogicalTable existingTable = this.getLogicalColumn().getLogicalTable();
            if (memberProp.getLogicalColumn().getLogicalTable().getId() != existingTable.getId()) {
                throw new IllegalStateException(ModelerMessagesHolder.getMessages().getString("DROP.ERROR.MEMBER_PROP_FROM_DIFFERENT_TABLE", new String[0]));
            }
            return memberProp;
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }

    @Override
    public void validate() {
        super.validate();
        HashMap<String, MemberPropertyMetaData> usedNames = new HashMap<String, MemberPropertyMetaData>();
        if (this.children.size() > 0) {
            for (MemberPropertyMetaData memberProp : this.children) {
                this.valid &= memberProp.isValid();
                this.validationMessages.addAll(memberProp.getValidationMessages());
                if (usedNames.containsKey(memberProp.getName())) {
                    MemberPropertyMetaData m;
                    this.valid = false;
                    String dupeString = ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("DUPLICATE_MEMBER_PROPERTY_NAMES"), memberProp.getName());
                    this.validationMessages.add(dupeString);
                    memberProp.invalidate();
                    if (!memberProp.getValidationMessages().contains(dupeString)) {
                        memberProp.getValidationMessages().add(dupeString);
                    }
                    if (!(m = (MemberPropertyMetaData)usedNames.get(memberProp.getName())).isValid()) continue;
                    m.invalidate();
                    if (m.getValidationMessages().contains(dupeString)) continue;
                    m.getValidationMessages().add(dupeString);
                    continue;
                }
                usedNames.put(memberProp.getName(), memberProp);
            }
        }
    }

    @Override
    public String getValidationMessageKey(String key) {
        return "validation.level." + key;
    }

    @Override
    public IPhysicalTable getTableRestriction() {
        if (this.size() > 0 && this.getLogicalColumn() != null) {
            return this.getLogicalColumn().getPhysicalColumn().getPhysicalTable();
        }
        if (this.parent != null && this.parent.size() > 0) {
            Iterator i$ = this.parent.iterator();
            while (i$.hasNext()) {
                LevelMetaData sibling = (LevelMetaData)i$.next();
                if (sibling == this || sibling.getLogicalColumn() == null) continue;
                return sibling.getLogicalColumn().getPhysicalColumn().getPhysicalTable();
            }
        }
        return null;
    }

    public MemberPropertyMetaData getLatitudeField() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            MemberPropertyMetaData member = (MemberPropertyMetaData)i$.next();
            if (!member.getName().equals("latitude")) continue;
            return member;
        }
        return null;
    }

    public MemberPropertyMetaData getLongitudeField() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            MemberPropertyMetaData member = (MemberPropertyMetaData)i$.next();
            if (!member.getName().equals("longitude")) continue;
            return member;
        }
        return null;
    }

    protected boolean compareChildren(MemberPropertyMetaData child, MemberPropertyMetaData newChild) {
        return child.getName().equals(newChild.getName());
    }
}

