/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.gwt.GwtModelerMessages;
import org.pentaho.gwt.widgets.client.utils.i18n.IResourceBundleLoadCallback;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.modeler.ModelerDialog;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.GwtDatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardListener;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.ConnectionController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.FileImportController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MainWizardController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.SummaryDialogController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.WizardDatasourceController;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.WizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.CsvDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultiTableDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasource;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulFileUpload;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.gwt.util.AsyncXulLoader;
import org.pentaho.ui.xul.gwt.util.IXulLoaderCallback;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedWizard
extends AbstractXulDialogController<Domain>
implements IXulLoaderCallback,
IResourceBundleLoadCallback,
IWizardListener,
XulServiceCallback<Domain> {
    protected static final String MAIN_WIZARD_PANEL = "main_wizard_panel.xul";
    protected static final String MAIN_WIZARD_PANEL_PACKAGE = "main_wizard_panel";
    protected static final String WIZARD_DIALOG_ID = "main_wizard_window";
    private XulDomContainer mainWizardContainer;
    private XulDialog dialog;
    private MainWizardController wizardController;
    private DatasourceModel datasourceModel = new DatasourceModel();
    private WizardDatasourceController datasourceController;
    private ConnectionController connectionController;
    private IXulAsyncConnectionService connectionService;
    private boolean checkHasAccess;
    private IXulAsyncDatasourceService datasourceService;
    private DatasourceMessages datasourceMessages;
    private boolean initialized;
    private AsyncConstructorListener asyncConstructorListener;
    private ResourceBundle bundle;
    private IDatasourceSummary summary;
    private ModelerDialog modeler;
    private SummaryDialogController summaryDialogController = new SummaryDialogController();
    private IWizardModel wizardModel = new WizardModel();
    private ICsvDatasourceServiceAsync csvDatasourceService;
    private DialogController.DialogListener<Domain> modelerDialogListener;
    private boolean reportingOnlyValid = true;

    public EmbeddedWizard(boolean checkHasAccess) {
        this.checkHasAccess = checkHasAccess;
    }

    public void bundleLoaded(String bundleName) {
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)new GwtModelerMessages(this.bundle));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void init(AsyncConstructorListener<EmbeddedWizard> constructorListener) {
        this.asyncConstructorListener = constructorListener;
        this.setConnectionService(this.connectionService);
        this.setDatasourceService(this.datasourceService);
        this.wizardModel.addDatasource(new CsvDatasource(this.datasourceModel, this.datasourceService, this.csvDatasourceService));
        this.wizardModel.addDatasource(new QueryDatasource(this.datasourceService, this.datasourceModel));
        this.wizardModel.addDatasource(new MultiTableDatasource(this.datasourceModel));
        if (this.checkHasAccess) {
            this.datasourceService.hasPermission(new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    MessageHandler.getInstance().showErrorDialog(EmbeddedWizard.this.datasourceMessages.getString("DatasourceEditor.ERROR"), EmbeddedWizard.this.datasourceMessages.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", error.getLocalizedMessage()));
                }

                public void success(Boolean retVal) {
                    EmbeddedWizard.this.loadXul();
                    EmbeddedWizard.this.onDialogReady();
                }
            });
        } else {
            this.loadXul();
        }
    }

    private void loadXul() {
        this.bundle = new ResourceBundle("", "modeler", true, (IResourceBundleLoadCallback)this);
        AsyncXulLoader.loadXulFromUrl((String)MAIN_WIZARD_PANEL, (String)MAIN_WIZARD_PANEL_PACKAGE, (IXulLoaderCallback)this);
    }

    @Override
    public void onCancel() {
        this.dialog.hide();
        this.datasourceModel.clearModel();
        this.wizardController.setActiveStep(0);
        this.wizardController.resetSelectedDatasource();
    }

    @Override
    public void onFinish(IDatasourceSummary summary) {
        this.wizardController.resetSelectedDatasource();
        this.summary = summary;
        if (this.wizardModel.isEditing() && summary.getErrorCount() == 0L) {
            this.handleModelerDialog();
            return;
        }
        final boolean showModelerDecision = !this.wizardModel.isEditing();
        this.summaryDialogController.showSummaryDialog(summary, showModelerDecision, new XulServiceCallback<IDatasourceSummary>(){

            public void error(String s, Throwable throwable) {
                MessageHandler.getInstance().showErrorDialog(s, throwable.getMessage());
            }

            public void success(IDatasourceSummary iDatasourceSummary) {
                if (!showModelerDecision) {
                    EmbeddedWizard.this.handleModelerDialog();
                    return;
                }
                if (iDatasourceSummary.isShowModeler()) {
                    EmbeddedWizard.this.showModelEditor();
                } else {
                    EmbeddedWizard.this.onDialogAccept();
                }
                MessageHandler.getInstance().closeWaitingDialog();
            }
        });
    }

    private void handleModelerDialog() {
        MessageHandler.getInstance().closeWaitingDialog();
        if (this.modelerDialogListener != null) {
            this.modelerDialogListener.onDialogAccept((Object)this.getDialogResult());
        }
        this.modelerDialogListener = null;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException(this.datasourceMessages.getString("DatasourceEditor.ERROR_0003_CONSTRUCTOR_NOT_INITIALIZED_ERROR"));
        }
    }

    public void addDialogListener(DialogController.DialogListener<Domain> listener) {
        this.checkInitialized();
        super.addDialogListener(listener);
        listener.onDialogReady();
    }

    public void showDialog() {
        this.modelerDialogListener = null;
        if (this.datasourceModel.getGuiStateModel().getConnections() == null || this.datasourceModel.getGuiStateModel().getConnections().size() <= 0) {
            this.checkInitialized();
        }
        this.wizardModel.setEditing(false);
        this.wizardController.setActiveStep(0);
        this.wizardModel.reset();
        this.wizardModel.setReportingOnlyValid(this.reportingOnlyValid);
        XulButton nextButton = (XulButton)this.mainWizardContainer.getDocumentRoot().getElementById("main_wizard_window_extra2");
        nextButton.setDisabled(false);
        nextButton.setDisabled(true);
        this.dialog.show();
        XulTextbox datasourceName = (XulTextbox)this.mainWizardContainer.getDocumentRoot().getElementById("datasourceName");
        datasourceName.setFocus();
    }

    public void showEditDialog(Domain domain, DialogController.DialogListener<Domain> listener) {
        this.checkInitialized();
        this.modelerDialogListener = listener;
        String datasourceType = (String)((LogicalModel)domain.getLogicalModels().get(0)).getProperty("DatasourceType");
        if (datasourceType == null) {
            datasourceType = "SQL-DS";
        }
        IWizardDatasource selectedDatasource = null;
        for (IWizardDatasource datasource : this.wizardModel.getDatasources()) {
            if (!datasource.getId().equals(datasourceType)) continue;
            selectedDatasource = datasource;
            break;
        }
        if (selectedDatasource == null) {
            Window.alert((String)("bad one: " + datasourceType));
            MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("datasourceDialog.ERROR_INCOMPATIBLE_DOMAIN_TITLE"), MessageHandler.getString("datasourceDialog.ERROR_INCOMPATIBLE_DOMAIN"));
            return;
        }
        this.wizardModel.reset();
        this.wizardModel.setReportingOnlyValid(this.reportingOnlyValid);
        this.wizardModel.setSelectedDatasource(selectedDatasource);
        this.wizardModel.setEditing(true);
        this.wizardController.reset();
        selectedDatasource.restoreSavedDatasource(domain, new XulServiceCallback<Void>(){

            public void error(String s, Throwable throwable) {
                MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("datasourceDialog.ERROR_INCOMPATIBLE_DOMAIN"), throwable.getMessage());
            }

            public void success(Void aVoid) {
                EmbeddedWizard.this.dialog.show();
            }
        });
    }

    public void overlayLoaded() {
    }

    public void overlayRemoved() {
    }

    public XulDomContainer getMainWizardContainer() {
        return this.mainWizardContainer;
    }

    public void setConnectionService(IXulAsyncConnectionService service) {
        this.connectionService = service;
        if (this.connectionController != null) {
            this.connectionController.setService(service);
        }
    }

    public IXulAsyncConnectionService getConnectionService() {
        return this.connectionService;
    }

    public IXulAsyncDatasourceService getDatasourceService() {
        return this.datasourceService;
    }

    public MainWizardController getWizardController() {
        return this.wizardController;
    }

    public void setDatasourceService(IXulAsyncDatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    public void xulLoaded(GwtXulRunner runner) {
        this.mainWizardContainer = (XulDomContainer)runner.getXulDomContainers().get(0);
        Document rootDocument = this.mainWizardContainer.getDocumentRoot();
        GwtBindingFactory bf = new GwtBindingFactory(rootDocument);
        ResourceBundle resBundle = (ResourceBundle)this.mainWizardContainer.getResourceBundles().get(0);
        this.datasourceMessages = new GwtDatasourceMessages();
        this.datasourceMessages.setMessageBundle(resBundle);
        MessageHandler.getInstance().setMessages(this.datasourceMessages);
        this.connectionController = new ConnectionController();
        this.connectionController.setService(this.connectionService);
        this.summaryDialogController.setBindingFactory((BindingFactory)bf);
        this.mainWizardContainer.addEventHandler((XulEventHandler)this.summaryDialogController);
        this.wizardController = new MainWizardController((BindingFactory)bf, this.wizardModel, this.datasourceService);
        this.mainWizardContainer.addEventHandler((XulEventHandler)this.wizardController);
        this.dialog = (XulDialog)rootDocument.getElementById(WIZARD_DIALOG_ID);
        MessageHandler.getInstance().setWizardDialog(this.dialog);
        this.datasourceController = new WizardDatasourceController();
        this.datasourceController.setBindingFactory((BindingFactory)bf);
        this.datasourceController.setDatasourceMessages(this.datasourceMessages);
        this.mainWizardContainer.addEventHandler((XulEventHandler)this.datasourceController);
        this.mainWizardContainer.addEventHandler((XulEventHandler)MessageHandler.getInstance());
        this.wizardController.addWizardListener(this);
        FileImportController fileImportController = new FileImportController(this.datasourceModel, this.datasourceMessages);
        this.mainWizardContainer.addEventHandler((XulEventHandler)fileImportController);
        fileImportController.init();
        MessageHandler.getInstance().init();
        this.summaryDialogController.init();
        try {
            this.wizardController.init();
            this.initialized = true;
        }
        catch (Exception throwable) {
            throwable.printStackTrace();
        }
        if (!GWT.isScript()) {
            XulFileUpload upload = (XulFileUpload)rootDocument.getElementById("fileUpload");
            upload.setAction(GWT.getModuleBaseURL() + "UploadService");
        }
        this.initialized = true;
        if (this.asyncConstructorListener != null) {
            this.asyncConstructorListener.asyncConstructorDone((Object)this);
        }
    }

    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public void setDatasourceModel(DatasourceModel datasourceModel) {
        this.datasourceModel = datasourceModel;
    }

    protected XulDialog getDialog() {
        return this.dialog;
    }

    protected Domain getDialogResult() {
        return this.summary.getDomain();
    }

    public DatasourceMessages getDatasourceMessages() {
        return this.datasourceMessages;
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.datasourceMessages = datasourceMessages;
    }

    public void setWizardController(MainWizardController wizardController) {
        this.wizardController = wizardController;
    }

    @Bindable
    public void showModelEditor() {
        DialogController.DialogListener<Domain> listener = new DialogController.DialogListener<Domain>(){

            public void onDialogCancel() {
            }

            public void onDialogAccept(Domain domain) {
                EmbeddedWizard.this.onDialogAccept();
            }

            public void onDialogReady() {
            }
        };
        Domain domain = this.summary.getDomain();
        this.modeler = ModelerDialog.getInstance(this, new AsyncConstructorListener<ModelerDialog>((DialogController.DialogListener)listener, domain){
            final /* synthetic */ DialogController.DialogListener val$listener;
            final /* synthetic */ Domain val$domain;
            {
                this.val$listener = dialogListener;
                this.val$domain = domain;
            }

            public void asyncConstructorDone(ModelerDialog dialog) {
                dialog.addDialogListener((DialogController.DialogListener<Domain>)this.val$listener);
                MessageHandler.getInstance().closeWaitingDialog();
                dialog.showDialog(this.val$domain);
            }
        });
    }

    public void error(String s, Throwable throwable) {
    }

    public void success(Domain domain) {
        MessageHandler.getInstance().closeWaitingDialog();
        if (this.summary.isShowModeler()) {
            this.showModelEditor();
        } else {
            this.onDialogAccept();
        }
    }

    public void setUploadPath(String path) {
        Document rootDocument = this.mainWizardContainer.getDocumentRoot();
        XulFileUpload upload = (XulFileUpload)rootDocument.getElementById("fileUpload");
        upload.setAction(path);
    }

    public void addDatasource(IWizardDatasource datasource) {
        this.wizardModel.addDatasource(datasource);
    }

    public void removeDatasourceOfType(Class<? extends IWizardDatasource> datasource) {
        this.wizardModel.removeDatasourceByType(datasource);
    }

    public IWizardModel getWizardModel() {
        return this.wizardModel;
    }

    public void setWizardModel(IWizardModel wizardModel) {
        this.wizardModel = wizardModel;
    }

    public ICsvDatasourceServiceAsync getCsvDatasourceService() {
        return this.csvDatasourceService;
    }

    public void setCsvDatasourceService(ICsvDatasourceServiceAsync csvDatasourceService) {
        this.csvDatasourceService = csvDatasourceService;
    }

    public void setReportingOnlyValid(boolean reportingOnlyValid) {
        this.reportingOnlyValid = reportingOnlyValid;
    }

    public boolean isInitialized() {
        return this.initialized;
    }
}

