/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.gwt.widgets.client.dialogs.GlassPane;
import org.pentaho.gwt.widgets.client.dialogs.GlassPaneListener;
import org.pentaho.gwt.widgets.client.dialogs.GlassPaneNativeListener;
import org.pentaho.metadata.model.Domain;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.modeler.ModelerDialog;
import org.pentaho.platform.dataaccess.datasource.ui.selectdialog.GwtDatasourceManageDialog;
import org.pentaho.platform.dataaccess.datasource.ui.selectdialog.GwtDatasourceSelectionDialog;
import org.pentaho.platform.dataaccess.datasource.wizard.EmbeddedWizard;
import org.pentaho.platform.dataaccess.datasource.wizard.jsni.WAQRTransport;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DatasourceServiceGwtImpl;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.util.DialogController;
import org.pentaho.ui.xul.util.XulDialogCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GwtDatasourceEditorEntryPoint
implements EntryPoint {
    private EmbeddedWizard wizard;
    private ModelerDialog modeler;
    private IXulAsyncDatasourceService datasourceService;
    private IXulAsyncConnectionService connectionService;
    private ICsvDatasourceServiceAsync csvService;
    private GwtDatasourceSelectionDialog gwtDatasourceSelectionDialog;
    private EmbeddedWizard gwtDatasourceEditor;
    private GwtDatasourceManageDialog manageDialog;
    private GwtDatasourceSelectionDialog selectDialog;
    private boolean asyncConstructorDone;
    private boolean hasPermissions;

    public void onModuleLoad() {
        this.datasourceService = new DatasourceServiceGwtImpl();
        this.datasourceService.hasPermission(new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                GwtDatasourceEditorEntryPoint.this.setupStandardNativeHooks(GwtDatasourceEditorEntryPoint.this);
                GwtDatasourceEditorEntryPoint.this.initDashboardButtons(false);
            }

            public void success(Boolean retVal) {
                GwtDatasourceEditorEntryPoint.this.hasPermissions = retVal;
                GwtDatasourceEditorEntryPoint.this.setupStandardNativeHooks(GwtDatasourceEditorEntryPoint.this);
                if (retVal.booleanValue()) {
                    GwtDatasourceEditorEntryPoint.this.connectionService = new ConnectionServiceGwtImpl();
                    GwtDatasourceEditorEntryPoint.this.csvService = (ICsvDatasourceServiceAsync)GWT.create(ICsvDatasourceService.class);
                    GwtDatasourceEditorEntryPoint.this.setupPrivilegedNativeHooks(GwtDatasourceEditorEntryPoint.this);
                }
                GwtDatasourceEditorEntryPoint.this.initDashboardButtons(retVal);
            }
        });
    }

    public native void initDashboardButtons(boolean var1);

    private native void setupStandardNativeHooks(GwtDatasourceEditorEntryPoint var1);

    private native void setupPrivilegedNativeHooks(GwtDatasourceEditorEntryPoint var1);

    public void showConfirm(final JavaScriptObject callback, String message, String title, String okText, String cancelText) throws XulException {
        XulConfirmBox confirm = (XulConfirmBox)this.wizard.getMainWizardContainer().getDocumentRoot().createElement("confirmbox");
        confirm.setTitle(title);
        confirm.setMessage(message);
        confirm.setAcceptLabel(okText);
        confirm.setCancelLabel(cancelText);
        confirm.addDialogCallback((XulDialogCallback)new XulDialogCallback<String>(){

            public void onClose(XulComponent component, XulDialogCallback.Status status, String value) {
                if (status == XulDialogCallback.Status.ACCEPT) {
                    GwtDatasourceEditorEntryPoint.this.notifyDialogCallbackSuccess(callback, value);
                }
            }

            public void onError(XulComponent component, Throwable err) {
                GwtDatasourceEditorEntryPoint.this.notifyDialogCallbackError(callback, err.getMessage());
            }
        });
        confirm.open();
    }

    private void addGlassPaneListener(JavaScriptObject obj) {
        GlassPane.getInstance().addGlassPaneListener((GlassPaneListener)new GlassPaneNativeListener(obj));
    }

    private void showWizard(boolean relationalOnlyValid, final JavaScriptObject callback) {
        DialogController.DialogListener<Domain> listener = new DialogController.DialogListener<Domain>(){

            public void onDialogCancel() {
                GwtDatasourceEditorEntryPoint.this.wizard.removeDialogListener(this);
                GwtDatasourceEditorEntryPoint.this.notifyCallbackCancel(callback);
            }

            public void onDialogAccept(Domain domain) {
                GwtDatasourceEditorEntryPoint.this.wizard.removeDialogListener(this);
                WAQRTransport transport = WAQRTransport.createFromMetadata(domain);
                GwtDatasourceEditorEntryPoint.this.notifyCallbackSuccess(callback, true, transport);
            }

            public void onDialogReady() {
                GwtDatasourceEditorEntryPoint.this.notifyCallbackReady(callback);
            }
        };
        if (this.wizard == null) {
            this.wizard = new EmbeddedWizard(false);
            this.wizard.setDatasourceService(this.datasourceService);
            this.wizard.setConnectionService(this.connectionService);
            this.wizard.setCsvDatasourceService(this.csvService);
            this.wizard.setReportingOnlyValid(relationalOnlyValid);
            this.wizard.init(new AsyncConstructorListener<EmbeddedWizard>((DialogController.DialogListener)listener){
                final /* synthetic */ DialogController.DialogListener val$listener;
                {
                    this.val$listener = dialogListener;
                }

                public void asyncConstructorDone(EmbeddedWizard source) {
                    GwtDatasourceEditorEntryPoint.this.wizard.addDialogListener((DialogController.DialogListener<Domain>)this.val$listener);
                    GwtDatasourceEditorEntryPoint.this.wizard.showDialog();
                }
            });
        } else {
            this.wizard.addDialogListener(listener);
            this.wizard.setReportingOnlyValid(relationalOnlyValid);
            this.wizard.showDialog();
        }
    }

    private void showWizardEdit(String domainId, String modelId, boolean relationalOnlyValid, JavaScriptObject callback) {
        this.showWizardEdit(domainId, modelId, ModelerPerspective.REPORTING.name(), relationalOnlyValid, callback);
    }

    private void showWizardEdit(String domainId, String modelId, String perspective, boolean relationalOnlyValid, final JavaScriptObject callback) {
        final String modelPerspective = perspective == null ? ModelerPerspective.REPORTING.name() : perspective;
        DialogController.DialogListener<Domain> listener = new DialogController.DialogListener<Domain>(){

            public void onDialogCancel() {
                GwtDatasourceEditorEntryPoint.this.modeler.removeDialogListener(this);
                GwtDatasourceEditorEntryPoint.this.notifyCallbackCancel(callback);
            }

            public void onDialogAccept(Domain domain) {
                GwtDatasourceEditorEntryPoint.this.modeler.removeDialogListener(this);
                WAQRTransport transport = WAQRTransport.createFromMetadata(domain);
                GwtDatasourceEditorEntryPoint.this.notifyCallbackSuccess(callback, true, transport);
            }

            public void onDialogReady() {
                GwtDatasourceEditorEntryPoint.this.notifyCallbackReady(callback);
            }
        };
        this.modeler = ModelerDialog.getInstance(this.wizard, new AsyncConstructorListener<ModelerDialog>((DialogController.DialogListener)listener, domainId, modelId){
            final /* synthetic */ DialogController.DialogListener val$listener;
            final /* synthetic */ String val$domainId;
            final /* synthetic */ String val$modelId;
            {
                this.val$listener = dialogListener;
                this.val$domainId = string2;
                this.val$modelId = string3;
            }

            public void asyncConstructorDone(ModelerDialog dialog) {
                ModelerPerspective modelerPerspective;
                try {
                    modelerPerspective = ModelerPerspective.valueOf((String)modelPerspective);
                }
                catch (IllegalArgumentException e) {
                    modelerPerspective = ModelerPerspective.REPORTING;
                }
                dialog.addDialogListener((DialogController.DialogListener<Domain>)this.val$listener);
                dialog.showDialog(this.val$domainId, this.val$modelId, modelerPerspective);
            }
        });
    }

    private void deleteLogicalModel(String domainId, String modelName, final JavaScriptObject callback) {
        this.datasourceService.deleteLogicalModel(domainId, modelName, new XulServiceCallback<Boolean>(){

            public void success(Boolean value) {
                GwtDatasourceEditorEntryPoint.this.notifyCallbackSuccess(callback, value);
            }

            public void error(String s, Throwable throwable) {
                GwtDatasourceEditorEntryPoint.this.notifyCallbackError(callback, throwable.getMessage());
            }
        });
    }

    private void showSelectionDialog(String context, String selectDatasource, final JavaScriptObject callback) {
        boolean selectDs = Boolean.valueOf(selectDatasource);
        DialogController.DialogListener<LogicalModelSummary> listener = new DialogController.DialogListener<LogicalModelSummary>(){

            public void onDialogCancel() {
                GwtDatasourceEditorEntryPoint.this.selectDialog.removeDialogListener(this);
                GwtDatasourceEditorEntryPoint.this.asyncConstructorDone = false;
                GwtDatasourceEditorEntryPoint.this.notifyCallbackCancel(callback);
            }

            public void onDialogAccept(LogicalModelSummary logicalModelSummary) {
                GwtDatasourceEditorEntryPoint.this.selectDialog.removeDialogListener(this);
                GwtDatasourceEditorEntryPoint.this.asyncConstructorDone = false;
                GwtDatasourceEditorEntryPoint.this.notifyCallbackSuccess(callback, logicalModelSummary.getDomainId(), logicalModelSummary.getModelId(), logicalModelSummary.getModelName());
            }

            public void onDialogReady() {
            }
        };
        if (this.wizard == null && this.hasPermissions) {
            this.wizard = new EmbeddedWizard(false);
            this.wizard.setDatasourceService(this.datasourceService);
            this.wizard.setConnectionService(this.connectionService);
            this.wizard.setCsvDatasourceService(this.csvService);
        }
        this.showSelectionDialog(context, selectDs, listener);
    }

    private void showSelectionDialog(String context, boolean selectDs, DialogController.DialogListener<LogicalModelSummary> listener) {
        if (selectDs) {
            if (this.selectDialog == null) {
                AsyncConstructorListener<GwtDatasourceSelectionDialog> constructorListener = this.getSelectionDialogListener(listener);
                this.asyncConstructorDone = false;
                this.selectDialog = new GwtDatasourceSelectionDialog(context, this.datasourceService, this.wizard, constructorListener);
            } else {
                this.selectDialog.addDialogListener(listener);
                this.selectDialog.reset();
                this.selectDialog.setContext(context);
                this.selectDialog.showDialog();
            }
        } else if (this.manageDialog == null) {
            AsyncConstructorListener<GwtDatasourceSelectionDialog> constructorListener = this.getSelectionDialogListener(listener);
            this.asyncConstructorDone = false;
            this.manageDialog = new GwtDatasourceManageDialog(this.datasourceService, this.wizard, constructorListener);
        } else {
            this.manageDialog.reset();
            this.manageDialog.showDialog();
        }
    }

    private AsyncConstructorListener<GwtDatasourceSelectionDialog> getSelectionDialogListener(final DialogController.DialogListener<LogicalModelSummary> listener) {
        return new AsyncConstructorListener<GwtDatasourceSelectionDialog>(){

            public void asyncConstructorDone(GwtDatasourceSelectionDialog dialog) {
                dialog.removeDialogListener((DialogController.DialogListener<LogicalModelSummary>)listener);
                dialog.addDialogListener((DialogController.DialogListener<LogicalModelSummary>)listener);
                if (!GwtDatasourceEditorEntryPoint.this.asyncConstructorDone) {
                    dialog.showDialog();
                }
                GwtDatasourceEditorEntryPoint.this.asyncConstructorDone = true;
            }
        };
    }

    private native void notifyCallbackSuccess(JavaScriptObject var1, String var2, String var3, String var4);

    private native void notifyCallbackSuccess(JavaScriptObject var1, String var2, String var3);

    private native void notifyCallbackSuccess(JavaScriptObject var1, Boolean var2, WAQRTransport var3);

    private native void notifyCallbackSuccess(JavaScriptObject var1, Boolean var2);

    private native void notifyCallbackError(JavaScriptObject var1, String var2);

    private native void notifyCallbackCancel(JavaScriptObject var1);

    private native void notifyCallbackReady(JavaScriptObject var1);

    private native void notifyDialogCallbackSuccess(JavaScriptObject var1, Object var2);

    private native void notifyDialogCallbackCancel(JavaScriptObject var1);

    private native void notifyDialogCallbackError(JavaScriptObject var1, String var2);
}

