/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.ConnectionDialogListener;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncConnectionService;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseConnectionService;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseDialectService;
import org.pentaho.ui.database.services.IXulAsyncDatabaseConnectionService;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class WizardConnectionController
extends AbstractXulEventHandler {
    private IXulAsyncConnectionService connectionService;
    private List<ConnectionDialogListener> listeners = new ArrayList<ConnectionDialogListener>();
    private DatasourceModel datasourceModel;
    private XulDialog removeConfirmationDialog;
    private XulDialog saveConnectionConfirmationDialog;
    private XulDialog errorDialog;
    private XulDialog errorDetailsDialog;
    private XulDialog successDialog;
    private XulDialog successDetailsDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    GwtXulAsyncDatabaseConnectionService connService = new GwtXulAsyncDatabaseConnectionService();
    GwtXulAsyncDatabaseDialectService dialectService = new GwtXulAsyncDatabaseDialectService();
    GwtDatabaseDialog databaseDialog;
    DatabaseTypeHelper databaseTypeHelper;
    IConnection currentConnection;
    ConnectionSetter connectionSetter = new ConnectionSetter();

    public WizardConnectionController(Document document) {
        this.document = document;
        this.init();
    }

    @Bindable
    public void init() {
        XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List<IDatabaseType> retVal) {
                WizardConnectionController.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
            }
        };
        this.dialectService.getDatabaseTypes((XulServiceCallback)callback);
        this.saveConnectionConfirmationDialog = (XulDialog)this.document.getElementById("saveConnectionConfirmationDialog");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorDetailsDialog = (XulDialog)this.document.getElementById("errorDetailsDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successDetailsDialog = (XulDialog)this.document.getElementById("successDetailsDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.removeConfirmationDialog = (XulDialog)this.document.getElementById("removeConfirmationDialog");
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void closeSuccessDetailsDialog() {
        if (!this.successDetailsDialog.isHidden()) {
            this.successDetailsDialog.hide();
        }
    }

    @Bindable
    public void toggleDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("details_hider")).isVisible());
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    @Bindable
    public void toggleSuccessDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("success_details_hider")).isVisible());
    }

    @Bindable
    public void closeErrorDetailsDialog() {
        if (!this.errorDetailsDialog.isHidden()) {
            this.errorDetailsDialog.hide();
        }
    }

    public void setDatasourceModel(DatasourceModel model) {
        this.datasourceModel = model;
    }

    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public String getName() {
        return "connectionController";
    }

    @Bindable
    public void closeDialog() {
        for (ConnectionDialogListener listener : this.listeners) {
            listener.onDialogCancel();
        }
    }

    @Bindable
    public void closeSaveConnectionConfirmationDialog() {
        this.saveConnectionConfirmationDialog.hide();
    }

    @Bindable
    public void addConnection() {
        try {
            this.connectionService.testConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    WizardConnectionController.this.saveConnectionConfirmationDialog.show();
                }

                public void success(Boolean value) {
                    if (value.booleanValue()) {
                        WizardConnectionController.this.saveConnection();
                    } else {
                        WizardConnectionController.this.saveConnectionConfirmationDialog.show();
                    }
                }
            });
        }
        catch (Exception e) {
            this.saveConnectionConfirmationDialog.show();
        }
    }

    @Bindable
    public void testConnection() {
        try {
            this.connectionService.testConnection(this.currentConnection, new XulServiceCallback<Boolean>(){

                public void error(String message, Throwable error) {
                    WizardConnectionController.this.displayErrorMessage(error);
                }

                public void success(Boolean value) {
                    try {
                        if (value.booleanValue()) {
                            WizardConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_TEST_SUCCESS"));
                        } else {
                            WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0003_CONNECTION_TEST_FAILED"));
                        }
                    }
                    catch (Exception e) {
                        WizardConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (Exception e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void deleteConnection() {
        this.removeConfirmationDialog.hide();
        this.connectionService.deleteConnection(this.datasourceModel.getSelectedRelationalConnection().getName(), new XulServiceCallback<Boolean>(){

            public void error(String message, Throwable error) {
                WizardConnectionController.this.displayErrorMessage(error);
            }

            public void success(Boolean value) {
                try {
                    if (value.booleanValue()) {
                        WizardConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_DELETED"));
                        WizardConnectionController.this.datasourceModel.getGuiStateModel().deleteConnection(WizardConnectionController.this.datasourceModel.getSelectedRelationalConnection().getName());
                        List<IConnection> connections = WizardConnectionController.this.datasourceModel.getGuiStateModel().getConnections();
                        if (connections != null && connections.size() > 0) {
                            WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(connections.get(connections.size() - 1));
                        } else {
                            WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(null);
                        }
                    } else {
                        WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                    }
                }
                catch (Exception e) {
                    WizardConnectionController.this.displayErrorMessage(e);
                }
            }
        });
    }

    @Bindable
    public void saveConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.saveConnectionConfirmationDialog.hide();
        }
        this.connectionService.getConnectionByName(this.currentConnection.getName(), new XulServiceCallback<IConnection>(){

            public void error(String message, Throwable error) {
                WizardConnectionController.this.connectionService.addConnection(WizardConnectionController.this.currentConnection, new XulServiceCallback<Boolean>(){

                    public void error(String message, Throwable error) {
                        WizardConnectionController.this.displayErrorMessage(error);
                    }

                    public void success(Boolean value) {
                        try {
                            if (value.booleanValue()) {
                                WizardConnectionController.this.datasourceModel.getGuiStateModel().addConnection(WizardConnectionController.this.currentConnection);
                                WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(WizardConnectionController.this.currentConnection);
                            } else {
                                WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0001_UNABLE_TO_ADD_CONNECTION"));
                            }
                        }
                        catch (Exception e) {
                            WizardConnectionController.this.displayErrorMessage(e);
                        }
                    }
                });
            }

            public void success(IConnection value) {
                WizardConnectionController.this.connectionService.updateConnection(WizardConnectionController.this.currentConnection, new XulServiceCallback<Boolean>(){

                    public void error(String message, Throwable error) {
                        WizardConnectionController.this.displayErrorMessage(error);
                    }

                    public void success(Boolean value) {
                        try {
                            if (value.booleanValue()) {
                                WizardConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_UPDATED"));
                                WizardConnectionController.this.datasourceModel.getGuiStateModel().updateConnection(WizardConnectionController.this.currentConnection);
                                WizardConnectionController.this.datasourceModel.setSelectedRelationalConnection(WizardConnectionController.this.currentConnection);
                            } else {
                                WizardConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0004_UNABLE_TO_UPDATE_CONNECTION"));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    public void addConnectionDialogListener(ConnectionDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConnectionDialogListener(ConnectionDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    @Bindable
    public void onDialogAccept(IDatabaseConnection arg0) {
        this.connectionService.convertToConnection(arg0, new XulServiceCallback<IConnection>(){

            public void error(String message, Throwable error) {
                WizardConnectionController.this.displayErrorMessage(error);
            }

            public void success(IConnection retVal) {
                WizardConnectionController.this.currentConnection = retVal;
                WizardConnectionController.this.addConnection();
            }
        });
    }

    @Bindable
    public void onDialogCancel() {
    }

    @Bindable
    public void onDialogReady() {
        if (this.datasourceModel.isEditing()) {
            this.showEditConnectionDialog();
        } else {
            this.showAddConnectionDialog();
        }
    }

    @Bindable
    public void showAddConnectionDialog() {
        this.datasourceModel.setEditing(false);
        if (this.databaseDialog != null) {
            this.databaseDialog.setDatabaseConnection(null);
            this.databaseDialog.show();
        } else {
            this.databaseDialog = new GwtDatabaseDialog((IXulAsyncDatabaseConnectionService)this.connService, this.databaseTypeHelper, "dataaccess-databasedialog.xul", (DatabaseDialogListener)this.connectionSetter);
        }
    }

    @Bindable
    public void showEditConnectionDialog() {
        this.datasourceModel.setEditing(true);
        if (this.databaseDialog != null) {
            IConnection connection = this.datasourceModel.getSelectedRelationalConnection();
            this.connectionService.convertFromConnection(connection, new XulServiceCallback<IDatabaseConnection>(){

                public void error(String message, Throwable error) {
                    WizardConnectionController.this.displayErrorMessage(error);
                }

                public void success(IDatabaseConnection conn) {
                    WizardConnectionController.this.databaseDialog.setDatabaseConnection(conn);
                    WizardConnectionController.this.databaseDialog.show();
                }
            });
        } else {
            this.databaseDialog = new GwtDatabaseDialog((IXulAsyncDatabaseConnectionService)this.connService, this.databaseTypeHelper, "dataaccess-databasedialog.xul", (DatabaseDialogListener)this.connectionSetter);
        }
    }

    @Bindable
    public void showRemoveConnectionDialog() {
        this.removeConfirmationDialog.show();
    }

    @Bindable
    public void closeRemoveConfirmationDialog() {
        this.removeConfirmationDialog.hide();
    }

    public IXulAsyncConnectionService getConnectionService() {
        return this.connectionService;
    }

    public void setConnectionService(IXulAsyncConnectionService connectionService) {
        this.connectionService = connectionService;
    }

    class ConnectionSetter
    implements DatabaseDialogListener {
        ConnectionSetter() {
        }

        public void onDialogAccept(IDatabaseConnection connection) {
            WizardConnectionController.this.connectionService.convertToConnection(connection, new XulServiceCallback<IConnection>(){

                public void error(String message, Throwable error) {
                    WizardConnectionController.this.displayErrorMessage(error);
                }

                public void success(IConnection retVal) {
                    WizardConnectionController.this.currentConnection = retVal;
                    WizardConnectionController.this.addConnection();
                }
            });
        }

        public void onDialogCancel() {
        }

        public void onDialogReady() {
            if (!WizardConnectionController.this.datasourceModel.isEditing()) {
                WizardConnectionController.this.showAddConnectionDialog();
            } else {
                WizardConnectionController.this.showEditConnectionDialog();
            }
        }
    }
}

