/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.csv;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.logging.LogWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvInspector {
    protected LogWriter log = LogWriter.getInstance();

    public int determineFileFormat(String line) {
        int type = -1;
        int n = line.length();
        char c1 = '\u0000';
        char c2 = '\u0000';
        if (n > 0) {
            c1 = line.charAt(n - 1);
            if (n > 1) {
                c2 = line.charAt(n - 2);
            }
            if (c1 == '\n' || c1 == '\r') {
                type = c2 == '\n' || c2 == '\r' ? 0 : 1;
            }
        }
        return type;
    }

    public List<String> getColumnData(int columnNumber, String[][] data) {
        ArrayList<String> dataSample = new ArrayList<String>(data.length);
        for (String[] row : data) {
            dataSample.add(row[columnNumber]);
        }
        return dataSample;
    }

    public String guessDelimiter(String line) {
        int numTabs = 0;
        int numCommas = 0;
        int numPipes = 0;
        int numTildas = 0;
        int numColons = 0;
        int numSemiColons = 0;
        block8: for (int idx = 0; idx < line.length(); ++idx) {
            char c = line.charAt(idx);
            switch (c) {
                case '\t': {
                    ++numTabs;
                    continue block8;
                }
                case ',': {
                    ++numCommas;
                    continue block8;
                }
                case '|': {
                    ++numPipes;
                    continue block8;
                }
                case '~': {
                    ++numTildas;
                    continue block8;
                }
                case ':': {
                    ++numColons;
                    continue block8;
                }
                case ';': {
                    ++numSemiColons;
                }
            }
        }
        int max = Math.max(numTabs, numCommas);
        max = Math.max(max, numPipes);
        max = Math.max(max, numTildas);
        max = Math.max(max, numColons);
        if ((max = Math.max(max, numSemiColons)) == 0) {
            return null;
        }
        if (max == numCommas) {
            return ",";
        }
        if (max == numTabs) {
            return "\t";
        }
        if (max == numPipes) {
            return "|";
        }
        if (max == numTildas) {
            return "~";
        }
        if (max == numColons) {
            return ":";
        }
        if (max == numSemiColons) {
            return ";";
        }
        return null;
    }
}

