/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.csv;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.pentaho.platform.dataaccess.datasource.wizard.models.FileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.PentahoSystemHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;

public class FileUtils {
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;

    public FileInfo[] listFiles() {
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        File folder = new File(path);
        if (folder.exists()) {
            File[] files;
            for (File file : files = folder.listFiles()) {
                String name = file.getName();
                if (!file.isFile()) continue;
                long lastModified = file.lastModified();
                DateFormat fmt = LocaleHelper.getShortDateFormat((boolean)true, (boolean)true);
                Date modified = new Date();
                modified.setTime(lastModified);
                String modifiedStr = fmt.format(modified);
                long size = file.length();
                FileInfo info = new FileInfo();
                info.setModified(modifiedStr);
                info.setName(name);
                info.setSize(size);
                fileList.add(info);
            }
        }
        return fileList.toArray(new FileInfo[fileList.size()]);
    }

    public Boolean deleteFile(String aFileName) {
        boolean result = false;
        String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        File file = new File(path + File.separatorChar + aFileName);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    static {
        PentahoSystemHelper.init();
    }
}

