/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvFileInfo
extends XulEventSourceAdapter
implements Serializable {
    public static final String HEADER_ROWS_ATTRIBUTE = "headerRows";
    public static final String ENCLOSURE_ATTRIBUTE = "enclosure";
    public static final String DELIMITER_ATTRIBUTE = "delimiter";
    public static final String TMP_FILENAME_ATTRIBUTE = "tmpFilename";
    public static final String ENCODING = "encoding";
    public static final String DEFAULT_COLUMN_NAME_PREFIX = "Field_";
    private static final long serialVersionUID = 2498165533158482382L;
    private List<String> contents;
    private String delimiter = ",";
    private String enclosure = "\"";
    private String encoding;
    private int headerRows = 1;
    private String project;
    private String tmpFilename;
    private String filename;
    private String currencySymbol = "";
    private String decimalSymbol = ".";
    private String groupSymbol = ",";
    private String ifNull = "---";
    private String nullStr = "";
    public static final String FRIENDLY_FILENAME_ATTRIBUTE = "friendlyFilename";
    private String friendlyFilename;
    private String savedEncoding;

    @Bindable
    public String getIfNull() {
        return this.ifNull;
    }

    @Bindable
    public void setIfNull(String ifNull) {
        this.ifNull = ifNull;
    }

    @Bindable
    public String getNullStr() {
        return this.nullStr;
    }

    @Bindable
    public void setNullStr(String nullStr) {
        this.nullStr = nullStr;
    }

    @Bindable
    public List<String> getContents() {
        return this.contents;
    }

    @Bindable
    public void setContents(List<String> contents) {
        this.contents = contents;
    }

    @Bindable
    public String getDelimiter() {
        return this.delimiter;
    }

    @Bindable
    public void setDelimiter(String delimiter) {
        String previousVal = this.delimiter;
        this.delimiter = delimiter;
        this.firePropertyChange(DELIMITER_ATTRIBUTE, previousVal, delimiter);
    }

    @Bindable
    public String getEnclosure() {
        return this.enclosure;
    }

    @Bindable
    public void setEnclosure(String enclosure) {
        String previousVal = this.enclosure;
        this.enclosure = enclosure;
        this.firePropertyChange(ENCLOSURE_ATTRIBUTE, previousVal, enclosure);
    }

    @Bindable
    public int getHeaderRows() {
        return this.headerRows;
    }

    @Bindable
    public void setHeaderRows(int headerRows) {
        int previousVal = this.headerRows;
        this.headerRows = headerRows;
        this.firePropertyChange(HEADER_ROWS_ATTRIBUTE, previousVal, this.headerRows);
    }

    @Bindable
    public String getProject() {
        return this.project;
    }

    @Bindable
    public void setProject(String project) {
        this.project = project;
    }

    @Bindable
    public String getTmpFilename() {
        return this.tmpFilename;
    }

    @Bindable
    public void setTmpFilename(String filename) {
        String previousVal = this.tmpFilename;
        this.tmpFilename = filename;
        this.firePropertyChange(TMP_FILENAME_ATTRIBUTE, previousVal, filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String file) {
        this.filename = file;
    }

    @Bindable
    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    @Bindable
    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }

    @Bindable
    public String getDecimalSymbol() {
        return this.decimalSymbol;
    }

    @Bindable
    public void setDecimalSymbol(String decimalSymbol) {
        this.decimalSymbol = decimalSymbol;
    }

    @Bindable
    public String getGroupSymbol() {
        return this.groupSymbol;
    }

    @Bindable
    public void setGroupSymbol(String groupSymbol) {
        this.groupSymbol = groupSymbol;
    }

    @Bindable
    public String getEncoding() {
        return this.encoding;
    }

    @Bindable
    public void setEncoding(String encoding) {
        String previousVal = this.encoding;
        this.encoding = encoding;
        this.firePropertyChange(ENCODING, previousVal, encoding);
    }

    public void setEncodingFromServer(String encoding) {
        if (this.savedEncoding != null && !this.savedEncoding.trim().equals("")) {
            this.setEncoding(this.savedEncoding);
            this.savedEncoding = null;
        } else {
            this.setEncoding(encoding);
        }
    }

    public void setSavedEncoding(String encoding) {
        this.savedEncoding = encoding;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.currencySymbol == null ? 0 : this.currencySymbol.hashCode());
        result = 31 * result + (this.decimalSymbol == null ? 0 : this.decimalSymbol.hashCode());
        result = 31 * result + (this.delimiter == null ? 0 : this.delimiter.hashCode());
        result = 31 * result + (this.enclosure == null ? 0 : this.enclosure.hashCode());
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        result = 31 * result + (this.tmpFilename == null ? 0 : this.tmpFilename.hashCode());
        result = 31 * result + (this.groupSymbol == null ? 0 : this.groupSymbol.hashCode());
        result = 31 * result + this.headerRows;
        result = 31 * result + (this.ifNull == null ? 0 : this.ifNull.hashCode());
        result = 31 * result + (this.nullStr == null ? 0 : this.nullStr.hashCode());
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CsvFileInfo other = (CsvFileInfo)obj;
        if (this.currencySymbol == null ? other.currencySymbol != null : !this.currencySymbol.equals(other.currencySymbol)) {
            return false;
        }
        if (this.decimalSymbol == null ? other.decimalSymbol != null : !this.decimalSymbol.equals(other.decimalSymbol)) {
            return false;
        }
        if (this.delimiter == null ? other.delimiter != null : !this.delimiter.equals(other.delimiter)) {
            return false;
        }
        if (this.enclosure == null ? other.enclosure != null : !this.enclosure.equals(other.enclosure)) {
            return false;
        }
        if (this.encoding == null ? other.encoding != null : !this.encoding.equals(other.encoding)) {
            return false;
        }
        if (this.tmpFilename == null ? other.tmpFilename != null : !this.tmpFilename.equals(other.tmpFilename)) {
            return false;
        }
        if (this.groupSymbol == null ? other.groupSymbol != null : !this.groupSymbol.equals(other.groupSymbol)) {
            return false;
        }
        if (this.headerRows != other.headerRows) {
            return false;
        }
        if (this.ifNull == null ? other.ifNull != null : !this.ifNull.equals(other.ifNull)) {
            return false;
        }
        if (this.nullStr == null ? other.nullStr != null : !this.nullStr.equals(other.nullStr)) {
            return false;
        }
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    public List<List<String>> parseSampleContents() {
        String delim = this.getDelimiter();
        if (this.contents == null) {
            throw new IllegalStateException("Sample Contents is null, nothing to parse");
        }
        if (delim == null || "".equals(delim)) {
            delim = "~!@#$%";
        }
        ArrayList<List<String>> sample = new ArrayList<List<String>>();
        String enclosure = null;
        if (!"".equals(this.getEnclosure())) {
            enclosure = this.getEnclosure();
        }
        for (String line : this.contents) {
            CSVTokenizer csvTokenizer = new CSVTokenizer(line, delim, enclosure);
            ArrayList<String> rowData = new ArrayList<String>();
            int count = 0;
            while (csvTokenizer.hasMoreTokens()) {
                rowData.add(csvTokenizer.nextToken());
                ++count;
            }
            sample.add(rowData);
        }
        return sample;
    }

    public String formatSampleContents() {
        List<List<String>> parsed;
        StringBuilder sb = new StringBuilder();
        String padding = "  ";
        try {
            parsed = this.parseSampleContents();
        }
        catch (IllegalStateException e) {
            return "";
        }
        int maxColumns = this.getMaxColumnCount(parsed);
        if (this.getHeaderRows() == 0) {
            List<String> dummy = this.getDummyHeader(maxColumns);
            parsed.add(0, dummy);
        }
        int[] widths = this.getMaxWidths(parsed, maxColumns);
        int lineNumber = 0;
        StringBuilder headerMarker = new StringBuilder();
        int lineWidth = 0;
        for (int w = 0; w < widths.length; ++w) {
            lineWidth += widths[w] + padding.length();
        }
        for (int x = 0; x < lineWidth; ++x) {
            headerMarker.append("-");
        }
        for (List<String> line : parsed) {
            for (int i = 0; i < line.size(); ++i) {
                String field = line.get(i);
                sb.append(this.padField(field, widths[i]));
                sb.append(padding);
            }
            sb.append("\n");
            if (lineNumber == 0) {
                sb.append(headerMarker.toString());
                sb.append("\n");
            }
            ++lineNumber;
        }
        return sb.toString();
    }

    private List<String> getDummyHeader(int maxColumns) {
        ArrayList<String> dummy = new ArrayList<String>(maxColumns);
        DecimalFormat df = new DecimalFormat("000");
        for (int i = 0; i < maxColumns; ++i) {
            dummy.add(DEFAULT_COLUMN_NAME_PREFIX + df.format(i + 1));
        }
        return dummy;
    }

    private String padField(String field, int totalWidth) {
        StringBuilder sb = new StringBuilder(field);
        if (field.length() < totalWidth) {
            for (int i = field.length(); i < totalWidth; ++i) {
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    private int[] getMaxWidths(List<List<String>> parsedContents, int columns) {
        if (parsedContents != null && parsedContents.size() > 0) {
            int[] widths = new int[columns];
            for (List<String> lines : parsedContents) {
                for (int i = 0; i < lines.size(); ++i) {
                    String field = lines.get(i);
                    widths[i] = field.length() > widths[i] ? field.length() : widths[i];
                }
            }
            return widths;
        }
        return null;
    }

    private int getMaxColumnCount(List<List<String>> parsedContents) {
        int max = 0;
        for (List<String> line : parsedContents) {
            max = line.size() > max ? line.size() : max;
        }
        return max;
    }

    @Bindable
    public String getFriendlyFilename() {
        return this.friendlyFilename;
    }

    @Bindable
    public void setFriendlyFilename(String friendlyFilename) {
        String previousVal = this.friendlyFilename;
        this.friendlyFilename = friendlyFilename;
        this.firePropertyChange(FRIENDLY_FILENAME_ATTRIBUTE, previousVal, friendlyFilename);
    }

    public void clear() {
        this.setDelimiter(",");
        this.setContents(null);
        this.setCurrencySymbol("");
        this.setEnclosure("\"");
        this.setEncoding("");
        this.setTmpFilename(null);
        this.setFilename(null);
        this.setFriendlyFilename(null);
        this.setGroupSymbol(",");
        this.setCurrencySymbol("");
        this.setDecimalSymbol(".");
        this.setHeaderRows(1);
        this.setIfNull("---");
        this.setNullStr("");
        this.setProject(null);
        this.formatSampleContents();
    }
}

