/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

public class FileInfo
extends XulEventSourceAdapter
implements Serializable {
    private static final long serialVersionUID = 3416165533158485182L;
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private String name;
    private long size;
    private String modified;
    private String sizeStr;

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public static String getSizeStr(long size) {
        String str;
        if (size > 0x40000000L) {
            DecimalFormat fmt = new DecimalFormat("#.##GB");
            str = fmt.format((double)size / 1.073741824E9);
        } else if (size > 0x100000L) {
            DecimalFormat fmt = new DecimalFormat("#.#MB");
            str = fmt.format((double)size / 1048576.0);
        } else {
            DecimalFormat fmt = new DecimalFormat("#KB");
            str = fmt.format((double)size / 1024.0);
        }
        return str;
    }

    public void setSize(long size) {
        this.size = size;
        this.sizeStr = FileInfo.getSizeStr(size);
    }

    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public String getSizeStr() {
        return this.sizeStr;
    }
}

