/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.agile;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.JndiDatasourceService;

public class AgileHelper {
    public static final String PLUGIN_NAME = "data-access";
    private static final String STAGING_SCHEMA = "data-access-staging-schema";
    private static final String STAGING_JNDI = "data-access-staging-jndi";
    private static final String FILES_PATH = "data-access-files-path";
    private static final String TEMP_FILES_PATH = "data-access-tmp-files-path";
    private static final String SETTINGS_FILE = "data-access/settings.xml";
    private static final String DATASOURCE_SOLUTION_STORAGE = "data-access-datasource-solution-storage";
    private static final String CSV_SAMPLE_SIZE = "data-access-csv-sample-rows";
    private static final Log logger = LogFactory.getLog(AgileHelper.class);
    private static long contentLength = 0L;

    public static String getSchemaName() {
        return PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)STAGING_SCHEMA, null);
    }

    public static String getDatasourceSolutionStorage() {
        return PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)DATASOURCE_SOLUTION_STORAGE, (String)"admin");
    }

    public static String getDialect(DatabaseMeta meta, String jndiName) {
        String dialect = null;
        try {
            Connection conn = AgileHelper.getConnection(jndiName);
            dialect = conn.getMetaData().getDatabaseProductName();
            if (dialect.indexOf("HSQL") >= 0) {
                dialect = "Hypersonic";
            }
            conn.close();
        }
        catch (SQLException e) {
            logger.debug((Object)"Error determining database type from connection", (Throwable)e);
        }
        catch (DatasourceServiceException e) {
            logger.debug((Object)"Error determining database type from connection - getting JNDI connection", (Throwable)e);
        }
        return dialect;
    }

    public static String getDialect(DatabaseMeta meta) {
        return AgileHelper.getDialect(meta, AgileHelper.getJndiName());
    }

    public static String generateTableName(String filename) {
        return filename.replace('.', '_');
    }

    public static String getJndiName() {
        return PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)STAGING_JNDI, null);
    }

    public static int getCsvSampleRowSize() {
        String sampleSize = PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)CSV_SAMPLE_SIZE, null);
        if (sampleSize != null) {
            return Integer.valueOf(sampleSize);
        }
        return 100;
    }

    public static DatabaseMeta getDatabaseMeta() {
        String jndi = AgileHelper.getJndiName();
        DatabaseMeta databaseMeta = new DatabaseMeta();
        databaseMeta.setAccessType(4);
        databaseMeta.setDBName(jndi);
        databaseMeta.setName(jndi);
        String dialect = AgileHelper.getDialect(databaseMeta);
        databaseMeta.setDatabaseType(dialect);
        databaseMeta.setQuoteAllFields(true);
        return databaseMeta;
    }

    public static Connection getConnection(String jndiName) throws DatasourceServiceException, SQLException {
        JndiDatasourceService jndiService = new JndiDatasourceService();
        DataSource ds = jndiService.getDataSource(jndiName);
        return ds.getConnection();
    }

    public static String getFolderPath(String project) {
        String folderPath = PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)FILES_PATH, null);
        if (folderPath != null) {
            folderPath = PentahoSystem.getApplicationContext().getSolutionPath(folderPath + project);
        }
        return folderPath;
    }

    public static String getTmpFolderPath(String project) {
        String folderPath = PentahoSystem.getSystemSetting((String)SETTINGS_FILE, (String)TEMP_FILES_PATH, null);
        if (folderPath != null) {
            folderPath = PentahoSystem.getApplicationContext().getSolutionPath(folderPath + project);
        }
        return folderPath;
    }

    public static String getProjectMetadataFolder(String project) {
        return project + "/resources/metadata";
    }
}

