/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.agile;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.StagingTransformGenerator;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class CsvTransformGenerator
extends StagingTransformGenerator {
    private static final long serialVersionUID = -185098401772609035L;
    private static final String CSV_INPUT = "csvinput";
    private static final String SELECT_VALUES = "select";
    private static final String CALC_DATES = "calc dates";
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;
    public static final String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + File.separatorChar + "tmp" + File.separatorChar;
    private static final Log log = LogFactory.getLog(CsvTransformGenerator.class);

    public CsvTransformGenerator(ModelInfo info) {
        this.setModelInfo(info);
        this.init();
    }

    public CsvTransformGenerator(ModelInfo info, DatabaseMeta databaseMeta) {
        super(databaseMeta);
        this.setModelInfo(info);
        this.init();
    }

    private void init() {
        this.setTransformStats(this.getModelInfo().getTransformStats());
        this.setTableName(this.getModelInfo().getStageTableName());
    }

    protected String[] getIndexedColumnNames() {
        ArrayList<String> indexed = new ArrayList<String>();
        for (ColumnInfo column : this.getModelInfo().getColumns()) {
            if (!column.isIndex()) continue;
            indexed.add(column.getId());
        }
        return indexed.toArray(new String[indexed.size()]);
    }

    protected StepMeta[] getSteps(TransMeta transMeta) {
        ArrayList<StepMeta> steps = new ArrayList<StepMeta>();
        StepMeta inputStep = this.createInputStep(transMeta);
        steps.add(inputStep);
        StepMeta step = this.createSelectStep(transMeta, SELECT_VALUES);
        if (step != null) {
            steps.add(step);
            this.createHop(inputStep, step, transMeta);
        }
        return steps.toArray(new StepMeta[steps.size()]);
    }

    protected StepMeta createInputStep(TransMeta transMeta) {
        String path;
        CsvInputMeta csvInputMeta = new CsvInputMeta();
        CsvFileInfo fileInfo = this.getModelInfo().getFileInfo();
        String fileName = fileInfo.getTmpFilename();
        if (fileName.endsWith(".tmp")) {
            path = PentahoSystem.getApplicationContext().getSolutionPath(TMP_FILE_PATH);
        } else {
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        }
        File file = new File(path + fileInfo.getTmpFilename());
        String filename = file.getAbsolutePath();
        ColumnInfo[] columns = this.getModelInfo().getColumns();
        TextFileInputField[] inputFields = new TextFileInputField[columns.length];
        int idx = 0;
        for (ColumnInfo column : columns) {
            TextFileInputField field = new TextFileInputField();
            field.setCurrencySymbol(fileInfo.getCurrencySymbol());
            field.setDecimalSymbol(fileInfo.getCurrencySymbol());
            field.setFormat(column.getFormat());
            field.setGroupSymbol(fileInfo.getGroupSymbol());
            field.setIfNullValue(fileInfo.getIfNull());
            field.setIgnored(column.isIgnore());
            field.setLength(column.getLength());
            field.setName(column.getId());
            field.setNullString(fileInfo.getNullStr());
            field.setPrecision(column.getPrecision());
            field.setRepeated(false);
            field.setSamples(null);
            field.setTrimType(3);
            field.setType(this.convertDataType(column));
            inputFields[idx] = field;
            ++idx;
        }
        csvInputMeta.setAddResultFile(false);
        csvInputMeta.setBufferSize("5000");
        csvInputMeta.setDelimiter(fileInfo.getDelimiter());
        csvInputMeta.setEnclosure(fileInfo.getEnclosure());
        csvInputMeta.setEncoding(fileInfo.getEncoding());
        csvInputMeta.setFilename(filename);
        csvInputMeta.setFilenameField(null);
        csvInputMeta.setHeaderPresent(fileInfo.getHeaderRows() > 0);
        csvInputMeta.setIncludingFilename(false);
        csvInputMeta.setInputFields(inputFields);
        csvInputMeta.setLazyConversionActive(true);
        csvInputMeta.setRowNumField("");
        csvInputMeta.setRunningInParallel(false);
        StepMeta csvInputStepMeta = new StepMeta(CSV_INPUT, CSV_INPUT, (StepMetaInterface)csvInputMeta);
        csvInputStepMeta.setStepErrorMeta(new StepErrorMeta((VariableSpace)transMeta, csvInputStepMeta));
        transMeta.addStep(csvInputStepMeta);
        this.csvErrorRowCount = 0L;
        final FileTransformStats stats = this.getTransformStats();
        StepErrorMeta csvInputErrorMeta = new StepErrorMeta((VariableSpace)transMeta, csvInputStepMeta){

            public void addErrorRowData(Object[] row, int startIndex, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
                if (CsvTransformGenerator.this.csvErrorRowCount < CsvTransformGenerator.this.maxErrorRows) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Rejected Row: ");
                    for (Object rowData : row) {
                        sb.append(rowData);
                        sb.append(", ");
                    }
                    sb.append("\r\n");
                    ((ArrayList)stats.getErrors()).add(sb.toString() + errorDescriptions);
                }
                ++CsvTransformGenerator.this.csvErrorRowCount;
                stats.setErrorCount(CsvTransformGenerator.this.csvErrorRowCount);
                super.addErrorRowData(row, startIndex, nrErrors, errorDescriptions, fieldNames, errorCodes);
            }
        };
        StepMeta outputDummyStepMeta = this.addDummyStep(transMeta, "CSVInputErrorDummy");
        csvInputErrorMeta.setTargetStep(outputDummyStepMeta);
        csvInputErrorMeta.setEnabled(true);
        csvInputStepMeta.setStepErrorMeta(csvInputErrorMeta);
        return csvInputStepMeta;
    }

    protected StepMeta createSelectStep(TransMeta transMeta, String stepName) {
        SelectValuesMeta meta = new SelectValuesMeta();
        ArrayList<String> deleteNameList = new ArrayList<String>();
        for (ColumnInfo column : this.getModelInfo().getColumns()) {
            if (!column.isIgnore()) continue;
            deleteNameList.add(column.getId());
        }
        if (deleteNameList.size() == 0) {
            return null;
        }
        String[] deleteName = deleteNameList.toArray(new String[deleteNameList.size()]);
        meta.setDeleteName(deleteName);
        StepMeta stepMeta = new StepMeta(stepName, stepName, (StepMetaInterface)meta);
        transMeta.addStep(stepMeta);
        return stepMeta;
    }

    public Log getLogger() {
        return log;
    }
}

