/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.agile;

import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;

public class PdiTransListener
implements TransListener,
Runnable {
    private StepInterface step;
    private Trans trans;
    private FileTransformStats transformStats;
    private boolean finished = false;
    private long rowsDone = 0L;

    public PdiTransListener(Trans trans, StepInterface step, FileTransformStats transformStats) {
        this.step = step;
        this.trans = trans;
        this.transformStats = transformStats;
    }

    public void cancel() {
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void run() {
        while (!this.finished && !this.trans.isFinished()) {
            try {
                this.rowsDone = this.step.getLinesOutput();
                this.transformStats.setTotalRecords(this.rowsDone);
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.doFinish();
    }

    private void doFinish() {
        int errorCount = this.trans.getErrors();
        try {
            this.trans.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.transformStats.setRowsFinished(true);
        this.transformStats.setTotalRecords(this.step.getLinesRead());
        this.transformStats.setErrorCount(this.step.getLinesRead() - this.step.getLinesWritten());
        this.finished = true;
    }

    public void transFinished(Trans trans) {
        this.doFinish();
    }

    public void transActive(Trans trans) {
    }

    public void transIdle(Trans trans) {
    }

    public void transStarted(Trans trans) {
    }
}

