/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.tree.DefaultElement;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.InlineEtlPhysicalModel;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.SQLModelGenerator;
import org.pentaho.metadata.util.SQLModelGeneratorException;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.beans.BogoPojo;
import org.pentaho.platform.dataaccess.datasource.beans.BusinessData;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.beans.SerializedResultSet;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.FileUtils;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvTransformGeneratorException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.QueryValidationException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.CsvTransformGenerator;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.CsvDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.DatasourceServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasourceSummary;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.uifoundation.component.xml.PMDUIComponent;
import org.pentaho.platform.util.logging.SimpleLogger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceServiceImpl
implements IDatasourceService {
    private static final Log logger = LogFactory.getLog(DatasourceServiceImpl.class);
    private IDataAccessPermissionHandler dataAccessPermHandler;
    private IDataAccessViewPermissionHandler dataAccessViewPermHandler;
    private IMetadataDomainRepository metadataDomainRepository;
    private static final String BEFORE_QUERY = " SELECT * FROM (";
    private static final String AFTER_QUERY = ") tbl";
    private IConnectionService connectionService;
    private GeoContext geoContext;

    public DatasourceServiceImpl() {
        this(new ConnectionServiceImpl());
    }

    public DatasourceServiceImpl(IConnectionService connectionService) {
        this.connectionService = connectionService;
        this.metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
        String dataAccessClassName = null;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            dataAccessClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-permission-handler", "org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler");
            Class<?> clazz = Class.forName(dataAccessClassName);
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessPermHandler = (IDataAccessPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0007_DATAACCESS_PERMISSIONS_INIT_ERROR"), (Throwable)e);
            this.dataAccessPermHandler = new SimpleDataAccessPermissionHandler();
        }
        String dataAccessViewClassName = null;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            dataAccessViewClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-permission-handler", "org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessViewPermissionHandler");
            Class<?> clazz = Class.forName(dataAccessViewClassName);
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessViewPermHandler = (IDataAccessViewPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0030_DATAACCESS_VIEW_PERMISSIONS_INIT_ERROR"), (Throwable)e);
            this.dataAccessViewPermHandler = new SimpleDataAccessViewPermissionHandler();
        }
    }

    protected boolean hasDataAccessPermission() {
        return this.dataAccessPermHandler != null && this.dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession());
    }

    protected boolean hasDataAccessViewPermission() {
        return this.dataAccessViewPermHandler != null && this.dataAccessViewPermHandler.hasDataAccessViewPermission(PentahoSessionHolder.getSession());
    }

    protected List<String> getPermittedRoleList() {
        if (this.dataAccessViewPermHandler == null) {
            return null;
        }
        return this.dataAccessViewPermHandler.getPermittedRoleList(PentahoSessionHolder.getSession());
    }

    protected List<String> getPermittedUserList() {
        if (this.dataAccessViewPermHandler == null) {
            return null;
        }
        return this.dataAccessViewPermHandler.getPermittedUserList(PentahoSessionHolder.getSession());
    }

    protected int getDefaultAcls() {
        if (this.dataAccessViewPermHandler == null) {
            return -1;
        }
        return this.dataAccessViewPermHandler.getDefaultAcls(PentahoSessionHolder.getSession());
    }

    @Override
    public boolean deleteLogicalModel(String domainId, String modelName) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            return false;
        }
        String catalogRef = null;
        String targetTable = null;
        try {
            Domain domain = this.metadataDomainRepository.getDomain(domainId);
            LogicalModel logicalModel = (LogicalModel)domain.getLogicalModels().get(0);
            String modelState = (String)logicalModel.getProperty("datasourceModel");
            if ("CSV".equals(logicalModel.getProperty("DatasourceType")) || "true".equalsIgnoreCase((String)logicalModel.getProperty("target_table_staged"))) {
                targetTable = ((SqlPhysicalTable)((IPhysicalModel)domain.getPhysicalModels().get(0)).getPhysicalTables().get(0)).getTargetTable();
                DatasourceDTO datasource = null;
                if (modelState != null) {
                    datasource = this.deSerializeModelState(modelState);
                }
                if (datasource != null) {
                    CsvTransformGenerator csvTransformGenerator = new CsvTransformGenerator(datasource.getCsvModelInfo(), AgileHelper.getDatabaseMeta());
                    try {
                        csvTransformGenerator.dropTable(targetTable);
                    }
                    catch (CsvTransformGeneratorException e) {
                        logger.warn((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_UNABLE_TO_DROP_TABLE", targetTable, domainId, e.getLocalizedMessage()), (Throwable)e);
                    }
                    String fileName = datasource.getCsvModelInfo().getFileInfo().getFilename();
                    FileUtils fileService = new FileUtils();
                    if (fileName != null) {
                        fileService.deleteFile(fileName);
                    }
                }
            }
            if (domain.getLogicalModels().size() > 1) {
                logicalModel = (LogicalModel)domain.getLogicalModels().get(1);
            }
            if (logicalModel.getProperty("MondrianCatalogRef") != null) {
                IMondrianCatalogService service = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, null);
                catalogRef = (String)logicalModel.getProperty("MondrianCatalogRef");
                service.removeCatalog(catalogRef, PentahoSessionHolder.getSession());
            }
            for (LogicalModel lm : domain.getLogicalModels()) {
                this.metadataDomainRepository.removeModel(domainId, lm.getId());
            }
        }
        catch (MondrianCatalogServiceException me) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0020_UNABLE_TO_DELETE_CATALOG", catalogRef, domainId, me.getLocalizedMessage()), (Throwable)me);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0020_UNABLE_TO_DELETE_CATALOG", catalogRef, domainId, me.getLocalizedMessage()), me);
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0017_UNABLE_TO_STORE_DOMAIN", domainId, dse.getLocalizedMessage()), (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0016_UNABLE_TO_STORE_DOMAIN", domainId, dse.getLocalizedMessage()), dse);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL", dne.getLocalizedMessage()), (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL", dne.getLocalizedMessage()), dne);
        }
        return true;
    }

    private IPentahoResultSet executeQuery(String connectionName, String query, String previewLimit) throws QueryValidationException {
        SQLConnection sqlConnection = null;
        try {
            int limit = previewLimit != null && previewLimit.length() > 0 ? Integer.parseInt(previewLimit) : -1;
            sqlConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)connectionName, (IPentahoSession)PentahoSessionHolder.getSession(), (ILogger)new SimpleLogger(DatasourceServiceHelper.class.getName()));
            sqlConnection.setMaxRows(limit);
            sqlConnection.setReadOnly(true);
            IPentahoResultSet iPentahoResultSet = sqlConnection.executeQuery(BEFORE_QUERY + query + AFTER_QUERY);
            return iPentahoResultSet;
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("S0021")) {
                String error = "DatasourceServiceImpl.ERROR_0021_DUPLICATE_COLUMN_NAMES";
                logger.error((Object)Messages.getErrorString(error));
                throw new QueryValidationException(Messages.getString(error));
            }
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new QueryValidationException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new QueryValidationException(e.getLocalizedMessage(), e);
        }
        finally {
            if (sqlConnection != null) {
                sqlConnection.close();
            }
        }
    }

    @Override
    public SerializedResultSet doPreview(String connectionName, String query, String previewLimit) throws DatasourceServiceException {
        SerializedResultSet returnResultSet;
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            this.executeQuery(connectionName, query, previewLimit);
            returnResultSet = DatasourceServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), PentahoSessionHolder.getSession());
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        return returnResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDataSourceConnection(String connectionName) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        Connection conn = null;
        try {
            conn = DatasourceServiceHelper.getDataSourceConnection(connectionName, PentahoSessionHolder.getSession());
            if (conn == null) {
                logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName));
                throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName));
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName, e.getLocalizedMessage()), (Throwable)e);
                throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName, e.getLocalizedMessage()), e);
            }
        }
        return true;
    }

    @Override
    public BusinessData generateLogicalModel(String modelName, String connectionName, String dbType, String query, String previewLimit) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            this.executeQuery(connectionName, query, previewLimit);
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), PentahoSessionHolder.getSession());
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(modelName, connectionName, dbType, resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getPermittedRoleList(), this.getPermittedUserList(), this.getDefaultAcls(), PentahoSessionHolder.getSession() != null ? PentahoSessionHolder.getSession().getName() : null);
            Domain domain = sqlModelGenerator.generate();
            return new BusinessData(domain, resultSet.getData());
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), smge);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
    }

    public IMetadataDomainRepository getMetadataDomainRepository() {
        return this.metadataDomainRepository;
    }

    public void setMetadataDomainRepository(IMetadataDomainRepository metadataDomainRepository) {
        this.metadataDomainRepository = metadataDomainRepository;
    }

    @Override
    public boolean saveLogicalModel(Domain domain, boolean overwrite) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        String domainName = domain.getId();
        try {
            this.getMetadataDomainRepository().storeDomain(domain, overwrite);
            return true;
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0012_UNABLE_TO_STORE_DOMAIN", domainName, dse.getLocalizedMessage()));
            logger.error((Object)"error", (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0012_UNABLE_TO_STORE_DOMAIN", domainName, dse.getLocalizedMessage()), dse);
        }
        catch (DomainAlreadyExistsException dae) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0013_DOMAIN_ALREADY_EXIST", domainName, dae.getLocalizedMessage()));
            logger.error((Object)"error", (Throwable)dae);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0013_DOMAIN_ALREADY_EXIST", domainName, dae.getLocalizedMessage()), dae);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0014_DOMAIN_IS_NULL", dne.getLocalizedMessage()));
            logger.error((Object)"error", (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0014_DOMAIN_IS_NULL", dne.getLocalizedMessage()), dne);
        }
    }

    @Override
    public boolean hasPermission() {
        if (PentahoSessionHolder.getSession() != null) {
            return SecurityHelper.isPentahoAdministrator((IPentahoSession)PentahoSessionHolder.getSession()) || this.hasDataAccessPermission();
        }
        return false;
    }

    @Override
    public List<LogicalModelSummary> getLogicalModels(String context) throws DatasourceServiceException {
        if (!this.hasDataAccessViewPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        ArrayList<LogicalModelSummary> logicalModelSummaries = new ArrayList<LogicalModelSummary>();
        for (String domainId : this.getMetadataDomainRepository().getDomainIds()) {
            Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
            String locale = LocaleHelper.getLocale().toString();
            String[] locales = new String[domain.getLocales().size()];
            for (int i = 0; i < domain.getLocales().size(); ++i) {
                locales[i] = ((LocaleType)domain.getLocales().get(i)).getCode();
            }
            locale = LocaleHelper.getClosestLocale((String)locale, (String[])locales);
            for (LogicalModel model : domain.getLogicalModels()) {
                String vis = (String)model.getProperty("visible");
                if (vis != null) {
                    String[] visibleContexts = vis.split(",");
                    boolean visibleToContext = false;
                    for (String c : visibleContexts) {
                        if (!StringUtils.isNotEmpty((String)c.trim()) || !c.trim().equals(context)) continue;
                        visibleToContext = true;
                        break;
                    }
                    if (!visibleToContext) continue;
                }
                logicalModelSummaries.add(new LogicalModelSummary(domainId, model.getId(), model.getName(locale)));
            }
        }
        return logicalModelSummaries;
    }

    @Override
    public BusinessData loadBusinessData(String domainId, String modelId) throws DatasourceServiceException {
        Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
        List<List<String>> data = null;
        if (domain.getPhysicalModels().get(0) instanceof InlineEtlPhysicalModel) {
            InlineEtlPhysicalModel model = (InlineEtlPhysicalModel)domain.getPhysicalModels().get(0);
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(CsvTransformGenerator.DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            String csvFileLoc = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
            data = DatasourceServiceHelper.getCsvDataSample(csvFileLoc + model.getFileLocation(), model.getHeaderPresent(), model.getDelimiter(), model.getEnclosure(), 5);
        } else {
            SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
            String query = ((SqlPhysicalTable)model.getPhysicalTables().get(0)).getTargetTable();
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(model.getDatasource().getDatabaseName(), query, 5, PentahoSessionHolder.getSession());
            data = resultSet.getData();
        }
        return new BusinessData(domain, data);
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }

    @Override
    public String serializeModelState(DatasourceDTO dto) throws DatasourceServiceException {
        XStream xstream = new XStream();
        return xstream.toXML((Object)dto);
    }

    @Override
    public DatasourceDTO deSerializeModelState(String dtoStr) throws DatasourceServiceException {
        XStream xs = new XStream();
        return (DatasourceDTO)xs.fromXML(dtoStr);
    }

    private IPentahoSession getSession() {
        IPentahoSession session = null;
        IPentahoObjectFactory pentahoObjectFactory = PentahoSystem.getObjectFactory();
        if (pentahoObjectFactory != null) {
            try {
                session = (IPentahoSession)pentahoObjectFactory.get(IPentahoSession.class, "systemStartupSession", null);
            }
            catch (ObjectFactoryException e) {
                logger.error((Object)e);
            }
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listDatasourceNames() throws IOException {
        byte[] byArray = CsvDatasourceServiceImpl.lock;
        synchronized (CsvDatasourceServiceImpl.lock) {
            SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
            PMDUIComponent component = new PMDUIComponent((IPentahoUrlFactory)urlFactory, new ArrayList());
            component.validate(this.getSession(), null);
            component.setAction(2);
            Document document = component.getXmlContent();
            List modelElements = document.selectNodes("//model_name");
            ArrayList<String> datasourceNames = new ArrayList<String>();
            for (DefaultElement element : modelElements) {
                datasourceNames.add(element.getText());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return datasourceNames;
        }
    }

    @Override
    public QueryDatasourceSummary generateQueryDomain(String name, String query, IConnection connection, DatasourceDTO datasourceDTO) throws DatasourceServiceException {
        ModelerWorkspace modelerWorkspace = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), this.getGeoContext());
        ModelerService modelerService = new ModelerService();
        modelerWorkspace.setModelName(name);
        try {
            this.executeQuery(datasourceDTO.getConnectionName(), query, "1");
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(connection.getName(), query, 10, PentahoSessionHolder.getSession());
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(name, connection.getName(), this.connectionService.convertFromConnection(connection).getDatabaseType().getShortName(), resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getPermittedRoleList(), this.getPermittedUserList(), this.getDefaultAcls(), PentahoSessionHolder.getSession() != null ? PentahoSessionHolder.getSession().getName() : null);
            Domain domain = sqlModelGenerator.generate();
            ((IPhysicalModel)domain.getPhysicalModels().get(0)).setId(connection.getName());
            modelerWorkspace.setDomain(domain);
            modelerWorkspace.getWorkspaceHelper().autoModelFlat(modelerWorkspace);
            modelerWorkspace.getWorkspaceHelper().autoModelRelationalFlat(modelerWorkspace);
            modelerWorkspace.setModelName(datasourceDTO.getDatasourceName());
            modelerWorkspace.getWorkspaceHelper().populateDomain(modelerWorkspace);
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty("datasourceModel", (Object)this.serializeModelState(datasourceDTO));
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty("DatasourceType", (Object)"SQL-DS");
            QueryDatasourceSummary summary = new QueryDatasourceSummary();
            this.prepareForSerializaton(domain);
            modelerService.serializeModels(domain, modelerWorkspace.getModelName());
            summary.setDomain(domain);
            return summary;
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), smge);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        catch (ModelerException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), e);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), e);
        }
    }

    public void prepareForSerializaton(Domain domain) {
        String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(FileUtils.DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        LogicalModel logicalModel = (LogicalModel)domain.getLogicalModels().get(0);
        String modelState = (String)logicalModel.getProperty("datasourceModel");
        if (modelState != null) {
            XStream xs = new XStream();
            DatasourceDTO datasource = (DatasourceDTO)xs.fromXML(modelState);
            CsvFileInfo csvFileInfo = datasource.getCsvModelInfo().getFileInfo();
            String csvFileName = csvFileInfo.getFilename();
            if (csvFileName != null) {
                csvFileInfo.setFilename(null);
                csvFileInfo.setTmpFilename(null);
                csvFileInfo.setFriendlyFilename(null);
                csvFileInfo.setContents(null);
                csvFileInfo.setEncoding(null);
                File csvFile = new File(path + File.separatorChar + csvFileName);
                if (csvFile.exists()) {
                    csvFile.delete();
                }
                CsvTransformGenerator csvTransformGenerator = new CsvTransformGenerator(datasource.getCsvModelInfo(), AgileHelper.getDatabaseMeta());
                try {
                    csvTransformGenerator.dropTable(datasource.getCsvModelInfo().getStageTableName());
                }
                catch (CsvTransformGeneratorException e) {
                    logger.error((Object)e);
                }
            }
            modelState = xs.toXML((Object)datasource);
            logicalModel.setProperty("datasourceModel", (Object)modelState);
        }
    }

    @Override
    public String getDatasourceIllegalCharacters() throws DatasourceServiceException {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        return resLoader.getPluginSetting(this.getClass(), "settings/data-access-datasource-illegal-characters");
    }

    @Override
    public GeoContext getGeoContext() throws DatasourceServiceException {
        if (this.geoContext == null) {
            this.geoContext = DatasourceServiceHelper.getGeoContext();
        }
        return this.geoContext;
    }
}

