/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.PentahoSystemHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class UploadFileDebugServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 8305367618713715640L;
    private static final long MAX_FILE_SIZE = 300000L;
    private static final long MAX_FOLDER_SIZE = 900000L;
    public static final String DEFAULT_RELATIVE_UPLOAD_FILE_PATH = File.separatorChar + "system" + File.separatorChar + "metadata" + File.separatorChar + "csvfiles" + File.separatorChar;

    public UploadFileDebugServlet() {
        PentahoSystemHelper.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            File file;
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            String maxFileLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-file-limit", (String)String.valueOf(300000L));
            String maxFolderLimit = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-folder-limit", (String)String.valueOf(900000L));
            IPentahoSession session = PentahoHttpSessionHelper.getPentahoSession((HttpServletRequest)request);
            response.setContentType("text/plain");
            FileItem uploadItem = this.getFileItem(request);
            if (uploadItem == null) {
                String error = Messages.getErrorString("UploadFileDebugServlet.ERROR_0001_NO_FILE_TO_UPLOAD");
                response.getWriter().write(error);
                return;
            }
            if (Long.parseLong(maxFileLimit) < uploadItem.getSize()) {
                String error = Messages.getErrorString("UploadFileDebugServlet.ERROR_0003_FILE_TOO_BIG");
                response.getWriter().write(error);
                return;
            }
            String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
            File pathDir = new File(path);
            if (!pathDir.exists()) {
                pathDir.mkdirs();
            }
            if (uploadItem.getSize() + this.getFolderSize(new File(path)) > Long.parseLong(maxFolderLimit)) {
                String error = Messages.getErrorString("UploadFileDebugServlet.ERROR_0004_FOLDER_SIZE_LIMIT_REACHED");
                response.getWriter().write(error);
                return;
            }
            String filename = request.getParameter("file_name");
            if (StringUtils.isEmpty((String)filename)) {
                filename = UUIDUtil.getUUID().toString();
            }
            String temporary = request.getParameter("mark_temporary");
            boolean isTemporary = false;
            if (temporary != null) {
                isTemporary = Boolean.valueOf(temporary);
            }
            if (isTemporary) {
                File tempDir = new File(PentahoSystem.getApplicationContext().getSolutionPath("system/tmp"));
                if (!tempDir.exists()) {
                    tempDir.mkdir();
                }
                file = PentahoSystem.getApplicationContext().createTempFile(session, filename, ".tmp", true);
            } else {
                file = new File(path + File.separatorChar + filename);
            }
            FileOutputStream outputStream = new FileOutputStream(file);
            byte[] fileContents = uploadItem.get();
            outputStream.write(fileContents);
            outputStream.flush();
            outputStream.close();
            response.getWriter().write(file.getName());
        }
        catch (Exception e) {
            String error = Messages.getErrorString("UploadFileDebugServlet.ERROR_0005_UNKNOWN_ERROR", e.getLocalizedMessage());
            response.getWriter().write(error);
        }
    }

    private FileItem getFileItem(HttpServletRequest request) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                if (item.isFormField() || !"uploadFormElement".equals(item.getFieldName())) continue;
                return item;
            }
        }
        catch (FileUploadException e) {
            return null;
        }
        return null;
    }

    private long getFolderSize(File folder) {
        long foldersize = 0L;
        File[] filelist = folder.listFiles();
        for (int i = 0; i < filelist.length; ++i) {
            if (filelist[i].isDirectory()) {
                foldersize += this.getFolderSize(filelist[i]);
                continue;
            }
            foldersize += filelist[i].length();
        }
        return foldersize;
    }
}

