/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.pentaho.platform.dataaccess.datasource.DatasourceType;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.AbstractWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.ConnectionController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.WizardConnectionController;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.WizardRelationalDatasourceController;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DatasourceServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.CsvDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasource;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class QueryPhysicalStep
extends AbstractWizardStep {
    public static final int DEFAULT_RELATIONAL_TABLE_ROW_COUNT = 5;
    private DatasourceModel datasourceModel;
    private IXulAsyncDatasourceService datasourceService;
    XulTextbox datasourceNameTextBox = null;
    XulButton okButton = null;
    XulButton cancelButton = null;
    private XulTree csvDataTable = null;
    private WizardConnectionController connectionController;
    private IXulAsyncConnectionService connectionService;
    private boolean isFinishable = false;
    private IConnection connection;
    private ConnectionController databaseConnectionController;

    public QueryPhysicalStep(DatasourceModel datasourceModel, IWizardDatasource parentDatasource, boolean isFinishable) {
        super(parentDatasource);
        this.datasourceModel = datasourceModel;
        this.datasourceService = new DatasourceServiceGwtImpl();
        this.connectionService = new ConnectionServiceGwtImpl();
        this.isFinishable = isFinishable;
    }

    public QueryPhysicalStep(DatasourceModel datasourceModel, IWizardDatasource parentDatasource) {
        this(datasourceModel, parentDatasource, true);
    }

    public void activating() {
        XulVbox queryVbox = (XulVbox)this.document.getElementById("queryBox");
        queryVbox.setVisible(true);
        XulVbox metadataVbox = (XulVbox)this.document.getElementById("metadata");
        metadataVbox.setVisible(false);
        XulVbox connectionsVbox = (XulVbox)this.document.getElementById("connectionsLbl");
        connectionsVbox.setVisible(false);
        XulListbox connections = (XulListbox)this.document.getElementById("connectionList");
        connections.setWidth(180);
        connections.setHeight(325);
    }

    public XulComponent getUIComponent() {
        return this.document.getElementById("queryDeckPanel");
    }

    @Bindable
    public void init(IWizardModel wizardModel) throws XulException {
        this.datasourceNameTextBox = (XulTextbox)this.document.getElementById("datasourceName");
        this.connectionController = new WizardConnectionController(this.document);
        this.connectionController.setDatasourceModel(this.datasourceModel);
        this.connectionController.setConnectionService(this.connectionService);
        this.getXulDomContainer().addEventHandler((XulEventHandler)this.connectionController);
        this.connectionController.init();
        this.databaseConnectionController = new ConnectionController();
        this.databaseConnectionController.setDatasourceModel(this.datasourceModel);
        this.databaseConnectionController.setService(this.connectionService);
        WizardRelationalDatasourceController relationalDatasourceController = new WizardRelationalDatasourceController();
        relationalDatasourceController.setService(this.datasourceService);
        this.getXulDomContainer().addEventHandler((XulEventHandler)relationalDatasourceController);
        relationalDatasourceController.init(this.datasourceModel);
        this.initialize();
        this.datasourceModel.clearModel();
        super.init(wizardModel);
    }

    public void initialize() {
    }

    public IXulAsyncConnectionService getConnectionService() {
        return this.connectionService;
    }

    public void setConnectionService(IXulAsyncConnectionService connectionService) {
        this.connectionService = connectionService;
    }

    public String getName() {
        return "datasourceController";
    }

    @Bindable
    public void selectCsv() {
        this.csvDataTable.update();
        this.datasourceModel.setDatasourceType(DatasourceType.CSV);
    }

    @Bindable
    public void selectSql() {
        this.datasourceModel.setDatasourceType(DatasourceType.SQL);
    }

    public IXulAsyncDatasourceService getDatasourceService() {
        return this.datasourceService;
    }

    public void setDatasourceService(IXulAsyncDatasourceService datasourceService) {
        this.datasourceService = datasourceService;
    }

    public String getStepName() {
        return MessageHandler.getString("wizardStepName.SOURCE");
    }

    public void setBindings() {
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.wizardModel, "selectedDatasource", (Object)this.datasourceModel, "datasourceType", new BindingConvertor[]{new BindingConvertor<IWizardDatasource, DatasourceType>(){

            public DatasourceType sourceToTarget(IWizardDatasource iWizardDatasource) {
                if (iWizardDatasource instanceof QueryDatasource) {
                    return DatasourceType.SQL;
                }
                if (iWizardDatasource instanceof CsvDatasource) {
                    return DatasourceType.CSV;
                }
                return DatasourceType.NONE;
            }

            public IWizardDatasource targetToSource(DatasourceType datasourceType) {
                return null;
            }
        }});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.datasourceModel, "datasourceName", (Object)this.datasourceNameTextBox, "value", new BindingConvertor[0]);
        this.datasourceModel.addPropertyChangeListener("datasourceName", new QueryAndDatasourceNamePropertyChangeListener());
        this.datasourceModel.addPropertyChangeListener("query", new QueryAndDatasourceNamePropertyChangeListener());
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.datasourceModel, "datasourceName", (Object)this.datasourceModel.getModelInfo(), "stageTableName", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.wizardModel, "editing", (Object)this.datasourceNameTextBox, "disabled", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.datasourceModel, "selectedRelationalConnection", (Object)this, "connection", new BindingConvertor[0]);
    }

    public void setFocus() {
        this.datasourceNameTextBox.setFocus();
        this.setStepImageVisible(true);
    }

    public void reloadConnections() {
        this.databaseConnectionController.reloadConnections();
    }

    public void selectConnectionByName(String name) {
        this.connection = this.databaseConnectionController.getDatasourceModel().getGuiStateModel().getConnectionByName(name);
        this.databaseConnectionController.getDatasourceModel().setSelectedRelationalConnection(this.connection);
    }

    public boolean stepDeactivatingForward() {
        return super.stepDeactivatingForward();
    }

    public WizardConnectionController getConnectionController() {
        return this.connectionController;
    }

    public void setConnectionController(WizardConnectionController connectionController) {
        this.connectionController = connectionController;
    }

    @Bindable
    public IConnection getConnection() {
        return this.connection;
    }

    @Bindable
    public void setConnection(IConnection connection) {
        Object prevVal = this.connection == null ? new Object() : null;
        this.connection = connection;
        this.firePropertyChange("connection", prevVal, connection);
    }

    public void refresh() {
        this.reloadConnections();
    }

    private class QueryAndDatasourceNamePropertyChangeListener
    implements PropertyChangeListener {
        private QueryAndDatasourceNamePropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String newValue = (String)evt.getNewValue();
            if (newValue == null || newValue.trim().length() == 0) {
                QueryPhysicalStep.this.parentDatasource.setFinishable(false);
            } else if (QueryPhysicalStep.this.isFinishable) {
                QueryPhysicalStep.this.datasourceModel.validate();
                QueryPhysicalStep.this.parentDatasource.setFinishable(QueryPhysicalStep.this.datasourceModel.isValidated());
            } else {
                QueryPhysicalStep.this.parentDatasource.setFinishable(false);
                QueryPhysicalStep.this.setValid(true);
            }
        }
    }
}

