/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.metadata.service;

import flexjson.JSONSerializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.marshal.MarshallableResultSet;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.metadata.messages.Messages;
import org.pentaho.platform.dataaccess.metadata.model.impl.Model;
import org.pentaho.platform.dataaccess.metadata.model.impl.ModelInfo;
import org.pentaho.platform.dataaccess.metadata.model.impl.ModelInfoComparator;
import org.pentaho.platform.dataaccess.metadata.service.MetadataServiceUtil;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.pentahometadata.MetadataQueryComponent;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.pms.core.exception.PentahoMetadataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataService
extends PentahoBase {
    private static final long serialVersionUID = 8481450224870463494L;
    private Log logger = LogFactory.getLog(MetadataService.class);

    public MetadataService() {
        this.setLoggingLevel(5);
    }

    public String getDatasourcePermissions() {
        String dataAccessClassName = null;
        IDataAccessPermissionHandler dataAccessPermHandler = null;
        IDataAccessViewPermissionHandler dataAccessViewPermHandler = null;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            dataAccessClassName = resLoader.getPluginSetting(((Object)((Object)this)).getClass(), "settings/data-access-permission-handler", "org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler");
            Class<?> clazz = Class.forName(dataAccessClassName);
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            dataAccessPermHandler = (IDataAccessPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0007_DATAACCESS_PERMISSIONS_INIT_ERROR"), (Throwable)e);
        }
        String dataAccessViewClassName = null;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            dataAccessViewClassName = resLoader.getPluginSetting(((Object)((Object)this)).getClass(), "settings/data-access-view-permission-handler", "org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessViewPermissionHandler");
            Class<?> clazz = Class.forName(dataAccessViewClassName);
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            dataAccessViewPermHandler = (IDataAccessViewPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0030_DATAACCESS_VIEW_PERMISSIONS_INIT_ERROR"), (Throwable)e);
        }
        boolean canEdit = dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession());
        boolean canView = dataAccessViewPermHandler.hasDataAccessViewPermission(PentahoSessionHolder.getSession());
        if (canEdit) {
            return "EDIT";
        }
        if (canView) {
            return "VIEW";
        }
        return "NONE";
    }

    public ModelInfo[] listBusinessModels(String domainName) throws IOException {
        ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
        IMetadataDomainRepository repo = this.getMetadataRepository();
        if (repo == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0001_BAD_REPO"));
            return null;
        }
        try {
            if (domainName == null) {
                for (String domain : this.getMetadataRepository().getDomainIds()) {
                    this.getModelInfos(domain, models);
                }
            } else {
                this.getModelInfos(domainName, models);
            }
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0002_BAD_MODEL_LIST"), t);
        }
        Collections.sort(models, new ModelInfoComparator());
        return models.toArray(new ModelInfo[models.size()]);
    }

    public String listBusinessModelsJson(String domainName) throws IOException {
        ModelInfo[] models = this.listBusinessModels(domainName);
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)models);
        return json;
    }

    private void getModelInfos(String domain, List<ModelInfo> models) {
        IMetadataDomainRepository repo = this.getMetadataRepository();
        Domain domainObject = repo.getDomain(domain);
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domainObject.getLocaleCodes());
        for (LogicalModel model : domainObject.getLogicalModels()) {
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.setDomainId(domain);
            modelInfo.setModelId(model.getId());
            modelInfo.setModelName(model.getName(locale));
            if (model.getDescription() != null) {
                String modelDescription = model.getDescription(locale);
                modelInfo.setModelDescription(modelDescription);
            }
            models.add(modelInfo);
        }
    }

    public Model loadModel(String domainId, String modelId) {
        if (domainId == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0003_NULL_DOMAIN"));
            return null;
        }
        if (modelId == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0004_NULL_Model"));
            return null;
        }
        Domain domain = this.getMetadataRepository().getDomain(domainId);
        if (domain == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0005_DOMAIN_NOT_FOUND", domainId));
            return null;
        }
        LogicalModel model = domain.findLogicalModel(modelId);
        if (model == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0006_MODEL_NOT_FOUND", modelId));
            return null;
        }
        MetadataServiceUtil util = new MetadataServiceUtil();
        util.setDomain(domain);
        Model thinModel = util.createThinModel(model, domainId);
        return thinModel;
    }

    public String loadModelJson(String domainId, String modelId) {
        Model model = this.loadModel(domainId, modelId);
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)model);
        return json;
    }

    public MarshallableResultSet doQuery(org.pentaho.platform.dataaccess.metadata.model.impl.Query query, Integer rowLimit) {
        MetadataServiceUtil util = new MetadataServiceUtil();
        Query fullQuery = util.convertQuery(query);
        QueryXmlHelper helper = new QueryXmlHelper();
        String xml = helper.toXML(fullQuery);
        return this.doXmlQuery(xml, rowLimit);
    }

    public MarshallableResultSet doXmlQuery(String xml, Integer rowLimit) {
        IPentahoResultSet resultSet = this.executeQuery(xml, rowLimit);
        if (resultSet == null) {
            return null;
        }
        MarshallableResultSet result = new MarshallableResultSet();
        result.setResultSet(resultSet);
        return result;
    }

    public String doXmlQueryToJson(String xml, int rowLimit) {
        MarshallableResultSet resultSet = this.doXmlQuery(xml, rowLimit);
        if (resultSet == null) {
            return null;
        }
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)resultSet);
        return json;
    }

    public String doXmlQueryToCdaJson(String xml, int rowLimit) {
        IPentahoResultSet resultSet = this.executeQuery(xml, rowLimit);
        if (resultSet == null) {
            return null;
        }
        String json = null;
        try {
            MetadataServiceUtil util = new MetadataServiceUtil();
            Domain domain = util.getDomainObject(xml);
            util.setDomain(domain);
            String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domain.getLocaleCodes());
            json = util.createCdaJson(resultSet, locale);
        }
        catch (JSONException e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0007_JSON_ERROR"), e);
        }
        catch (PentahoMetadataException e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0007_BAD_QUERY_DOMAIN"), e);
        }
        return json;
    }

    public MarshallableResultSet doJsonQuery(String json, Integer rowLimit) {
        return this.doXmlQuery(this.getQueryXmlFromJson(json), rowLimit);
    }

    public String doJsonQueryToJson(String json, int rowLimit) {
        return this.doXmlQueryToJson(this.getQueryXmlFromJson(json), rowLimit);
    }

    public String doJsonQueryToCdaJson(String json, int rowLimit) {
        return this.doXmlQueryToCdaJson(this.getQueryXmlFromJson(json), rowLimit);
    }

    protected IPentahoResultSet executeQuery(String query, Integer rowLimit) {
        MetadataQueryComponent dataComponent = new MetadataQueryComponent();
        dataComponent.setQuery(query);
        dataComponent.setLive(false);
        dataComponent.setUseForwardOnlyResultSet(true);
        if (rowLimit != null && rowLimit > -1) {
            dataComponent.setMaxRows(rowLimit);
        }
        if (dataComponent.execute()) {
            return dataComponent.getResultSet();
        }
        return null;
    }

    protected String getQueryXmlFromJson(String json) {
        MetadataServiceUtil util = new MetadataServiceUtil();
        org.pentaho.platform.dataaccess.metadata.model.impl.Query query = util.deserializeJsonQuery(json);
        try {
            Query fullQuery = util.convertQuery(query);
            QueryXmlHelper helper = new QueryXmlHelper();
            String xml = helper.toXML(fullQuery);
            return xml;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0008_BAD_QUERY"), e);
            return null;
        }
    }

    protected IMetadataDomainRepository getMetadataRepository() {
        IMetadataDomainRepository mdr = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        if (mdr instanceof ILogger) {
            ((ILogger)mdr).setLoggingLevel(this.getLoggingLevel());
        }
        return mdr;
    }

    public Log getLogger() {
        return this.logger;
    }
}

