/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.util;

import java.util.Properties;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.PartitionDatabaseMeta;
import org.pentaho.di.core.database.DatabaseMeta;

public class DatabaseUtil {
    public static DatabaseMeta convertToDatabaseMeta(IDatabaseConnection conn) {
        DatabaseMeta meta = new DatabaseMeta();
        meta.setDatabaseType(conn.getDatabaseType().getShortName());
        Properties props = meta.getDatabaseInterface().getAttributes();
        for (String key : conn.getExtraOptions().keySet()) {
            props.put("EXTRA_OPTION_" + key, conn.getExtraOptions().get(key));
        }
        for (String key : conn.getConnectionPoolingProperties().keySet()) {
            props.put("POOLING_" + key, conn.getConnectionPoolingProperties().get(key));
        }
        for (String key : conn.getAttributes().keySet()) {
            props.put(key, conn.getAttributes().get(key));
        }
        meta.setAttributes(props);
        meta.setName(conn.getName());
        meta.setAccessType(conn.getAccessType().ordinal());
        meta.setHostname(conn.getHostname());
        meta.setDBName(conn.getDatabaseName());
        meta.setDBPort(conn.getDatabasePort());
        meta.setUsername(conn.getUsername());
        meta.setPassword(conn.getPassword());
        meta.setServername(conn.getInformixServername());
        meta.setDataTablespace(conn.getDataTablespace());
        meta.setIndexTablespace(conn.getIndexTablespace());
        if (conn.getConnectSql() != null) {
            meta.setConnectSQL(conn.getConnectSql());
        }
        meta.setInitialPoolSize(conn.getInitialPoolSize());
        meta.setMaximumPoolSize(conn.getMaximumPoolSize());
        if (conn.getSQLServerInstance() != null) {
            meta.setSQLServerInstance(conn.getSQLServerInstance());
        }
        meta.setForcingIdentifiersToLowerCase(conn.isForcingIdentifiersToLowerCase());
        meta.setForcingIdentifiersToUpperCase(conn.isForcingIdentifiersToUpperCase());
        meta.setPartitioned(conn.isPartitioned());
        meta.setQuoteAllFields(conn.isQuoteAllFields());
        meta.setStreamingResults(conn.isStreamingResults());
        meta.setUsingConnectionPool(conn.isUsingConnectionPool());
        meta.setUsingDoubleDecimalAsSchemaTableSeparator(conn.isUsingDoubleDecimalAsSchemaTableSeparator());
        if (conn.getPartitioningInformation() != null) {
            org.pentaho.di.core.database.PartitionDatabaseMeta[] pdmetas = new org.pentaho.di.core.database.PartitionDatabaseMeta[conn.getPartitioningInformation().size()];
            int c = 0;
            for (PartitionDatabaseMeta pdmeta : conn.getPartitioningInformation()) {
                pdmetas[c++] = DatabaseUtil.convertToPartitionDatabaseMeta(pdmeta);
            }
            meta.setPartitioningInformation(pdmetas);
        }
        if (conn.getChanged()) {
            meta.setChanged();
        }
        return meta;
    }

    public static org.pentaho.di.core.database.PartitionDatabaseMeta convertToPartitionDatabaseMeta(PartitionDatabaseMeta pdm) {
        org.pentaho.di.core.database.PartitionDatabaseMeta pdmeta = new org.pentaho.di.core.database.PartitionDatabaseMeta();
        pdmeta.setDatabaseName(pdm.getDatabaseName());
        pdmeta.setHostname(pdm.getHostname());
        pdmeta.setPartitionId(pdm.getPartitionId());
        pdmeta.setPassword(pdm.getPassword());
        pdmeta.setPort(pdm.getPort());
        pdmeta.setUsername(pdm.getUsername());
        return pdmeta;
    }
}

