/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.database.event;

import com.google.gwt.core.client.GWT;
import java.util.Set;
import java.util.TreeSet;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.ui.database.event.DataHandler;
import org.pentaho.ui.database.event.IFragmentHandler;
import org.pentaho.ui.database.event.IMessages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.XulListitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.gwt.GwtXulDomContainer;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.tags.GwtGroupBox;
import org.pentaho.ui.xul.gwt.tags.GwtHbox;
import org.pentaho.ui.xul.gwt.util.AsyncXulLoader;
import org.pentaho.ui.xul.gwt.util.IXulLoaderCallback;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class GwtFragmentHandler
extends AbstractXulEventHandler
implements IFragmentHandler {
    private XulListbox connectionBox;
    private XulListbox accessBox;
    private DatabaseTypeHelper databaseTypeHelper;
    private IMessages messages;
    Set<String> supportedFragments = new TreeSet<String>();
    private boolean disableRefresh = false;

    public GwtFragmentHandler() {
        this.setName("fragmentHandler");
        this.supportedFragments.add("generic_native.xul");
        this.supportedFragments.add("informix_jndi.xul");
        this.supportedFragments.add("informix_native.xul");
        this.supportedFragments.add("mssql_jndi.xul");
        this.supportedFragments.add("mssql_native.xul");
        this.supportedFragments.add("mssqlnative_jndi.xul");
        this.supportedFragments.add("mssqlnative_native.xul");
        this.supportedFragments.add("mysql_jndi.xul");
        this.supportedFragments.add("mysql_native.xul");
        this.supportedFragments.add("oracle_jndi.xul");
        this.supportedFragments.add("oracle_native.xul");
        this.supportedFragments.add("oracle_oci.xul");
        this.supportedFragments.add("oracle_odbc.xul");
        this.supportedFragments.add("sapr3_plugin.xul");
    }

    public void setDisableRefresh(boolean disableRefresh) {
        this.disableRefresh = disableRefresh;
    }

    public void setDatabaseTypeHelper(DatabaseTypeHelper databaseTypeHelper) {
        this.databaseTypeHelper = databaseTypeHelper;
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    private void loadDatabaseOptionsFragment(String fragmentUri, final DataHandler dataHandler, final IDatabaseType database, final IFragmentHandler.Callback parentCallback) throws XulException {
        XulComponent groupElement = this.document.getElementById("database-options-box");
        for (XulComponent component : groupElement.getChildNodes()) {
            groupElement.removeChild((Element)component);
        }
        XulComponent parentElement = groupElement.getParent();
        Object fragmentContainer = null;
        IXulLoaderCallback internalCallback = new IXulLoaderCallback(){

            public void overlayLoaded() {
                GwtFragmentHandler.this.afterOverlay(dataHandler, database);
                if (parentCallback != null) {
                    parentCallback.callback();
                }
            }

            public void overlayRemoved() {
            }

            public void xulLoaded(GwtXulRunner runner) {
            }
        };
        AsyncXulLoader.loadOverlayFromUrl((String)(GWT.getModuleBaseURL() + fragmentUri), (String)(GWT.getModuleBaseURL() + "databasedialog"), (GwtXulDomContainer)((GwtXulDomContainer)this.getXulDomContainer()), (IXulLoaderCallback)internalCallback, (boolean)true);
    }

    @Bindable
    public void refreshOptions() {
        if (!this.disableRefresh) {
            this.refreshOptionsWithCallback(null);
        }
    }

    public void refreshOptionsWithCallback(IFragmentHandler.Callback callback) {
        this.connectionBox = (XulListbox)this.document.getElementById("connection-type-list");
        this.accessBox = (XulListbox)this.document.getElementById("access-type-list");
        String connectionKey = this.getSelectedString(this.connectionBox);
        if (connectionKey == null) {
            return;
        }
        IDatabaseType database = this.databaseTypeHelper.getDatabaseTypeByName(connectionKey);
        String accessKey = this.getSelectedString(this.accessBox);
        DatabaseAccessType access = DatabaseAccessType.getAccessTypeByName((String)accessKey);
        if (access == null) {
            return;
        }
        String fragment = null;
        DataHandler dataHandler = null;
        try {
            dataHandler = (DataHandler)this.xulDomContainer.getEventHandler("dataHandler");
            dataHandler.pushCache();
        }
        catch (XulException e) {
            // empty catch block
        }
        switch (access) {
            case JNDI: {
                fragment = this.getFragment(database, "_jndi.xul", "common_jndi.xul");
                break;
            }
            case NATIVE: {
                fragment = this.getFragment(database, "_native.xul", "common_native.xul");
                break;
            }
            case OCI: {
                fragment = this.getFragment(database, "_oci.xul", "common_native.xul");
                break;
            }
            case ODBC: {
                fragment = this.getFragment(database, "_odbc.xul", "common_odbc.xul");
                break;
            }
            case PLUGIN: {
                fragment = this.getFragment(database, "_plugin.xul", "common_native.xul");
            }
        }
        try {
            this.loadDatabaseOptionsFragment(fragment.toLowerCase(), dataHandler, database, callback);
        }
        catch (XulException e) {
            this.showMessage(this.messages.getString("FragmentHandler.USER.CANT_LOAD_OPTIONS", database.getName()));
        }
    }

    private void afterOverlay(DataHandler dataHandler, IDatabaseType database) {
        XulTextbox portBox = (XulTextbox)this.document.getElementById("port-number-text");
        Object data = dataHandler.getData();
        String portValue = null;
        IDatabaseConnection databaseConnection = null;
        if (data instanceof IDatabaseConnection) {
            databaseConnection = (IDatabaseConnection)data;
            portValue = databaseConnection.getDatabasePort();
        }
        if (portBox != null) {
            int port;
            int n = port = portValue != null && portValue.length() > 0 ? Integer.parseInt(portValue) : database.getDefaultDatabasePort();
            if (port > 0) {
                portBox.setValue(Integer.toString(port));
            }
        }
        if (dataHandler != null) {
            dataHandler.popCache();
        }
        GwtGroupBox box1 = (GwtGroupBox)this.document.getElementById("database-options-box");
        XulHbox box = (XulHbox)this.document.getElementById("connection-access-list-box");
        box1.layout();
        ((GwtHbox)box).layout();
    }

    private String getSelectedString(XulListbox box) {
        String key = null;
        Object keyObj = box.getSelectedItem();
        key = keyObj instanceof XulListitem ? ((XulListitem)keyObj).getLabel() : (String)keyObj;
        return key;
    }

    private String getFragment(IDatabaseType database, String extension, String defaultFragment) {
        String fragment = database.getShortName().concat(extension).toLowerCase();
        if (!this.supportedFragments.contains(fragment)) {
            fragment = defaultFragment;
        }
        return fragment;
    }

    private void showMessage(String message) {
        try {
            XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
            box.setMessage(message);
            box.open();
        }
        catch (XulException e) {
            System.out.println("Error creating messagebox " + e.getMessage());
        }
    }
}

