/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;

public abstract class AbstractDatabaseDialect
implements IDatabaseDialect,
Serializable {
    public static final int CLOB_LENGTH = 9999999;
    public static final String CR = " ";

    public int getDefaultDatabasePort() {
        return this.getDatabaseType().getDefaultDatabasePort();
    }

    public boolean supportsSetCharacterStream() {
        return true;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public String getLimitClause(int nrRows) {
        return "";
    }

    public int getNotFoundTK(boolean use_autoinc) {
        return 0;
    }

    public String getSQLNextSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "";
    }

    public String getSQLSequenceExists(String sequenceName) {
        return "";
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean needsPlaceHolder() {
        return false;
    }

    public boolean supportsSchemas() {
        return true;
    }

    public boolean supportsCatalogs() {
        return true;
    }

    public boolean supportsEmptyTransactions() {
        return true;
    }

    public String getFunctionSum() {
        return "SUM";
    }

    public String getFunctionAverage() {
        return "AVG";
    }

    public String getFunctionMinimum() {
        return "MIN";
    }

    public String getFunctionMaximum() {
        return "MAX";
    }

    public String getFunctionCount() {
        return "COUNT";
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    public int getMaxTextFieldLength() {
        return 9999999;
    }

    public int getMaxVARCHARLength() {
        return 9999999;
    }

    public boolean supportsTransactions() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return true;
    }

    public boolean supportsSetLong() {
        return true;
    }

    public String getDropColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + CR;
    }

    public String[] getReservedWords() {
        return new String[0];
    }

    public boolean quoteReservedWords() {
        return true;
    }

    public String getStartQuote() {
        return "\"";
    }

    public String getEndQuote() {
        return "\"";
    }

    public boolean supportsRepository() {
        return true;
    }

    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    public boolean useSchemaNameForTableList() {
        return false;
    }

    public boolean supportsViews() {
        return true;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getSQLListOfProcedures(IDatabaseConnection connection) {
        return null;
    }

    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    public boolean supportsFloatRoundingOnUpdate() {
        return true;
    }

    public String getSQLLockTables(String[] tableNames) {
        return null;
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public boolean supportsTimeStampToDateConversion() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean supportsBooleanDataType() {
        return true;
    }

    public boolean isDefaultingToUppercase() {
        return true;
    }

    public boolean supportsSetMaxRows() {
        return true;
    }

    public String getSQLTableExists(String tablename) {
        return "SELECT 1 FROM " + tablename;
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT " + columnname + " FROM " + tablename;
    }

    public boolean needsToLockAllTables() {
        return true;
    }

    public boolean isRequiringTransactionsOnQueries() {
        return true;
    }

    public abstract String getURL(IDatabaseConnection var1) throws DatabaseDialectException;

    public String getURLWithExtraOptions(IDatabaseConnection connection) throws DatabaseDialectException {
        StringBuffer url = new StringBuffer(this.getURL(connection));
        if (this.supportsOptionsInURL()) {
            String optionIndicator = this.getExtraOptionIndicator();
            String optionSeparator = this.getExtraOptionSeparator();
            String valueSeparator = this.getExtraOptionValueSeparator();
            Map<String, String> map = connection.getExtraOptions();
            if (map.size() > 0) {
                Iterator<String> iterator = map.keySet().iterator();
                boolean first = true;
                while (iterator.hasNext()) {
                    String typedParameter = iterator.next();
                    int dotIndex = typedParameter.indexOf(46);
                    if (dotIndex < 0) continue;
                    String typeCode = typedParameter.substring(0, dotIndex);
                    String parameter = typedParameter.substring(dotIndex + 1);
                    String value = map.get(typedParameter);
                    if (!connection.getDatabaseType().getShortName().equals(typeCode)) continue;
                    if (first && url.indexOf(valueSeparator) == -1) {
                        url.append(optionIndicator);
                    } else {
                        url.append(optionSeparator);
                    }
                    url.append(parameter);
                    if (!AbstractDatabaseDialect.isEmpty(value)) {
                        url.append(valueSeparator).append(value);
                    }
                    first = false;
                }
            }
        }
        return url.toString();
    }

    public abstract String getAddColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    public abstract String getModifyColumnStatement(String var1, IValueMeta var2, String var3, boolean var4, String var5, boolean var6);

    public abstract String getFieldDefinition(IValueMeta var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    public String getExtraOptionsHelpText() {
        return this.getDatabaseType().getExtraOptionsHelpUrl();
    }

    public abstract String[] getUsedLibraries();

    public abstract String getNativeDriver();

    public boolean supportsOptionsInURL() {
        return true;
    }

    protected abstract String getNativeJdbcPre();

    public IDatabaseConnection createNativeConnection(String jdbcUrl) {
        if (!jdbcUrl.startsWith(this.getNativeJdbcPre())) {
            throw new RuntimeException("JDBC URL " + jdbcUrl + " does not start with " + this.getNativeJdbcPre());
        }
        DatabaseConnection dbconn = new DatabaseConnection();
        dbconn.setDatabaseType(this.getDatabaseType());
        dbconn.setAccessType(DatabaseAccessType.NATIVE);
        String str = jdbcUrl.substring(this.getNativeJdbcPre().length());
        String hostname = null;
        String port = null;
        String databaseNameAndParams = null;
        if (str.indexOf(":") >= 0) {
            hostname = str.substring(0, str.indexOf(":"));
            if ((str = str.substring(str.indexOf(":") + 1)).indexOf("/") >= 0) {
                port = str.substring(0, str.indexOf("/"));
                databaseNameAndParams = str.substring(str.indexOf("/") + 1);
            } else {
                port = str;
            }
        } else if (str.indexOf("/") >= 0) {
            hostname = str.substring(0, str.indexOf("/"));
            databaseNameAndParams = str.substring(str.indexOf("/") + 1);
        } else {
            databaseNameAndParams = str;
        }
        if (hostname != null) {
            dbconn.setHostname(hostname);
        }
        if (port != null) {
            dbconn.setDatabasePort(port);
        }
        if (databaseNameAndParams != null) {
            this.setDatabaseNameAndParams(dbconn, databaseNameAndParams);
        }
        return dbconn;
    }

    protected void setDatabaseNameAndParams(DatabaseConnection dbconn, String databaseNameAndParams) {
        int paramIndex;
        if (this.supportsOptionsInURL() && (paramIndex = databaseNameAndParams.indexOf(this.getExtraOptionIndicator())) >= 0) {
            String[] paramData;
            String params = databaseNameAndParams.substring(paramIndex + 1);
            databaseNameAndParams = databaseNameAndParams.substring(0, paramIndex);
            for (String param : paramData = params.split(this.getExtraOptionSeparator())) {
                String[] nameAndValue = param.split(this.getExtraOptionValueSeparator());
                if (nameAndValue[0] == null || nameAndValue[0].trim().length() <= 0) continue;
                if (nameAndValue.length == 1) {
                    dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], "");
                    continue;
                }
                dbconn.addExtraOption(dbconn.getDatabaseType().getShortName(), nameAndValue[0], nameAndValue[1]);
            }
        }
        dbconn.setDatabaseName(databaseNameAndParams);
    }

    public String getDriverClass(IDatabaseConnection connection) {
        if (connection.getAccessType() == DatabaseAccessType.ODBC) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return this.getNativeDriver();
    }

    public boolean supportsGetBlob() {
        return true;
    }

    public String getExtraOptionSeparator() {
        return ";";
    }

    public String getExtraOptionValueSeparator() {
        return "=";
    }

    public String getExtraOptionIndicator() {
        return ";";
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static final int toInt(String str, int def) {
        int retval;
        try {
            retval = Integer.parseInt(str);
        }
        catch (Exception e) {
            retval = def;
        }
        return retval;
    }
}

