/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.dialect;

import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IValueMeta;
import org.pentaho.database.dialect.AbstractDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;

public class GenericDatabaseDialect
extends AbstractDatabaseDialect {
    public static final String ATTRIBUTE_CUSTOM_URL = "CUSTOM_URL";
    public static final String ATTRIBUTE_CUSTOM_DRIVER_CLASS = "CUSTOM_DRIVER_CLASS";
    private static final IDatabaseType DBTYPE = new DatabaseType("Generic database", "GENERIC", DatabaseAccessType.getList(DatabaseAccessType.NATIVE, DatabaseAccessType.ODBC, DatabaseAccessType.JNDI), -1, null);

    public IDatabaseType getDatabaseType() {
        return DBTYPE;
    }

    public String getAddColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "BIGSERIAL";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "NUMERIC(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE PRECISION";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "TEXT";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(";
                retval = retval + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + " ";
        }
        return retval;
    }

    public String getModifyColumnStatement(String tablename, IValueMeta v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getNativeDriver() {
        return null;
    }

    protected String getNativeJdbcPre() {
        return null;
    }

    public String getURL(IDatabaseConnection connection) throws DatabaseDialectException {
        if (connection.getAccessType() == DatabaseAccessType.NATIVE) {
            String url = connection.getAttributes().get(ATTRIBUTE_CUSTOM_URL);
            if (url == null) {
                url = "";
            }
            return url;
        }
        return "jdbc:odbc:" + connection.getDatabaseName();
    }

    public boolean supportsOptionsInURL() {
        return false;
    }

    public String[] getUsedLibraries() {
        return new String[0];
    }

    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsRepository() {
        return false;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public IDatabaseConnection createNativeConnection(String jdbcUrl) {
        DatabaseConnection dbconn = new DatabaseConnection();
        dbconn.setDatabaseType(this.getDatabaseType());
        dbconn.setAccessType(DatabaseAccessType.NATIVE);
        dbconn.getAttributes().put(ATTRIBUTE_CUSTOM_URL, jdbcUrl);
        return dbconn;
    }
}

