/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DatabaseAccessType {
    NATIVE("Native (JDBC)"),
    ODBC("ODBC"),
    OCI("OCI"),
    PLUGIN("Plugin specific access method"),
    JNDI("JNDI"),
    CUSTOM("Custom");

    private String name;
    private static Map<String, DatabaseAccessType> typeByName;

    private DatabaseAccessType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.toString();
    }

    public static DatabaseAccessType getAccessTypeByName(String name) {
        if (typeByName == null) {
            typeByName = new HashMap<String, DatabaseAccessType>();
            for (DatabaseAccessType type : DatabaseAccessType.values()) {
                typeByName.put(type.getName(), type);
            }
        }
        return typeByName.get(name);
    }

    public static List<DatabaseAccessType> getList(DatabaseAccessType ... accessTypes) {
        ArrayList<DatabaseAccessType> list = new ArrayList<DatabaseAccessType>();
        for (DatabaseAccessType accessType : accessTypes) {
            list.add(accessType);
        }
        return list;
    }

    static {
        typeByName = null;
    }
}

