/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.database.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.dialect.DB2DatabaseDialect;
import org.pentaho.database.dialect.GenericDatabaseDialect;
import org.pentaho.database.dialect.H2DatabaseDialect;
import org.pentaho.database.dialect.HypersonicDatabaseDialect;
import org.pentaho.database.dialect.MSSQLServerDatabaseDialect;
import org.pentaho.database.dialect.MSSQLServerNativeDatabaseDialect;
import org.pentaho.database.dialect.MySQLDatabaseDialect;
import org.pentaho.database.dialect.OracleDatabaseDialect;
import org.pentaho.database.dialect.PostgreSQLDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.service.IDatabaseDialectService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDialectService
implements IDatabaseDialectService {
    private static final Log logger = LogFactory.getLog(DatabaseDialectService.class);
    List<IDatabaseDialect> databaseDialects = new ArrayList<IDatabaseDialect>();
    List<IDatabaseType> databaseTypes = new ArrayList<IDatabaseType>();
    Map<IDatabaseType, IDatabaseDialect> typeToDialectMap = new HashMap<IDatabaseType, IDatabaseDialect>();
    GenericDatabaseDialect genericDialect = new GenericDatabaseDialect();

    public DatabaseDialectService() {
        this(true);
    }

    public DatabaseDialectService(boolean validateClasses) {
        this.registerDatabaseDialect(new OracleDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new MySQLDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new HypersonicDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new MSSQLServerDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new MSSQLServerNativeDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new DB2DatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new PostgreSQLDatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(new H2DatabaseDialect(), validateClasses);
        this.registerDatabaseDialect(this.genericDialect, validateClasses);
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect) {
        this.registerDatabaseDialect(databaseDialect, true);
    }

    @Override
    public void registerDatabaseDialect(IDatabaseDialect databaseDialect, boolean validateClassExists) {
        if (!validateClassExists || this.validateJdbcDriverClassExists(databaseDialect.getNativeDriver())) {
            this.databaseTypes.add(databaseDialect.getDatabaseType());
            this.typeToDialectMap.put(databaseDialect.getDatabaseType(), databaseDialect);
            this.databaseDialects.add(databaseDialect);
        }
    }

    @Override
    public boolean validateJdbcDriverClassExists(String classname) {
        block7: {
            if (classname == null) {
                return true;
            }
            try {
                Class.forName(classname);
                return true;
            }
            catch (NoClassDefFoundError e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"classExists returning false", (Throwable)e);
                }
            }
            catch (ClassNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"classExists returning false", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug((Object)"classExists returning false", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public List<IDatabaseType> getDatabaseTypes() {
        return this.databaseTypes;
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseType databaseType) {
        return this.typeToDialectMap.get(databaseType);
    }

    @Override
    public IDatabaseDialect getDialect(IDatabaseConnection connection) {
        return this.typeToDialectMap.get(connection.getDatabaseType());
    }

    @Override
    public List<IDatabaseDialect> getDatabaseDialects() {
        return this.databaseDialects;
    }
}

