/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.agilebi.modeler.CategoryTreeHelper;
import org.pentaho.agilebi.modeler.ColResolverController;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.DimensionTreeHelper;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerMode;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerTreeHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaData;
import org.pentaho.agilebi.modeler.nodes.CategoryMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasuresCollection;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;
import org.pentaho.agilebi.modeler.nodes.RelationalModelNode;
import org.pentaho.agilebi.modeler.propforms.AbstractModelerNodeForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulPromptBox;
import org.pentaho.ui.xul.components.XulTabpanel;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.XulDialogCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelerController
extends AbstractXulEventHandler {
    protected static final String FIELD_LIST_ID = "fieldList";
    protected static final String SOURCE_NAME_LABEL_ID = "source_name";
    protected static final String RELATIONAL_NAME_LABEL_ID = "relational_source_name";
    protected ModelerWorkspace workspace;
    private XulTree dimensionTree;
    private XulTree categoriesTree;
    private XulDeck propDeck;
    private IAvailableItem[] selectedFields = new IAvailableItem[0];
    private XulDeck modelDeck;
    private XulVbox reportingPanel;
    private XulTabpanel reportingTabPanel;
    private XulHbox modelPanel;
    protected BindingFactory bf;
    private Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> propertiesForms = new HashMap<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm>();
    private ColResolverController colController;
    private transient DimensionTreeHelper dimTreeHelper;
    private transient CategoryTreeHelper catTreeHelper;
    private XulTabbox modelTabbox;
    private Binding fieldListBinding;
    private Binding selectedFieldsBinding;
    private Binding modelTreeBinding;
    private Binding relModelTreeBinding;
    private Binding modelerModeBinding;
    private boolean propVisible = true;

    public ModelerController(ModelerWorkspace workspace) {
        this.workspace = workspace;
    }

    public String getName() {
        return "modeler";
    }

    public void onFieldListDrag(DropEvent event) {
    }

    public void onModelTreeDrag(DropEvent event) {
    }

    @Bindable
    public void checkDropLocation(DropEvent event) {
        List data = event.getDataTransfer().getData();
        for (Object obj : data) {
            if (!(obj instanceof AbstractMetaDataModelNode) || event.getDropParent() == null) continue;
            event.setAccepted(((AbstractMetaDataModelNode)event.getDropParent()).acceptsDrop(obj));
        }
    }

    @Bindable
    public void onModelTreeDrop(DropEvent event) {
        try {
            if (this.getModelerPerspective() == ModelerPerspective.ANALYSIS) {
                this.dimTreeHelper.onModelDrop(event);
            } else {
                this.catTreeHelper.onModelDrop(event);
            }
        }
        catch (Exception e) {
            event.setAccepted(false);
            try {
                XulMessageBox msg = null;
                msg = (XulMessageBox)this.document.createElement("messagebox");
                msg.setTitle(ModelerMessagesHolder.getMessages().getString("invalid_model", new String[0]));
                msg.setMessage(e.getCause().getMessage());
                msg.open();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Bindable
    public void addField() {
        try {
            if (this.getModelerPerspective() == ModelerPerspective.ANALYSIS) {
                this.dimTreeHelper.addField(this.getSelectedFields());
            } else {
                this.catTreeHelper.addField(this.getSelectedFields());
            }
        }
        catch (Exception e) {
            try {
                XulMessageBox msg = null;
                msg = (XulMessageBox)this.document.createElement("messagebox");
                msg.setTitle(ModelerMessagesHolder.getMessages().getString("invalid_model", new String[0]));
                msg.setMessage(e.getCause().getMessage());
                msg.open();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Bindable
    public void setSelectedFieldsChanged(Object selected) {
        if (selected != null && selected instanceof IAvailableItem) {
            this.selectedFields = new IAvailableItem[]{(IAvailableItem)selected};
        }
    }

    @Bindable
    public void init() throws ModelerException {
        this.bf.setDocument(this.document);
        this.propDeck = (XulDeck)this.document.getElementById("propertiesdeck");
        this.dimTreeHelper = new DimensionTreeHelper(this.propertiesForms, this.propDeck, this.workspace, this.document);
        this.catTreeHelper = new CategoryTreeHelper(this.propertiesForms, this.propDeck, this.workspace, this.document);
        this.dimensionTree = (XulTree)this.document.getElementById("dimensionTree");
        this.categoriesTree = (XulTree)this.document.getElementById("categoriesTree");
        this.modelDeck = (XulDeck)this.document.getElementById("modelDeck");
        this.reportingPanel = (XulVbox)this.document.getElementById("reportingModelPanel");
        this.reportingTabPanel = (XulTabpanel)this.document.getElementById("reportingTabPanel");
        this.modelPanel = (XulHbox)this.document.getElementById("modelPanel");
        this.modelTabbox = (XulTabbox)this.document.getElementById("modelTabbox");
        XulTree fieldListTree = (XulTree)this.document.getElementById(FIELD_LIST_ID);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.fieldListBinding = this.bf.createBinding((Object)this.workspace.getAvailableTables(), "children", FIELD_LIST_ID, "elements", new BindingConvertor[0]);
        this.selectedFieldsBinding = this.bf.createBinding(FIELD_LIST_ID, "selectedItem", (Object)this, "selectedFieldsChanged", new BindingConvertor[0]);
        this.bf.createBinding(FIELD_LIST_ID, "selectedItem", (Object)this.workspace, "selectedAvailableItem", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.workspace, "currentModelerPerspective", (Object)this.workspace, "currentModelerTreeHelper", new BindingConvertor[]{new BindingConvertor<ModelerPerspective, ModelerTreeHelper>(){

            public ModelerTreeHelper sourceToTarget(ModelerPerspective modelerPerspective) {
                switch (modelerPerspective) {
                    case ANALYSIS: {
                        return ModelerController.this.dimTreeHelper;
                    }
                    case REPORTING: {
                        return ModelerController.this.catTreeHelper;
                    }
                }
                return ModelerController.this.dimTreeHelper;
            }

            public ModelerPerspective targetToSource(ModelerTreeHelper modelerTreeHelper) {
                return null;
            }
        }});
        this.workspace.setCurrentModelerPerspective(this.workspace.getCurrentModelerPerspective());
        this.modelTreeBinding = this.bf.createBinding((Object)this.workspace, "model", (Object)this.dimensionTree, "elements", new BindingConvertor[0]);
        this.relModelTreeBinding = this.bf.createBinding((Object)this.workspace, "relationalModel", (Object)this.categoriesTree, "elements", new BindingConvertor[0]);
        this.modelerModeBinding = this.bf.createBinding((Object)this.workspace, "modellingMode", (Object)this, "modellingMode", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", (Object)this.dimTreeHelper, "treeSelectionChanged", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.categoriesTree, "selectedItem", (Object)this.catTreeHelper, "treeSelectionChanged", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.workspace.getModel(), "name", (Object)this.workspace.getRelationalModel(), "name", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.workspace, "selectedNode", (Object)this.dimensionTree, "selectedItems", new BindingConvertor[]{new BindingConvertor<AbstractMetaDataModelNode, Collection>(){

            public Collection sourceToTarget(AbstractMetaDataModelNode arg0) {
                return Collections.singletonList(arg0);
            }

            public AbstractMetaDataModelNode targetToSource(Collection arg0) {
                return arg0 == null || arg0.isEmpty() ? null : arg0.iterator().next();
            }
        }});
        this.bf.createBinding((Object)this.workspace, "selectedRelationalNode", (Object)this.categoriesTree, "selectedItems", new BindingConvertor[]{new BindingConvertor<AbstractMetaDataModelNode, Collection>(){

            public Collection sourceToTarget(AbstractMetaDataModelNode arg0) {
                return Collections.singletonList(arg0);
            }

            public AbstractMetaDataModelNode targetToSource(Collection arg0) {
                return arg0 == null || arg0.isEmpty() ? null : arg0.iterator().next();
            }
        }});
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "dimensionBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(DimensionMetaDataCollection.class)});
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "hierarchyBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(DimensionMetaData.class)});
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "measureBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(MeasuresCollection.class)});
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "levelBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(HierarchyMetaData.class)});
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "memberPropBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(LevelMetaData.class)});
        this.bf.createBinding((Object)this.dimensionTree, "selectedItem", "addField", "disabled", new BindingConvertor[]{new AcceptsDropConvertor(this.workspace, MeasuresCollection.class, HierarchyMetaData.class, LevelMetaData.class)});
        this.bf.createBinding(FIELD_LIST_ID, "selectedItem", "addField", "disabled", new BindingConvertor[]{new AcceptsAvailableItemDropConvertor(this.workspace)});
        this.bf.createBinding((Object)this.categoriesTree, "selectedItem", "addField", "disabled", new BindingConvertor[]{new AcceptsDropConvertor(this.workspace, CategoryMetaData.class, CategoryMetaDataCollection.class)});
        this.bf.createBinding((Object)this.categoriesTree, "selectedItem", "fieldBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(CategoryMetaData.class)});
        this.bf.createBinding((Object)this.categoriesTree, "selectedItem", "categoryBtn", "disabled", new BindingConvertor[]{new ButtonConvertor(CategoryMetaDataCollection.class)});
        this.bf.createBinding(FIELD_LIST_ID, "selectedItem", "fieldBtn", "disabled", new BindingConvertor[]{new AcceptsAvailableFieldDropConvertor(this.catTreeHelper, CategoryMetaData.class)});
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.fireBindings();
        this.dimensionTree.setSelectedItems(Collections.singletonList(this.workspace.getModel()));
        if (this.workspace.getRelationalModel().size() > 0) {
            this.categoriesTree.setSelectedItems(Collections.singletonList(this.workspace.getRelationalModel()));
        }
    }

    @Bindable
    public void showAutopopulatePrompt() {
        try {
            if (this.getModelerPerspective() == ModelerPerspective.ANALYSIS) {
                MainModelNode model = this.workspace.getModel();
                if (model.getDimensions().isEmpty() && model.getMeasures().isEmpty()) {
                    this.autoPopulate();
                } else {
                    this.showAutoModelConfirmDialog();
                }
            } else {
                RelationalModelNode model = this.workspace.getRelationalModel();
                if (model.getCategories().isEmpty()) {
                    this.autoPopulate();
                } else {
                    this.showAutoModelConfirmDialog();
                }
            }
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    private String getAutoPopulateMsg() {
        if (this.getModelerPerspective() == ModelerPerspective.ANALYSIS) {
            return ModelerMessagesHolder.getMessages().getString("auto_populate_msg", new String[0]);
        }
        return ModelerMessagesHolder.getMessages().getString("auto_populate_relational_msg", new String[0]);
    }

    private void showAutoModelConfirmDialog() throws XulException {
        XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
        confirm.setTitle(ModelerMessagesHolder.getMessages().getString("auto_populate_title", new String[0]));
        confirm.setMessage(this.getAutoPopulateMsg());
        confirm.setAcceptLabel(ModelerMessagesHolder.getMessages().getString("yes", new String[0]));
        confirm.setCancelLabel(ModelerMessagesHolder.getMessages().getString("no", new String[0]));
        confirm.addDialogCallback(new XulDialogCallback(){

            public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                if (returnCode == XulDialogCallback.Status.ACCEPT) {
                    ModelerController.this.autoPopulate();
                }
            }

            public void onError(XulComponent sender, Throwable t) {
            }
        });
        confirm.open();
    }

    protected void fireBindings() throws ModelerException {
        try {
            this.modelerModeBinding.fireSourceChanged();
            this.fieldListBinding.fireSourceChanged();
            this.selectedFieldsBinding.fireSourceChanged();
            this.modelTreeBinding.fireSourceChanged();
            this.relModelTreeBinding.fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ModelerException(e);
        }
    }

    @Bindable
    public void refreshFields() throws ModelerException {
        this.workspace.refresh(this.workspace.getModellingMode());
    }

    public void setFileName(String fileName) {
        this.workspace.setFileName(fileName);
    }

    @Bindable
    public void showNewMeasureDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewMeasureTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewMeasureText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        MeasuresCollection theMesaures = (MeasuresCollection)ModelerController.this.dimTreeHelper.getSelectedTreeItem();
                        MeasureMetaData theMeasure = new MeasureMetaData("" + retVal, "", "" + retVal, ModelerController.this.workspace.getWorkspaceHelper().getLocale());
                        theMeasure.setParent(theMesaures);
                        theMeasure.validate();
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        ModelerController.this.workspace.setModelIsChanging(true);
                        theMesaures.add(theMeasure);
                        ModelerController.this.workspace.setModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewHierarchyDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewHierarchyTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewHierarchyText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        DimensionMetaData theDimension = (DimensionMetaData)ModelerController.this.dimTreeHelper.getSelectedTreeItem();
                        HierarchyMetaData theHieararchy = new HierarchyMetaData("" + retVal);
                        theHieararchy.setParent(theDimension);
                        theHieararchy.setExpanded(true);
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        ModelerController.this.workspace.setModelIsChanging(true);
                        theDimension.add(theHieararchy);
                        ModelerController.this.workspace.setModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewLevelDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewLevelTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewLevelText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        HierarchyMetaData theHierarchy = (HierarchyMetaData)ModelerController.this.dimTreeHelper.getSelectedTreeItem();
                        LevelMetaData theLevel = new LevelMetaData(theHierarchy, "" + retVal);
                        theLevel.validate();
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        ModelerController.this.workspace.setModelIsChanging(true);
                        theHierarchy.add(theLevel);
                        ModelerController.this.workspace.setModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewMemberPropDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewMemberPropertyTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewMemberPropertyText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        LevelMetaData theLevel = (LevelMetaData)ModelerController.this.dimTreeHelper.getSelectedTreeItem();
                        MemberPropertyMetaData theMemberProp = new MemberPropertyMetaData(theLevel, "" + retVal);
                        theMemberProp.validate();
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        ModelerController.this.workspace.setModelIsChanging(true);
                        theLevel.add(theMemberProp);
                        ModelerController.this.workspace.setModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewDimensionDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewDimensionTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewDimensionText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        DimensionMetaData dimension = new DimensionMetaData("" + retVal);
                        dimension.setExpanded(true);
                        HierarchyMetaData hierarchy = new HierarchyMetaData("" + retVal);
                        hierarchy.setExpanded(true);
                        hierarchy.validate();
                        hierarchy.setParent(dimension);
                        dimension.add(hierarchy);
                        ModelerController.this.workspace.addDimension(dimension);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewCategoryDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewCategoryTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewCategoryText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        CategoryMetaDataCollection theNode = ModelerController.this.workspace.getRelationalModel().getCategories();
                        CategoryMetaData theCategory = new CategoryMetaData("" + retVal);
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        theCategory.validate();
                        ModelerController.this.workspace.setRelationalModelIsChanging(true);
                        theNode.add(theCategory);
                        theCategory.setExpanded(true);
                        ModelerController.this.workspace.setRelationalModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void showNewFieldDialog() {
        try {
            XulPromptBox prompt = (XulPromptBox)this.document.createElement("promptbox");
            prompt.setTitle(ModelerMessagesHolder.getMessages().getString("ModelerController.NewFieldTitle", new String[0]));
            prompt.setMessage(ModelerMessagesHolder.getMessages().getString("ModelerController.NewFieldText", new String[0]));
            prompt.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        CategoryMetaData theCategory = (CategoryMetaData)ModelerController.this.catTreeHelper.getSelectedTreeItem();
                        FieldMetaData theField = new FieldMetaData(theCategory, "" + retVal, "", "" + retVal, ModelerController.this.workspace.getWorkspaceHelper().getLocale());
                        theField.validate();
                        boolean prevChangeState = ModelerController.this.workspace.isModelChanging();
                        ModelerController.this.workspace.setRelationalModelIsChanging(true);
                        theCategory.add(theField);
                        theCategory.setExpanded(true);
                        ModelerController.this.workspace.setRelationalModelIsChanging(prevChangeState);
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                    t.printStackTrace();
                }
            });
            prompt.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void removeField() {
        this.dimTreeHelper.removeField();
    }

    @Bindable
    public void removeRelationalNode() {
        this.catTreeHelper.removeField();
    }

    @Bindable
    public void moveFieldUp() {
        this.dimTreeHelper.moveFieldUp();
    }

    @Bindable
    public void moveFieldDown() {
        this.dimTreeHelper.moveFieldDown();
    }

    @Bindable
    public void moveRelationalFieldUp() {
        this.catTreeHelper.moveFieldUp();
    }

    @Bindable
    public void moveRelationalFieldDown() {
        this.catTreeHelper.moveFieldDown();
    }

    public ModelerWorkspace getModel() {
        return this.workspace;
    }

    public void setModel(ModelerWorkspace model) throws ModelerException {
        this.workspace = model;
        this.fireBindings();
    }

    @Bindable
    public void showValidationMessagesDialog() {
        AbstractMetaDataModelNode node;
        if (this.workspace.getCurrentModelerPerspective() == ModelerPerspective.ANALYSIS) {
            node = this.workspace.getSelectedNode();
            if (node == null) {
                node = this.workspace.getModel();
            }
        } else {
            node = this.workspace.getSelectedRelationalNode();
            if (node == null) {
                node = this.workspace.getRelationalModel();
            }
        }
        this.showValidationMessages(new ArrayList<String>(node.getValidationMessages()));
    }

    protected void showValidationMessages() {
        this.showValidationMessages(this.workspace.getValidationMessages());
    }

    protected void showValidationMessages(List<String> messages) {
        StringBuffer validationErrors = new StringBuffer(ModelerMessagesHolder.getMessages().getString("model_contains_errors", new String[0]));
        for (String msg : messages) {
            validationErrors.append(msg);
            validationErrors.append("\n");
        }
        try {
            XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
            msg.setTitle(ModelerMessagesHolder.getMessages().getString("model_not_valid", new String[0]));
            msg.setMessage(validationErrors.toString());
            msg.open();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public void resolveMissingColumn() {
        if (this.dimTreeHelper.getSelectedTreeItem() instanceof ColumnBackedNode && !((AbstractMetaDataModelNode)this.dimTreeHelper.getSelectedTreeItem()).isValid()) {
            this.changeColumn();
        } else if (this.catTreeHelper.getSelectedTreeItem() instanceof ColumnBackedNode && !((AbstractMetaDataModelNode)this.catTreeHelper.getSelectedTreeItem()).isValid()) {
            this.changeColumn();
        }
    }

    @Bindable
    public void changeColumn() {
        ModelerTreeHelper helper = null;
        switch (this.workspace.getCurrentModelerPerspective()) {
            case REPORTING: {
                helper = this.catTreeHelper;
                break;
            }
            default: {
                helper = this.dimTreeHelper;
            }
        }
        ColumnBackedNode selected = (ColumnBackedNode)helper.getSelectedTreeItem();
        AbstractMetaDataModelNode parent = (AbstractMetaDataModelNode)((AbstractMetaDataModelNode)helper.getSelectedTreeItem()).getParent();
        IPhysicalTable restrictedPhysicalTable = selected.getTableRestriction();
        if (restrictedPhysicalTable != null) {
            AvailableTable restrictToTable = null;
            restrictToTable = this.workspace.getAvailableTables().findAvailableTable(restrictedPhysicalTable.getName(this.getWorkspaceHelper().getLocale()));
            this.colController.show(this.workspace, selected, restrictToTable);
        } else {
            this.colController.show(this.workspace, selected);
        }
    }

    public void addPropertyForm(AbstractModelerNodeForm form) {
        this.propertiesForms.put(form.getClass(), form);
    }

    public void setColResolver(ColResolverController controller) {
        this.colController = controller;
    }

    public void autoPopulate() {
        try {
            switch (this.workspace.getCurrentModelerPerspective()) {
                case REPORTING: {
                    this.workspace.getWorkspaceHelper().autoModelRelationalFlatInBackground(this.workspace);
                    this.categoriesTree.expandAll();
                    break;
                }
                case ANALYSIS: {
                    this.workspace.getWorkspaceHelper().autoModelFlatInBackground(this.workspace);
                    this.dimensionTree.expandAll();
                }
            }
        }
        catch (ModelerException e) {
            e.printStackTrace();
        }
    }

    public void togglePropertiesPanel() {
        this.setPropVisible(!this.isPropVisible());
    }

    public boolean isPropVisible() {
        return this.propVisible;
    }

    public void setPropVisible(boolean vis) {
        boolean prevVal = this.propVisible;
        this.propVisible = vis;
        this.firePropertyChange("propVisible", prevVal, vis);
    }

    @Bindable
    public void setSelectedFields(Object[] aFields) {
        IAvailableItem[] f = new IAvailableItem[aFields.length];
        for (int i = 0; i < aFields.length; ++i) {
            if (aFields[i] instanceof AvailableField) {
                f[i] = (AvailableField)aFields[i];
                continue;
            }
            if (!(aFields[i] instanceof AvailableTable)) continue;
            f[i] = (AvailableTable)aFields[i];
        }
        this.selectedFields = f;
    }

    @Bindable
    public Object[] getSelectedFields() {
        if (this.selectedFields == null) {
            this.selectedFields = new IAvailableItem[0];
        }
        return this.selectedFields;
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
    }

    public IModelerWorkspaceHelper getWorkspaceHelper() {
        return this.workspace.getWorkspaceHelper();
    }

    public void setWorkspaceHelper(IModelerWorkspaceHelper workspaceHelper) {
        this.workspace.setWorkspaceHelper(workspaceHelper);
    }

    public boolean saveWorkspace(String fileName) throws ModelerException {
        this.workspace.getModel().validateTree();
        if (!this.workspace.isValid()) {
            this.showValidationMessages();
            return false;
        }
        this.workspace.setFileName(fileName);
        this.workspace.setDirty(false);
        this.workspace.setTemporary(false);
        return true;
    }

    public void resetPropertyForm() {
        this.propDeck.setSelectedIndex(0);
        this.dimTreeHelper.setSelectedTreeItem(null);
        this.catTreeHelper.setSelectedTreeItem(null);
    }

    @Bindable
    public void showReportingOnlyMode() {
        this.setModellingMode(ModelerMode.REPORTING_ONLY);
    }

    @Bindable
    public void showAnalysisAndReportingMode() {
        this.setModellingMode(ModelerMode.ANALYSIS_AND_REPORTING);
    }

    @Bindable
    public ModelerMode getModellingMode() {
        return this.workspace.getModellingMode();
    }

    @Bindable
    public void setModellingMode(ModelerMode mode) {
        if (mode == ModelerMode.REPORTING_ONLY) {
            if (this.reportingTabPanel.getChildNodes().size() > 0 && this.modelPanel.getChildNodes().size() == 0) {
                int height = this.modelPanel.getHeight();
                this.modelPanel.addComponent((XulComponent)this.reportingPanel);
                this.modelPanel.setHeight(height);
            }
            this.modelDeck.setSelectedIndex(1);
            this.workspace.setCurrentModelerPerspective(ModelerPerspective.REPORTING);
        } else {
            if (this.modelPanel.getChildNodes().size() > 0 && this.reportingTabPanel.getChildNodes().size() == 0) {
                this.reportingTabPanel.addComponent((XulComponent)this.reportingPanel);
            }
            this.modelDeck.setSelectedIndex(0);
            if (this.modelTabbox.getSelectedIndex() == 0) {
                this.workspace.setCurrentModelerPerspective(ModelerPerspective.ANALYSIS);
            } else {
                this.workspace.setCurrentModelerPerspective(ModelerPerspective.REPORTING);
            }
        }
        this.workspace.setModellingMode(mode);
    }

    @Bindable
    public void clearFields() {
        this.dimTreeHelper.clearFields();
    }

    @Bindable
    public void clearRelationalFields() {
        this.catTreeHelper.clearFields();
    }

    public ModelerPerspective getModelerPerspective() {
        return this.workspace.getCurrentModelerPerspective();
    }

    public void setModelerPerspective(ModelerPerspective perspective) {
        ModelerPerspective prevVal = this.workspace.getCurrentModelerPerspective();
        this.workspace.setCurrentModelerPerspective(perspective);
        if (prevVal != perspective) {
            this.modelTabbox.setSelectedIndex(perspective == ModelerPerspective.ANALYSIS ? 0 : 1);
        }
        if (perspective == ModelerPerspective.ANALYSIS) {
            this.dimTreeHelper.setTreeSelectionChanged(this.dimTreeHelper.getSelectedTreeItem());
        } else {
            this.catTreeHelper.setTreeSelectionChanged(this.catTreeHelper.getSelectedTreeItem());
        }
    }

    @Bindable
    public void setModelerPerspective(String perspective) {
        this.setModelerPerspective(ModelerPerspective.valueOf(perspective));
    }

    public DimensionTreeHelper getDimTreeHelper() {
        if (this.dimTreeHelper == null) {
            this.dimTreeHelper = new DimensionTreeHelper(this.propertiesForms, this.propDeck, this.workspace, this.document);
        }
        return this.dimTreeHelper;
    }

    public CategoryTreeHelper getCatTreeHelper() {
        if (this.catTreeHelper == null) {
            this.catTreeHelper = new CategoryTreeHelper(this.propertiesForms, this.propDeck, this.workspace, this.document);
        }
        return this.catTreeHelper;
    }

    @Bindable
    public void collapseAll() {
        this.dimensionTree.collapseAll();
    }

    @Bindable
    public void expandAll() {
        this.dimensionTree.expandAll();
    }

    @Bindable
    public void collapseRelationalAll() {
        this.categoriesTree.collapseAll();
    }

    @Bindable
    public void expandRelationalAll() {
        this.categoriesTree.expandAll();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptsDropConvertor
    extends BindingConvertor<Object, Boolean> {
        private Set<Class> types;
        private ModelerWorkspace workspace;

        public AcceptsDropConvertor(ModelerWorkspace workspace, Class ... aClasses) {
            this.types = new HashSet<Class>(Arrays.asList(aClasses));
            this.workspace = workspace;
        }

        public Boolean sourceToTarget(Object value) {
            IAvailableItem selected;
            if (value == null || !this.types.contains(value.getClass())) {
                return true;
            }
            if (this.workspace != null && (selected = this.workspace.getSelectedAvailableItem()) instanceof AvailableField) {
                AbstractMetaDataModelNode node = (AbstractMetaDataModelNode)value;
                AvailableField n = (AvailableField)selected;
                return !node.acceptsDrop(n);
            }
            return true;
        }

        public Object targetToSource(Boolean value) {
            return null;
        }
    }

    private static class AcceptsAvailableItemDropConvertor
    extends AcceptsAvailableFieldDropConvertor {
        private ModelerWorkspace workspace;

        public AcceptsAvailableItemDropConvertor(ModelerWorkspace workspace) {
            super(workspace.getCurrentModelerTreeHelper());
            this.types.add(AvailableTable.class);
            this.workspace = workspace;
        }

        public AcceptsAvailableItemDropConvertor(ModelerWorkspace workspace, Class aClass) {
            super(workspace.getCurrentModelerTreeHelper(), aClass);
            this.types.add(AvailableTable.class);
            this.workspace = workspace;
        }

        public ModelerTreeHelper getHelper() {
            return this.workspace.getCurrentModelerTreeHelper();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptsAvailableFieldDropConvertor
    extends BindingConvertor<Object, Boolean> {
        private ModelerTreeHelper helper;
        protected Set<Class> types = new HashSet<Class>();
        private Class restrictType;

        public AcceptsAvailableFieldDropConvertor(ModelerTreeHelper helper) {
            this.helper = helper;
            this.types.add(AvailableField.class);
        }

        public AcceptsAvailableFieldDropConvertor(ModelerTreeHelper helper, Class aClass) {
            this.helper = helper;
            this.restrictType = aClass;
            this.types.add(AvailableField.class);
        }

        public ModelerTreeHelper getHelper() {
            return this.helper;
        }

        public void setHelper(ModelerTreeHelper helper) {
            this.helper = helper;
        }

        public Boolean sourceToTarget(Object value) {
            if (this.getHelper() == null) {
                return true;
            }
            Object obj = this.getHelper().getSelectedTreeItem();
            if (value == null || !this.types.contains(value.getClass())) {
                return true;
            }
            if (this.restrictType != null) {
                if (obj instanceof AbstractMetaDataModelNode && obj.getClass() == this.restrictType) {
                    AbstractMetaDataModelNode n = (AbstractMetaDataModelNode)obj;
                    return !n.acceptsDrop(value);
                }
            } else if (obj instanceof AbstractMetaDataModelNode) {
                AbstractMetaDataModelNode n = (AbstractMetaDataModelNode)obj;
                return !n.acceptsDrop(value);
            }
            return true;
        }

        public Object targetToSource(Boolean value) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonConvertor
    extends BindingConvertor<Object, Boolean> {
        private Class type;

        public ButtonConvertor(Class aClass) {
            this.type = aClass;
        }

        public Boolean sourceToTarget(Object value) {
            return value == null || value.getClass() != this.type;
        }

        public Object targetToSource(Boolean value) {
            return null;
        }
    }
}

