/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.geo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.geo.LatLngRole;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MemberPropertyMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationRole
extends GeoRole
implements Serializable {
    private static final String LOCATION = "location";
    private LatLngRole latitudeRole;
    private LatLngRole longitudeRole;

    public LocationRole() {
    }

    public LocationRole(LatLngRole latitudeRole, LatLngRole longitudeRole) {
        this.latitudeRole = latitudeRole;
        this.longitudeRole = longitudeRole;
    }

    public LocationRole(LatLngRole latitudeRole, String displayName, LatLngRole longitudeRole) {
        this.latitudeRole = latitudeRole;
        this.displayName = displayName;
        this.longitudeRole = longitudeRole;
    }

    @Override
    public String getName() {
        return LOCATION;
    }

    public LatLngRole getLatitudeRole() {
        return this.latitudeRole;
    }

    public void setLatitudeRole(LatLngRole latitudeRole) {
        this.latitudeRole = latitudeRole;
    }

    public LatLngRole getLongitudeRole() {
        return this.longitudeRole;
    }

    public void setLongitudeRole(LatLngRole longitudeRole) {
        this.longitudeRole = longitudeRole;
    }

    @Override
    public boolean evaluate(String fieldName) {
        boolean result = false;
        if (this.latitudeRole != null && (result = this.latitudeRole.evaluate(fieldName))) {
            return result;
        }
        if (this.longitudeRole != null) {
            return result || this.longitudeRole.evaluate(fieldName);
        }
        return result;
    }

    public boolean evaluateLatitude(String fieldName) {
        if (this.latitudeRole != null) {
            return this.latitudeRole.evaluate(fieldName);
        }
        return false;
    }

    public boolean evaluateLongitude(String fieldName) {
        if (this.longitudeRole != null) {
            return this.longitudeRole.evaluate(fieldName);
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocationRole that = (LocationRole)o;
        if (this.latitudeRole != null ? !this.latitudeRole.equals(that.latitudeRole) : that.latitudeRole != null) {
            return false;
        }
        return !(this.longitudeRole != null ? !this.longitudeRole.equals(that.longitudeRole) : that.longitudeRole != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.latitudeRole != null ? this.latitudeRole.hashCode() : 0);
        result = 31 * result + (this.longitudeRole != null ? this.longitudeRole.hashCode() : 0);
        return result;
    }

    @Override
    public GeoRole clone() {
        LocationRole clone = new LocationRole();
        clone.setLatitudeRole(this.latitudeRole == null ? null : this.latitudeRole.clone());
        clone.setLongitudeRole(this.longitudeRole == null ? null : this.longitudeRole.clone());
        clone.setMatchSeparator(this.getMatchSeparator());
        clone.setName(this.getName());
        return clone;
    }

    public String getPrefix() {
        String prefix;
        if (this.latitudeRole != null && this.longitudeRole != null && (prefix = this.latitudeRole.getPrefix()).equalsIgnoreCase(this.longitudeRole.getPrefix())) {
            return prefix;
        }
        return "";
    }

    @Override
    public String getDataType() {
        return "LOCATION_ROLE";
    }

    @Override
    public boolean isValid(AbstractMetaDataModelNode node) {
        if (node instanceof LevelMetaData) {
            LevelMetaData level = (LevelMetaData)node;
            boolean latFound = false;
            boolean lonFound = false;
            Iterator i$ = level.iterator();
            while (i$.hasNext()) {
                MemberPropertyMetaData member = (MemberPropertyMetaData)i$.next();
                if (member.getName().equals("latitude")) {
                    latFound = true;
                    continue;
                }
                if (!member.getName().equals("longitude")) continue;
                lonFound = true;
            }
            return latFound & lonFound;
        }
        return super.isValid(node);
    }

    @Override
    public List<String> getValidationMessages(AbstractMetaDataModelNode node) {
        ArrayList<String> messages = new ArrayList<String>();
        if (node instanceof LevelMetaData) {
            LevelMetaData level = (LevelMetaData)node;
            boolean latFound = false;
            boolean lonFound = false;
            Iterator i$ = level.iterator();
            while (i$.hasNext()) {
                MemberPropertyMetaData member = (MemberPropertyMetaData)i$.next();
                if (member.getName().equals("latitude")) {
                    latFound = true;
                    continue;
                }
                if (!member.getName().equals("longitude")) continue;
                lonFound = true;
            }
            if (!latFound) {
                messages.add(ModelerMessagesHolder.getMessages().getString("validation.level.MISSING_LAT", new String[0]));
            }
            if (!lonFound) {
                messages.add(ModelerMessagesHolder.getMessages().getString("validation.level.MISSING_LON", new String[0]));
            }
        }
        return messages;
    }

    @Override
    public void onAttach(AbstractMetaDataModelNode node) {
        super.onAttach(node);
        if (!(node instanceof LevelMetaData)) {
            return;
        }
        LevelMetaData level = (LevelMetaData)node;
        if (level.getLatitudeField() == null) {
            level.add(new MemberPropertyMetaData(level, "latitude"));
        }
        if (level.getLongitudeField() == null) {
            level.add(new MemberPropertyMetaData(level, "longitude"));
        }
    }

    @Override
    public void onDetach(AbstractMetaDataModelNode node) {
        MemberPropertyMetaData lon;
        super.onDetach(node);
        if (!(node instanceof LevelMetaData)) {
            return;
        }
        LevelMetaData level = (LevelMetaData)node;
        MemberPropertyMetaData lat = level.getLatitudeField();
        if (lat != null && lat.getLogicalColumn() == null) {
            level.remove(lat);
        }
        if ((lon = level.getLongitudeField()) != null && lon.getLogicalColumn() == null) {
            level.remove(lon);
        }
    }
}

