/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.IAvailableItem;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableItemCollection
extends AbstractModelList<IAvailableItem>
implements Serializable {
    public static final String IMAGE_FILE = "";
    private static final long serialVersionUID = -3640424842982505015L;
    private boolean expanded = true;
    private String name;
    private String image;
    private Comparator<IAvailableItem> itemComparator = new Comparator<IAvailableItem>(){

        @Override
        public int compare(IAvailableItem arg0, IAvailableItem arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    };

    public AvailableItemCollection() {
        this.setImage(IMAGE_FILE);
    }

    @Bindable
    public List<IAvailableItem> getChildren() {
        int tableCount = this.getAvailableTableCount();
        if (tableCount == 1) {
            return this.getAsFlatAvailableFieldsList();
        }
        Collections.sort(this.children, this.itemComparator);
        return this.children;
    }

    @Bindable
    public void setChildren(List<IAvailableItem> children) {
        this.children = children;
        this.fireCollectionChanged();
    }

    public AvailableTable findAvailableTable(String tableName) {
        for (IAvailableItem item : this.children) {
            AvailableTable table;
            if (!(item instanceof AvailableTable) || !(table = (AvailableTable)item).getName().equals(tableName)) continue;
            return table;
        }
        return null;
    }

    public int getAvailableTableCount() {
        int count = 0;
        for (IAvailableItem item : this.children) {
            if (!(item instanceof AvailableTable)) continue;
            ++count;
        }
        return count;
    }

    public List<AvailableTable> getAsAvailableTablesList() {
        ArrayList<AvailableTable> tables = new ArrayList<AvailableTable>();
        for (IAvailableItem item : this.children) {
            if (!(item instanceof AvailableTable)) continue;
            tables.add((AvailableTable)item);
        }
        return tables;
    }

    protected List<IAvailableItem> getAsFlatAvailableFieldsList() {
        ArrayList<IAvailableItem> fields = new ArrayList<IAvailableItem>();
        for (IAvailableItem item : this.children) {
            if (!(item instanceof AvailableTable)) continue;
            AvailableTable table = (AvailableTable)item;
            for (AvailableField field : table.getAvailableFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    @Bindable
    public boolean isExpanded() {
        return this.expanded;
    }

    @Bindable
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public void setName(String name) {
        this.name = name;
    }

    @Bindable
    public String getImage() {
        return this.image;
    }

    @Bindable
    public void setImage(String image) {
        this.image = image;
    }

    public AvailableTable findFactTable() {
        for (IAvailableItem item : this.children) {
            AvailableTable table;
            if (!(item instanceof AvailableTable) || !(table = (AvailableTable)item).isFactTable()) continue;
            return table;
        }
        return null;
    }

    public void setFactTable(IPhysicalTable table) {
        for (IAvailableItem item : this.children) {
            if (!(item instanceof AvailableTable)) continue;
            AvailableTable t = (AvailableTable)item;
            if (!t.isSameUnderlyingPhysicalTable(table) && t.isFactTable()) {
                t.setFactTable(false);
                continue;
            }
            if (!t.isSameUnderlyingPhysicalTable(table)) continue;
            t.setFactTable(true);
        }
    }
}

