/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.propforms.LevelsPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseColumnBackedMetaData<T extends AbstractMetaDataModelNode>
extends AbstractMetaDataModelNode<T>
implements Serializable,
ColumnBackedNode {
    private static final long serialVersionUID = -7342401951588541248L;
    protected String name;
    protected String columnName;
    protected transient LogicalColumn logicalColumn;
    protected Boolean uniqueMembers = false;
    private static final String IMAGE = "images/sm_level_icon.png";
    private String description = "";

    public BaseColumnBackedMetaData() {
    }

    @Override
    public String getValidImage() {
        return IMAGE;
    }

    public BaseColumnBackedMetaData(String name) {
        this.name = name;
        this.columnName = name;
    }

    @Override
    @Bindable
    public String getName() {
        return this.name;
    }

    @Override
    public IPhysicalTable getTableRestriction() {
        return null;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Bindable
    public String getDescription() {
        if (this.getLogicalColumn() != null && !this.description.equals(this.getLogicalColumn().getId())) {
            return this.description;
        }
        return "";
    }

    @Bindable
    public void setDescription(String description) {
        if (!description.equals(this.description)) {
            String oldDesc = this.description;
            this.description = description;
            this.firePropertyChange("description", oldDesc, description);
            this.validateNode();
        }
    }

    @Bindable
    public String getColumnName() {
        return this.columnName;
    }

    @Bindable
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    @Bindable
    public LogicalColumn getLogicalColumn() {
        return this.logicalColumn;
    }

    @Override
    public void setLogicalColumn(LogicalColumn col) {
        LogicalColumn prevVal = this.logicalColumn;
        this.logicalColumn = col;
        this.validateNode();
        this.firePropertyChange("logicalColumn", prevVal, col);
    }

    public void setUniqueMembers(Boolean uniqueMembers) {
        this.uniqueMembers = uniqueMembers;
    }

    public Boolean isUniqueMembers() {
        return this.uniqueMembers;
    }

    @Override
    public void validate() {
        String prevMessages = this.getValidationMessagesString();
        this.valid = true;
        this.validationMessages.clear();
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("MISSING_NAME"), new String[0]));
            this.valid = false;
        }
        if (this.logicalColumn == null) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("MISSING_BACKING_COLUMN"), this.getName()));
            this.valid = false;
        }
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return LevelsPropertiesForm.class;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        throw new ModelerException(new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0])));
    }

    public String getValidationMessageKey(String key) {
        return "validation.measure." + key;
    }
}

