/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.TimeRole;
import org.pentaho.agilebi.modeler.propforms.DimensionPropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionMetaData
extends AbstractMetaDataModelNode<HierarchyMetaData>
implements Serializable {
    private static final long serialVersionUID = -891901735974255178L;
    String name;

    public DimensionMetaData() {
    }

    public DimensionMetaData(String name) {
        this.name = name;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Bindable
    public String toString() {
        return "Dimension Name: " + this.name;
    }

    @Override
    @Bindable
    public String getValidImage() {
        return "images/sm_dim_icon.png";
    }

    @Override
    @Bindable
    public void validate() {
        this.validationMessages.clear();
        this.valid = true;
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.dimension.MISSING_NAME", new String[0]));
            this.valid = false;
        }
        if (this.size() == 0) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.dimension.REQUIRES_AT_LEAST_ONE_HIERARCHY", new String[0]));
            this.valid = false;
        }
        HashMap<String, HierarchyMetaData> usedNames = new HashMap<String, HierarchyMetaData>();
        for (HierarchyMetaData hier : this.children) {
            this.valid &= hier.isValid();
            this.validationMessages.addAll(hier.getValidationMessages());
            if (usedNames.containsKey(hier.getName())) {
                HierarchyMetaData h;
                this.valid = false;
                String msg = ModelerMessagesHolder.getMessages().getString("validation.dimension.DUPLICATE_HIERARCHY_NAMES", hier.getName());
                this.validationMessages.add(msg);
                hier.invalidate();
                if (!hier.getValidationMessages().contains(msg)) {
                    hier.getValidationMessages().add(msg);
                }
                if (!(h = (HierarchyMetaData)usedNames.get(hier.getName())).isValid()) continue;
                h.invalidate();
                if (h.getValidationMessages().contains(msg)) continue;
                h.getValidationMessages().add(msg);
                continue;
            }
            usedNames.put(hier.getName(), hier);
        }
    }

    @Bindable
    public boolean equals(DimensionMetaData obj) {
        if (obj instanceof DimensionMetaData) {
            DimensionMetaData dim = obj;
            return this.name != null && this.name.equals(dim.name);
        }
        return false;
    }

    @Bindable
    public boolean isTime() {
        return this.dataRole instanceof TimeRole;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public Class getPropertiesForm() {
        return DimensionPropertiesForm.class;
    }

    @Override
    public void onAdd(HierarchyMetaData child) {
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(HierarchyMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return obj instanceof AvailableField || obj instanceof HierarchyMetaData || obj instanceof LevelMetaData || obj instanceof MeasureMetaData;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            if (data instanceof AvailableField) {
                ColumnBackedNode node = this.getWorkspace().createColumnBackedNode((AvailableField)data, ModelerPerspective.ANALYSIS);
                return this.getWorkspace().createHierarchyForParentWithNode(this, node);
            }
            if (data instanceof HierarchyMetaData) {
                return data;
            }
            if (data instanceof LevelMetaData) {
                LevelMetaData level = (LevelMetaData)data;
                HierarchyMetaData hier = this.getWorkspace().createHierarchyForParentWithNode(this, level);
                hier.setName(level.getName());
                ((LevelMetaData)hier.get(0)).setName(level.getName());
                return hier;
            }
            if (data instanceof MeasureMetaData) {
                MeasureMetaData measure = (MeasureMetaData)data;
                HierarchyMetaData hier = this.getWorkspace().createHierarchyForParentWithNode(this, measure);
                hier.setName(measure.getName());
                ((LevelMetaData)hier.get(0)).setName(measure.getName());
                return hier;
            }
            throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

