/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.strategy;

import java.util.HashSet;
import java.util.List;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.AvailableTable;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaData;
import org.pentaho.agilebi.modeler.nodes.DimensionMetaDataCollection;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.MainModelNode;
import org.pentaho.agilebi.modeler.nodes.MeasureMetaData;
import org.pentaho.agilebi.modeler.nodes.MeasuresCollection;
import org.pentaho.agilebi.modeler.strategy.SimpleAutoModelStrategy;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.types.DataType;

public class StarSchemaAutoModelStrategy
extends SimpleAutoModelStrategy {
    public StarSchemaAutoModelStrategy(String locale) {
        super(locale);
    }

    public StarSchemaAutoModelStrategy(String locale, GeoContext geoContext) {
        super(locale, geoContext);
    }

    public void autoModelOlap(ModelerWorkspace workspace, MainModelNode mainModel) throws ModelerException {
        mainModel.setName(workspace.getModelName());
        workspace.setModel(mainModel);
        DimensionMetaDataCollection dims = workspace.getModel().getDimensions();
        dims.clear();
        dims.setExpanded(true);
        MeasuresCollection measures = workspace.getModel().getMeasures();
        measures.setExpanded(false);
        measures.clear();
        boolean prevChangeState = workspace.isModelChanging();
        workspace.setModelIsChanging(true, !mainModel.getSuppressEvents());
        for (LogicalTable table : workspace.getLogicalModel(ModelerPerspective.ANALYSIS).getLogicalTables()) {
            table.getLogicalColumns().clear();
        }
        HashSet<String> existingMeasures = new HashSet<String>();
        List<AvailableTable> tableList = workspace.getAvailableTables().getAsAvailableTablesList();
        for (AvailableTable table : tableList) {
            boolean isFact = table.isFactTable();
            if (isFact) {
                for (AvailableField field : table.getAvailableFields()) {
                    DataType dataType = field.getPhysicalColumn().getDataType();
                    if (dataType == DataType.NUMERIC) {
                        if (existingMeasures.contains(field.getName())) continue;
                        MeasureMetaData measure = workspace.createMeasureForNode(field);
                        workspace.getModel().getMeasures().add(measure);
                        existingMeasures.add(field.getName());
                        continue;
                    }
                    workspace.createColumnBackedNode(field, ModelerPerspective.ANALYSIS);
                }
                continue;
            }
            DimensionMetaData dim = new DimensionMetaData(table.getName());
            dim.setExpanded(false);
            for (AvailableField field : table.getAvailableFields()) {
                if (this.isGeoField(field)) continue;
                HierarchyMetaData hierarchy = new HierarchyMetaData(field.getName());
                hierarchy.setParent(dim);
                hierarchy.setExpanded(false);
                dim.add(hierarchy);
                LevelMetaData level = workspace.createLevelForParentWithNode(hierarchy, workspace.createColumnBackedNode(field, ModelerPerspective.ANALYSIS));
                if (level == null) continue;
                hierarchy.add(level);
            }
            if (dim.size() <= 0) continue;
            workspace.addDimension(dim);
        }
        this.addGeoDimensions((List<DimensionMetaData>)((Object)workspace.getModel().getDimensions()), workspace);
        if (!mainModel.getSuppressEvents()) {
            workspace.setModelIsChanging(prevChangeState);
            workspace.setSelectedNode(workspace.getModel());
        }
    }
}

