/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.util;

import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.modeler.ModelerConversionUtil;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelGenerator;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.automodel.SchemaTable;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.schema.concept.DefaultPropertyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerSourceUtil {
    public static final String DEFAULT_ROLE_NAME = "Authenticated";
    private static ModelGenerator generator = new ModelGenerator();
    private static Logger logger = LoggerFactory.getLogger(ModelerSourceUtil.class);

    public static void verifyTableExistsAndMayBeQuoted(DatabaseMeta databaseMeta, String schemaName, String tableName) throws ModelerException {
        String quotedTable;
        Database database = new Database(databaseMeta);
        String quotedSchema = schemaName;
        if (!StringUtils.isBlank((String)quotedSchema)) {
            quotedSchema = databaseMeta.getStartQuote() + quotedSchema + databaseMeta.getEndQuote();
        }
        if (!StringUtils.isBlank((String)(quotedTable = tableName))) {
            quotedTable = databaseMeta.getStartQuote() + quotedTable + databaseMeta.getEndQuote();
        }
        String schemaTableCombination = databaseMeta.getQuotedSchemaTableCombination(quotedSchema, quotedTable);
        try {
            database.connect();
            database.getTableFields(schemaTableCombination);
        }
        catch (KettleDatabaseException e) {
            throw new ModelerException(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelerSourceUtil.FAILED_TO_GET_TABLE_FIELDS", (String[])new String[]{schemaTableCombination}), e);
        }
        finally {
            database.disconnect();
        }
    }

    public static Domain generateDomain(DatabaseMeta databaseMeta, String schemaName, String tableName) throws ModelerException {
        return ModelerSourceUtil.generateDomain(databaseMeta, schemaName, tableName, tableName, true);
    }

    public static Domain generateDomain(DatabaseMeta databaseMeta, String schemaName, String tableName, String datasourceName) throws ModelerException {
        return ModelerSourceUtil.generateDomain(databaseMeta, schemaName, tableName, datasourceName, true);
    }

    public static Domain generateDomain(DatabaseMeta databaseMeta, String schemaName, String tableName, String datasourceName, boolean dualModelingMode) throws ModelerException {
        ModelerSourceUtil.verifyTableExistsAndMayBeQuoted(databaseMeta, schemaName, tableName);
        Domain domain = null;
        try {
            String locale = "en_US";
            generator.setLocale(locale);
            generator.setDatabaseMeta(databaseMeta);
            generator.setModelName(tableName);
            SchemaTable[] tableNames = new SchemaTable[]{new SchemaTable(schemaName, tableName)};
            generator.setTableNames(tableNames);
            domain = generator.generateDomain();
            domain.setId(tableName);
            LogicalModel businessModel = (LogicalModel)domain.getLogicalModels().get(0);
            businessModel.setProperty("AGILE_BI_GENERATED_SCHEMA", (Object)"TRUE");
            businessModel.setProperty("DUAL_MODELING_SCHEMA", (Object)("" + dualModelingMode));
            businessModel.setName(new LocalizedString(locale, tableName));
            businessModel.setDescription(new LocalizedString(locale, "This is the data model for " + datasourceName));
            LogicalTable businessTable = (LogicalTable)businessModel.getLogicalTables().get(0);
            businessTable.setName(new LocalizedString(locale, businessTable.getPhysicalTable().getName(locale)));
            LogicalModel olapModel = null;
            if (dualModelingMode) {
                olapModel = ModelerConversionUtil.duplicateModelForOlap(businessModel);
                domain.addLogicalModel(olapModel);
            }
            int rights = 31;
            String roleName = System.getProperty("AGILE_BI_MODEL_ROLE", DEFAULT_ROLE_NAME);
            ModelerSourceUtil.setRoleAccess(roleName, rights, (IConcept)businessModel);
            if (olapModel != null) {
                ModelerSourceUtil.setRoleAccess(roleName, rights, (IConcept)olapModel);
            }
        }
        catch (PentahoMetadataException e) {
            e.printStackTrace();
            logger.info(e.getLocalizedMessage());
            throw new ModelerException(e);
        }
        return domain;
    }

    public static void setRoleAccess(String role, int rights, IConcept concept) {
        SecurityOwner owner = new SecurityOwner(SecurityOwner.OwnerType.ROLE, role);
        Security security = (Security)concept.getProperty(DefaultPropertyID.SECURITY.getId());
        if (security == null) {
            security = new Security();
            concept.setProperty(DefaultPropertyID.SECURITY.getId(), (Object)security);
        }
        security.putOwnerRights(owner, rights);
    }
}

