/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.mapred.tether;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.avro.mapred.tether.TetherData;
import org.apache.avro.mapred.tether.TetherInputFormat;
import org.apache.avro.mapred.tether.TetherKeyComparator;
import org.apache.avro.mapred.tether.TetherKeySerialization;
import org.apache.avro.mapred.tether.TetherMapRunner;
import org.apache.avro.mapred.tether.TetherOutputFormat;
import org.apache.avro.mapred.tether.TetherPartitioner;
import org.apache.avro.mapred.tether.TetherReducer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class TetherJob
extends Configured {
    public static URI getExecutable(JobConf job) {
        try {
            return new URI(job.get("avro.tether.executable"));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setExecutable(JobConf job, URI executable) {
        job.set("avro.tether.executable", executable.toString());
    }

    public static RunningJob runJob(JobConf job) throws IOException {
        TetherJob.setupTetherJob(job);
        return JobClient.runJob((JobConf)job);
    }

    public static RunningJob submitJob(JobConf conf) throws IOException {
        TetherJob.setupTetherJob(conf);
        return new JobClient(conf).submitJob(conf);
    }

    private static void setupTetherJob(JobConf job) throws IOException {
        job.setMapRunnerClass(TetherMapRunner.class);
        job.setPartitionerClass(TetherPartitioner.class);
        job.setReducerClass(TetherReducer.class);
        job.setInputFormat(TetherInputFormat.class);
        job.setOutputFormat(TetherOutputFormat.class);
        job.setOutputKeyClass(TetherData.class);
        job.setOutputKeyComparatorClass(TetherKeyComparator.class);
        job.setMapOutputValueClass(NullWritable.class);
        Collection serializations = job.getStringCollection("io.serializations");
        if (!serializations.contains(TetherKeySerialization.class.getName())) {
            serializations.add(TetherKeySerialization.class.getName());
            job.setStrings("io.serializations", serializations.toArray(new String[0]));
        }
        DistributedCache.addCacheFile((URI)TetherJob.getExecutable(job), (Configuration)job);
    }
}

