/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query.legacy;

import java.util.HashSet;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.store.Extent;
import org.datanucleus.store.exceptions.NoExtentException;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.query.legacy.ClassTableExtent;
import org.datanucleus.store.rdbms.query.legacy.ClassViewExtent;
import org.datanucleus.store.rdbms.table.ClassTable;
import org.datanucleus.store.rdbms.table.ClassView;

public class ExtentHelper {
    public static Extent getExtent(RDBMSStoreManager storeMgr, Class c, boolean subclasses, ObjectManager om) {
        AbstractClassMetaData cmd = storeMgr.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        DatastoreClass t = storeMgr.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
        if (cmd.getInheritanceMetaData().getStrategy() == InheritanceStrategy.COMPLETE_TABLE) {
            HashSet subclassNames;
            HashSet<DatastoreClass> candidateTables = new HashSet<DatastoreClass>();
            if (t != null) {
                candidateTables.add(t);
            }
            if (subclasses && (subclassNames = storeMgr.getSubClassesForClass(cmd.getFullClassName(), subclasses, om.getClassLoaderResolver())) != null) {
                for (String subclassName : subclassNames) {
                    DatastoreClass tbl = storeMgr.getDatastoreClass(subclassName, om.getClassLoaderResolver());
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            return new ClassTableExtent(om, candidateTables.toArray(new DatastoreClass[candidateTables.size()]), c, subclasses, cmd);
        }
        if (t instanceof ClassView) {
            return new ClassViewExtent(om, t, c, subclasses, cmd);
        }
        if (t instanceof ClassTable) {
            return new ClassTableExtent(om, t, c, subclasses, cmd);
        }
        AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(cmd, om.getClassLoaderResolver());
        if (cmds != null && cmds.length > 0) {
            DatastoreClass[] tables = new DatastoreClass[cmds.length];
            for (int i = 0; i < cmds.length; ++i) {
                tables[i] = storeMgr.getDatastoreClass(cmds[i].getFullClassName(), om.getClassLoaderResolver());
            }
            return new ClassTableExtent(om, tables, c, subclasses, cmd);
        }
        throw new NucleusUserException("Attempt to create an Extent for class " + c.getName() + " which has MetaData, yet no table was found! This should be impossible");
    }
}

