/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql;

import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.SQLTableGroup;
import org.datanucleus.store.rdbms.sql.SQLTableNamer;

public class SQLTableAlphaNamer
implements SQLTableNamer {
    static String[] CHARS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    public String getAliasForTable(SQLStatement stmt, DatastoreContainerObject table, String groupName) {
        SQLTableGroup tableGrp = stmt.tableGroups.get(groupName);
        String groupLetter = null;
        int numTablesInGroup = 0;
        if (tableGrp == null || tableGrp.getNumberOfTables() == 0) {
            groupLetter = CHARS[stmt.tableGroups.size()];
            numTablesInGroup = 0;
        } else {
            String quote;
            SQLTable refSqlTbl = tableGrp.getTables()[0];
            String baseTableAlias = refSqlTbl.getAlias().toString();
            groupLetter = baseTableAlias.startsWith(quote = stmt.getRDBMSManager().getDatastoreAdapter().getIdentifierQuoteString()) ? baseTableAlias.substring(quote.length(), quote.length() + 1) : baseTableAlias.substring(0, 1);
            numTablesInGroup = tableGrp.getNumberOfTables();
        }
        if (stmt.parent != null) {
            return groupLetter + numTablesInGroup + "_SUB";
        }
        return groupLetter + numTablesInGroup;
    }
}

