/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.method;

import java.util.Collection;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.query.compiler.CompilationComponent;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.SQLTable;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.BooleanSubqueryExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionExpression;
import org.datanucleus.store.rdbms.sql.expression.CollectionLiteral;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.UnboundExpression;
import org.datanucleus.store.rdbms.sql.method.AbstractSQLMethod;
import org.datanucleus.store.rdbms.table.CollectionTable;
import org.datanucleus.util.NucleusLogger;

public class CollectionContainsMethod
extends AbstractSQLMethod {
    public SQLExpression getExpression(SQLExpression expr, List args) {
        AbstractMemberMetaData mmd;
        if (args == null || args.size() == 0 || args.size() > 1) {
            throw new NucleusException(LOCALISER.msg("060016", (Object)"contains", (Object)"CollectionExpression", (Object)1));
        }
        CollectionExpression collExpr = (CollectionExpression)expr;
        SQLExpression elemExpr = (SQLExpression)args.get(0);
        if (elemExpr.isParameter() && (mmd = collExpr.getJavaTypeMapping().getMemberMetaData()) != null && mmd.getCollection() != null) {
            Class elementCls = this.stmt.getQueryGenerator().getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
            this.stmt.getQueryGenerator().bindParameter(elemExpr.getParameterName(), elementCls);
        }
        if (collExpr instanceof CollectionLiteral) {
            CollectionLiteral lit = (CollectionLiteral)collExpr;
            Collection coll = (Collection)lit.getValue();
            JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
            if (coll == null || coll.isEmpty()) {
                return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, false));
            }
            SQLExpression bExpr = null;
            List<SQLExpression> elementExprs = lit.getElementExpressions();
            for (int i = 0; i < elementExprs.size(); ++i) {
                bExpr = bExpr == null ? elementExprs.get(i).eq(elemExpr) : ((BooleanExpression)bExpr).ior(elementExprs.get(i).eq(elemExpr));
            }
            bExpr.encloseInParentheses();
            return bExpr;
        }
        if (this.stmt.getQueryGenerator().getCompilationComponent() == CompilationComponent.FILTER) {
            if (this.getNeedsSubquery()) {
                return this.containsAsSubquery(collExpr, elemExpr);
            }
            return this.containsAsInnerJoin(collExpr, elemExpr);
        }
        return this.containsAsSubquery(collExpr, elemExpr);
    }

    protected boolean getNeedsSubquery() {
        Boolean hasNOT;
        boolean needsSubquery = false;
        Boolean hasOR = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.OR");
        if (hasOR != null && hasOR.booleanValue()) {
            needsSubquery = true;
        }
        if ((hasNOT = (Boolean)this.stmt.getQueryGenerator().getProperty("Filter.NOT")) != null && hasNOT.booleanValue()) {
            needsSubquery = true;
        }
        return needsSubquery;
    }

    protected SQLExpression containsAsInnerJoin(CollectionExpression collExpr, SQLExpression elemExpr) {
        Class varType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> CollectionContains binding unbound variable " + varName + " using INNER JOIN"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager());
        CollectionTable joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(mmd);
        String elemType = mmd.getCollection().getElementType();
        if (elemIsUnbound && (varType = this.stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, this.clr);
        }
        if (joinTbl != null) {
            SQLTable joinSqlTbl;
            if (elemCmd == null) {
                joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            } else {
                joinSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), joinTbl, null, joinTbl.getOwnerMapping(), null, null);
                if (!mmd.getCollection().isEmbeddedElement()) {
                    DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable elemSqlTbl = this.stmt.innerJoin(joinSqlTbl, joinTbl.getElementMapping(), (DatastoreContainerObject)elemTbl, null, elemTbl.getIdMapping(), null, null);
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                    if (elemIsUnbound) {
                        this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                    }
                } else {
                    SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, joinSqlTbl, joinTbl.getElementMapping());
                    if (elemIsUnbound) {
                        this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                    } else {
                        this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                    }
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLTable elemSqlTbl = this.stmt.innerJoin(collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping(), (DatastoreContainerObject)elemTbl, null, ownerMapping, null, null);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable varSqlTbl = this.stmt.innerJoin(elemSqlTbl, elemTbl.getIdMapping(), (DatastoreContainerObject)varTbl, null, varTbl.getIdMapping(), null, null);
                    elemIdExpr = this.exprFactory.newExpression(this.stmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                }
                this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = this.exprFactory.newExpression(this.stmt, elemSqlTbl, elemTbl.getIdMapping());
                this.stmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            }
        }
        JavaTypeMapping m = this.exprFactory.getMappingForType(Boolean.TYPE, true);
        return this.exprFactory.newLiteral(this.stmt, m, true).eq(this.exprFactory.newLiteral(this.stmt, m, true));
    }

    protected SQLExpression containsAsSubquery(CollectionExpression collExpr, SQLExpression elemExpr) {
        Class varType;
        boolean elemIsUnbound = elemExpr instanceof UnboundExpression;
        String varName = null;
        if (elemIsUnbound) {
            varName = ((UnboundExpression)elemExpr).getVariableName();
            NucleusLogger.QUERY.debug((Object)(">> CollectionContains binding unbound variable " + varName + " using SUBQUERY"));
        }
        RDBMSStoreManager storeMgr = this.stmt.getRDBMSManager();
        AbstractMemberMetaData mmd = collExpr.getJavaTypeMapping().getMemberMetaData();
        AbstractClassMetaData elemCmd = mmd.getCollection().getElementClassMetaData(this.clr, storeMgr.getMetaDataManager());
        CollectionTable joinTbl = (CollectionTable)storeMgr.getDatastoreContainerObject(mmd);
        String elemType = mmd.getCollection().getElementType();
        if (elemIsUnbound && (varType = this.stmt.getQueryGenerator().getTypeOfVariable(varName)) != null) {
            elemType = varType.getName();
            elemCmd = storeMgr.getMetaDataManager().getMetaDataForClass(elemType, this.clr);
        }
        SQLStatement subStmt = null;
        if (joinTbl != null) {
            if (elemCmd == null) {
                subStmt = new SQLStatement(this.stmt, storeMgr, joinTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), joinTbl.getElementMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, null, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            } else {
                DatastoreClass elemTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)elemTbl, null, null);
                subStmt.setClassLoaderResolver(this.clr);
                JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
                subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
                SQLTable joinSqlTbl = subStmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), joinTbl, null, joinTbl.getElementMapping(), null, null);
                JavaTypeMapping ownerMapping = joinTbl.getOwnerMapping();
                SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, joinSqlTbl, ownerMapping);
                SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
                subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                if (elemIsUnbound) {
                    this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
                } else {
                    subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
                }
            }
        } else {
            DatastoreClass elemTbl = storeMgr.getDatastoreClass(mmd.getCollection().getElementType(), this.clr);
            subStmt = new SQLStatement(this.stmt, storeMgr, (DatastoreContainerObject)elemTbl, null, null);
            subStmt.setClassLoaderResolver(this.clr);
            JavaTypeMapping oneMapping = storeMgr.getMappingManager().getMapping(Integer.class);
            subStmt.select(this.exprFactory.newLiteral(subStmt, oneMapping, 1), null);
            JavaTypeMapping ownerMapping = null;
            ownerMapping = mmd.getMappedBy() != null ? elemTbl.getMemberMapping(mmd.getRelatedMemberMetaData(this.clr)[0]) : elemTbl.getExternalMapping(mmd, 5);
            SQLExpression ownerExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), ownerMapping);
            SQLExpression ownerIdExpr = this.exprFactory.newExpression(this.stmt, collExpr.getSQLTable(), collExpr.getSQLTable().getTable().getIdMapping());
            subStmt.whereAnd(ownerExpr.eq(ownerIdExpr), true);
            if (elemIsUnbound) {
                SQLExpression elemIdExpr = null;
                if (!elemType.equals(mmd.getCollection().getElementType())) {
                    DatastoreClass varTbl = storeMgr.getDatastoreClass(elemType, this.clr);
                    SQLTable varSqlTbl = this.stmt.innerJoin(subStmt.getPrimaryTable(), elemTbl.getIdMapping(), (DatastoreContainerObject)varTbl, null, varTbl.getIdMapping(), null, null);
                    elemIdExpr = this.exprFactory.newExpression(this.stmt, varSqlTbl, varTbl.getIdMapping());
                } else {
                    elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                }
                this.stmt.getQueryGenerator().bindVariable(varName, elemCmd, elemIdExpr.getSQLTable(), elemIdExpr.getJavaTypeMapping());
            } else {
                SQLExpression elemIdExpr = this.exprFactory.newExpression(subStmt, subStmt.getPrimaryTable(), elemTbl.getIdMapping());
                subStmt.whereAnd(elemIdExpr.eq(elemExpr), true);
            }
        }
        return new BooleanSubqueryExpression(this.stmt, "EXISTS", subStmt);
    }
}

