/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.io.IOException;
import java.net.URI;
import java.util.BitSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;

public final class FileUtils {
    static BitSet charToEscape;

    public static Path makeQualified(Path path, Configuration conf) throws IOException {
        if (!path.isAbsolute()) {
            return path.makeQualified(FileSystem.get((Configuration)conf));
        }
        URI fsUri = FileSystem.getDefaultUri((Configuration)conf);
        URI pathUri = path.toUri();
        String scheme = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme == null) {
            scheme = fsUri.getScheme();
            authority = fsUri.getAuthority();
            if (authority == null) {
                authority = "";
            }
        } else if (authority == null) {
            authority = scheme.equals(fsUri.getScheme()) && fsUri.getAuthority() != null ? fsUri.getAuthority() : "";
        }
        return new Path(scheme, authority, pathUri.getPath());
    }

    private FileUtils() {
    }

    public static String makePartName(List<String> partCols, List<String> vals) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partCols.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(FileUtils.escapePathName(partCols.get(i).toLowerCase()));
            name.append('=');
            name.append(FileUtils.escapePathName(vals.get(i)));
        }
        return name.toString();
    }

    static boolean needsEscaping(char c) {
        return c >= '\u0000' && c < charToEscape.size() && charToEscape.get(c);
    }

    public static String escapePathName(String path) {
        if (path == null || path.length() == 0) {
            return "__HIVE_DEFAULT_PARTITION__";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (FileUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.valueOf(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, List<FileStatus> results) throws IOException {
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                FileUtils.listStatusRecursively(fs, stat, results);
            }
        } else {
            results.add(fileStatus);
        }
    }

    public static void tar(String parentDir, String[] inputFiles, String outputFile) throws IOException {
        StringBuffer tarCommand = new StringBuffer();
        tarCommand.append("cd " + parentDir + " ; ");
        tarCommand.append(" tar -zcvf ");
        tarCommand.append(" " + outputFile);
        for (int i = 0; i < inputFiles.length; ++i) {
            tarCommand.append(" " + inputFiles[i]);
        }
        String[] shellCmd = new String[]{"bash", "-c", tarCommand.toString()};
        Shell.ShellCommandExecutor shexec = new Shell.ShellCommandExecutor(shellCmd);
        shexec.execute();
        int exitcode = shexec.getExitCode();
        if (exitcode != 0) {
            throw new IOException("Error tarring file " + outputFile + ". Tar process exited with exit code " + exitcode);
        }
    }

    static {
        char[] clist;
        charToEscape = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            charToEscape.set(c);
        }
        for (char c : clist = new char[]{'\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', ']'}) {
            charToEscape.set(c);
        }
    }
}

