/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Task;

public class DriverContext {
    Queue<Task<? extends Serializable>> runnable = new LinkedList<Task<? extends Serializable>>();
    int curJobNo;
    Context ctx;

    public DriverContext() {
        this.runnable = null;
        this.ctx = null;
    }

    public DriverContext(Queue<Task<? extends Serializable>> runnable, Context ctx) {
        this.runnable = runnable;
        this.ctx = ctx;
    }

    public Queue<Task<? extends Serializable>> getRunnable() {
        return this.runnable;
    }

    public static boolean isLaunchable(Task<? extends Serializable> tsk) {
        return !tsk.getQueued() && !tsk.getInitialized() && tsk.isRunnable();
    }

    public void addToRunnable(Task<? extends Serializable> tsk) {
        this.runnable.add(tsk);
        tsk.setQueued();
    }

    public int getCurJobNo() {
        return this.curJobNo;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public void incCurJobNo(int amount) {
        this.curJobNo += amount;
    }
}

