/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.ExecMapperContext;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.JobCloseFeedBack;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public abstract class Operator<T extends Serializable>
implements Serializable,
Node {
    private static final long serialVersionUID = 1L;
    protected List<Operator<? extends Serializable>> childOperators;
    protected List<Operator<? extends Serializable>> parentOperators;
    protected String operatorId;
    protected ArrayList<String> counterNames;
    protected HashMap<String, ProgressCounter> counterNameToEnum;
    private transient ExecMapperContext execContext;
    private static int seqId;
    protected transient State state = State.UNINIT;
    static transient boolean fatalError;
    protected T conf;
    protected boolean done;
    private transient RowSchema rowSchema;
    protected transient HashMap<Enum<?>, LongWritable> statsMap = new HashMap();
    protected transient OutputCollector out;
    protected transient Log LOG = LogFactory.getLog((String)this.getClass().getName());
    protected transient boolean isLogInfoEnabled = this.LOG.isInfoEnabled();
    protected transient String alias;
    protected transient Reporter reporter;
    protected transient String id;
    protected transient ObjectInspector[] inputObjInspectors = new ObjectInspector[1];
    protected transient ObjectInspector outputObjInspector;
    protected transient Map<String, ExprNodeDesc> colExprMap;
    protected transient Operator<? extends Serializable>[] childOperatorsArray = null;
    protected transient int[] childOperatorsTag;
    private transient long cntr = 0L;
    private transient long nextCntr = 1L;
    private static int totalNumCntrs;
    protected transient HashMap<String, Long> counters;
    private static int lastEnumUsed;
    protected transient long inputRows = 0L;
    protected transient long outputRows = 0L;
    protected transient long beginTime = 0L;
    protected transient long totalTime = 0L;
    protected transient Object groupKeyObject;
    protected static String numInputRowsCntr;
    protected static String numOutputRowsCntr;
    protected static String timeTakenCntr;
    protected static String fatalErrorCntr;

    public Operator() {
        this.id = String.valueOf(seqId++);
    }

    public static void resetId() {
        seqId = 0;
    }

    public Operator(Reporter reporter) {
        this.reporter = reporter;
        this.id = String.valueOf(seqId++);
    }

    public void setChildOperators(List<Operator<? extends Serializable>> childOperators) {
        this.childOperators = childOperators;
    }

    public List<Operator<? extends Serializable>> getChildOperators() {
        return this.childOperators;
    }

    public ArrayList<Node> getChildren() {
        if (this.getChildOperators() == null) {
            return null;
        }
        ArrayList<Node> ret_vec = new ArrayList<Node>();
        for (Operator<Serializable> op : this.getChildOperators()) {
            ret_vec.add(op);
        }
        return ret_vec;
    }

    public void setParentOperators(List<Operator<? extends Serializable>> parentOperators) {
        this.parentOperators = parentOperators;
    }

    public List<Operator<? extends Serializable>> getParentOperators() {
        return this.parentOperators;
    }

    public void setConf(T conf) {
        this.conf = conf;
    }

    @Explain
    public T getConf() {
        return this.conf;
    }

    public boolean getDone() {
        return this.done || fatalError;
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public void setSchema(RowSchema rowSchema) {
        this.rowSchema = rowSchema;
    }

    public RowSchema getSchema() {
        return this.rowSchema;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getIdentifier() {
        return this.id;
    }

    public void setReporter(Reporter rep) {
        this.reporter = rep;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.setReporter(rep);
        }
    }

    public void setOutputCollector(OutputCollector out) {
        this.out = out;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.setOutputCollector(out);
        }
    }

    public void setAlias(String alias) {
        this.alias = alias;
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.setAlias(alias);
        }
    }

    public Map<Enum<?>, Long> getStats() {
        HashMap ret = new HashMap();
        for (Enum<?> one : this.statsMap.keySet()) {
            ret.put(one, this.statsMap.get(one).get());
        }
        return ret;
    }

    protected boolean areAllParentsInitialized() {
        if (this.parentOperators == null) {
            return true;
        }
        for (Operator<? extends Serializable> parent : this.parentOperators) {
            if (parent == null || parent.state == State.INIT) continue;
            return false;
        }
        return true;
    }

    public void initialize(Configuration hconf, ObjectInspector[] inputOIs) throws HiveException {
        if (this.state == State.INIT) {
            return;
        }
        this.out = null;
        if (!this.areAllParentsInitialized()) {
            return;
        }
        this.LOG.info((Object)("Initializing Self " + this.id + " " + this.getName()));
        if (inputOIs != null) {
            this.inputObjInspectors = inputOIs;
        }
        if (this.childOperators != null) {
            int i;
            this.childOperatorsArray = new Operator[this.childOperators.size()];
            for (i = 0; i < this.childOperatorsArray.length; ++i) {
                this.childOperatorsArray[i] = this.childOperators.get(i);
            }
            this.childOperatorsTag = new int[this.childOperatorsArray.length];
            for (i = 0; i < this.childOperatorsArray.length; ++i) {
                List<Operator<Serializable>> parentOperators = this.childOperatorsArray[i].getParentOperators();
                if (parentOperators == null) {
                    throw new HiveException("Hive internal error: parent is null in " + this.childOperatorsArray[i].getClass() + "!");
                }
                this.childOperatorsTag[i] = parentOperators.indexOf(this);
                if (this.childOperatorsTag[i] != -1) continue;
                throw new HiveException("Hive internal error: cannot find parent in the child operator!");
            }
        }
        if (this.inputObjInspectors.length == 0) {
            throw new HiveException("Internal Error during operator initialization.");
        }
        this.outputObjInspector = this.inputObjInspectors[0];
        this.passExecContext(this.execContext);
        this.initializeOp(hconf);
        this.LOG.info((Object)("Initialization Done " + this.id + " " + this.getName()));
    }

    public void initializeLocalWork(Configuration hconf) throws HiveException {
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends Serializable> childOp = this.childOperators.get(i);
                childOp.initializeLocalWork(hconf);
            }
        }
    }

    protected void initializeOp(Configuration hconf) throws HiveException {
        this.initializeChildren(hconf);
    }

    protected void initializeChildren(Configuration hconf) throws HiveException {
        this.state = State.INIT;
        this.LOG.info((Object)("Operator " + this.id + " " + this.getName() + " initialized"));
        if (this.childOperators == null) {
            return;
        }
        this.LOG.info((Object)("Initializing children of " + this.id + " " + this.getName()));
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            super.initialize(hconf, this.outputObjInspector, this.childOperatorsTag[i]);
            if (this.reporter == null) continue;
            this.childOperatorsArray[i].setReporter(this.reporter);
        }
    }

    public void passExecContext(ExecMapperContext execContext) {
        this.setExecContext(execContext);
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                this.childOperators.get(i).passExecContext(execContext);
            }
        }
    }

    private void initialize(Configuration hconf, ObjectInspector inputOI, int parentId) throws HiveException {
        this.LOG.info((Object)("Initializing child " + this.id + " " + this.getName()));
        if (parentId >= this.inputObjInspectors.length) {
            int newLength;
            for (newLength = this.inputObjInspectors.length * 2; parentId >= newLength; newLength *= 2) {
            }
            this.inputObjInspectors = Arrays.copyOf(this.inputObjInspectors, newLength);
        }
        this.inputObjInspectors[parentId] = inputOI;
        this.initialize(hconf, null);
    }

    public ObjectInspector[] getInputObjInspectors() {
        return this.inputObjInspectors;
    }

    public void setInputObjInspectors(ObjectInspector[] inputObjInspectors) {
        this.inputObjInspectors = inputObjInspectors;
    }

    public abstract void processOp(Object var1, int var2) throws HiveException;

    public void process(Object row, int tag) throws HiveException {
        if (fatalError) {
            return;
        }
        this.preProcessCounter();
        this.processOp(row, tag);
        this.postProcessCounter();
    }

    public void startGroup() throws HiveException {
        this.LOG.debug((Object)"Starting group");
        if (this.childOperators == null) {
            return;
        }
        if (fatalError) {
            return;
        }
        this.LOG.debug((Object)"Starting group for children:");
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.startGroup();
        }
        this.LOG.debug((Object)"Start group Done");
    }

    public void endGroup() throws HiveException {
        this.LOG.debug((Object)"Ending group");
        if (this.childOperators == null) {
            return;
        }
        if (fatalError) {
            return;
        }
        this.LOG.debug((Object)"Ending group for children:");
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.endGroup();
        }
        this.LOG.debug((Object)"End group Done");
    }

    protected boolean allInitializedParentsAreClosed() {
        if (this.parentOperators != null) {
            for (Operator<? extends Serializable> parent : this.parentOperators) {
                if (parent == null || parent.state == State.CLOSE || parent.state == State.UNINIT) continue;
                return false;
            }
        }
        return true;
    }

    public void close(boolean abort) throws HiveException {
        if (this.state == State.CLOSE) {
            return;
        }
        if (!this.allInitializedParentsAreClosed()) {
            return;
        }
        this.state = State.CLOSE;
        this.LOG.info((Object)(this.id + " finished. closing... "));
        if (this.counterNameToEnum != null) {
            this.incrCounter(numInputRowsCntr, this.inputRows);
            this.incrCounter(numOutputRowsCntr, this.outputRows);
            this.incrCounter(timeTakenCntr, this.totalTime);
        }
        this.LOG.info((Object)(this.id + " forwarded " + this.cntr + " rows"));
        this.closeOp(abort);
        try {
            this.logStats();
            if (this.childOperators == null) {
                return;
            }
            for (Operator<? extends Serializable> op : this.childOperators) {
                op.close(abort);
            }
            this.LOG.info((Object)(this.id + " Close done"));
        }
        catch (HiveException e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void closeOp(boolean abort) throws HiveException {
    }

    public void jobClose(Configuration conf, boolean success, JobCloseFeedBack feedBack) throws HiveException {
        if (this.childOperators == null) {
            return;
        }
        for (Operator<? extends Serializable> op : this.childOperators) {
            op.jobClose(conf, success, feedBack);
        }
    }

    public void replaceChild(Operator<? extends Serializable> child, Operator<? extends Serializable> newChild) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        this.childOperators.set(childIndex, newChild);
    }

    public void removeChild(Operator<? extends Serializable> child) {
        int childIndex = this.childOperators.indexOf(child);
        assert (childIndex != -1);
        if (this.childOperators.size() == 1) {
            this.childOperators = null;
        } else {
            this.childOperators.remove(childIndex);
        }
        int parentIndex = child.getParentOperators().indexOf(this);
        assert (parentIndex != -1);
        if (child.getParentOperators().size() == 1) {
            child.setParentOperators(null);
        } else {
            child.getParentOperators().remove(parentIndex);
        }
    }

    public void removeChildAndAdoptItsChildren(Operator<? extends Serializable> child) throws SemanticException {
        int childIndex = this.childOperators.indexOf(child);
        if (childIndex == -1) {
            throw new SemanticException("Exception when trying to remove partition predicates: fail to find child from parent");
        }
        this.childOperators.remove(childIndex);
        if (child.getChildOperators() != null && child.getChildOperators().size() > 0) {
            this.childOperators.addAll(childIndex, child.getChildOperators());
        }
        for (Operator<Serializable> gc : child.getChildOperators()) {
            List<Operator<Serializable>> parents = gc.getParentOperators();
            int index = parents.indexOf(child);
            if (index == -1) {
                throw new SemanticException("Exception when trying to remove partition predicates: fail to find parent from child");
            }
            parents.set(index, this);
        }
    }

    public void replaceParent(Operator<? extends Serializable> parent, Operator<? extends Serializable> newParent) {
        int parentIndex = this.parentOperators.indexOf(parent);
        assert (parentIndex != -1);
        this.parentOperators.set(parentIndex, newParent);
    }

    private long getNextCntr(long cntr) {
        if (cntr >= 1000000L) {
            return cntr + 1000000L;
        }
        return 10L * cntr;
    }

    protected void forward(Object row, ObjectInspector rowInspector) throws HiveException {
        if (++this.outputRows % 1000L == 0L && this.counterNameToEnum != null) {
            this.incrCounter(numOutputRowsCntr, this.outputRows);
            this.outputRows = 0L;
        }
        if (this.isLogInfoEnabled) {
            ++this.cntr;
            if (this.cntr == this.nextCntr) {
                this.LOG.info((Object)(this.id + " forwarding " + this.cntr + " rows"));
                this.nextCntr = this.getNextCntr(this.cntr);
            }
        }
        if (this.childOperatorsArray == null && this.childOperators != null) {
            throw new HiveException("Internal Hive error during operator initialization.");
        }
        if (this.childOperatorsArray == null || this.getDone()) {
            return;
        }
        int childrenDone = 0;
        for (int i = 0; i < this.childOperatorsArray.length; ++i) {
            Operator<? extends Serializable> o = this.childOperatorsArray[i];
            if (o.getDone()) {
                ++childrenDone;
                continue;
            }
            o.process(row, this.childOperatorsTag[i]);
        }
        if (childrenDone == this.childOperatorsArray.length) {
            this.setDone(true);
        }
    }

    public void resetStats() {
        for (Enum<?> e : this.statsMap.keySet()) {
            this.statsMap.get(e).set(0L);
        }
    }

    public void reset() {
        this.state = State.INIT;
        if (this.childOperators != null) {
            for (Operator<? extends Serializable> o : this.childOperators) {
                o.reset();
            }
        }
    }

    public void preorderMap(OperatorFunc opFunc) {
        opFunc.func(this);
        if (this.childOperators != null) {
            for (Operator<? extends Serializable> o : this.childOperators) {
                o.preorderMap(opFunc);
            }
        }
    }

    public void logStats() {
        for (Enum<?> e : this.statsMap.keySet()) {
            this.LOG.info((Object)(e.toString() + ":" + this.statsMap.get(e).toString()));
        }
    }

    @Override
    public String getName() {
        return new String("OP");
    }

    public Map<String, ExprNodeDesc> getColumnExprMap() {
        return this.colExprMap;
    }

    public void setColumnExprMap(Map<String, ExprNodeDesc> colExprMap) {
        this.colExprMap = colExprMap;
    }

    private String getLevelString(int level) {
        if (level == 0) {
            return "\n";
        }
        StringBuilder s = new StringBuilder();
        s.append("\n");
        while (level > 0) {
            s.append("  ");
            --level;
        }
        return s.toString();
    }

    public String dump(int level) {
        return this.dump(level, new HashSet<Integer>());
    }

    public String dump(int level, HashSet<Integer> seenOpts) {
        if (seenOpts.contains(new Integer(this.id))) {
            return null;
        }
        seenOpts.add(new Integer(this.id));
        StringBuilder s = new StringBuilder();
        String ls = this.getLevelString(level);
        s.append(ls);
        s.append("<" + this.getName() + ">");
        s.append("Id =" + this.id);
        if (this.childOperators != null) {
            s.append(ls);
            s.append("  <Children>");
            for (Operator<? extends Serializable> o : this.childOperators) {
                s.append(o.dump(level + 2, seenOpts));
            }
            s.append(ls);
            s.append("  <\\Children>");
        }
        if (this.parentOperators != null) {
            s.append(ls);
            s.append("  <Parent>");
            for (Operator<? extends Serializable> o : this.parentOperators) {
                s.append("Id = " + o.id + " ");
                s.append(o.dump(level, seenOpts));
            }
            s.append("<\\Parent>");
        }
        s.append(ls);
        s.append("<\\" + this.getName() + ">");
        return s.toString();
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator[] evals, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[evals.length];
        for (int i = 0; i < evals.length; ++i) {
            result[i] = evals[i].initialize(rowInspector);
        }
        return result;
    }

    protected static ObjectInspector[] initEvaluators(ExprNodeEvaluator[] evals, int start, int length, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] result = new ObjectInspector[length];
        for (int i = 0; i < length; ++i) {
            result[i] = evals[start + i].initialize(rowInspector);
        }
        return result;
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<String> outputColName, ObjectInspector rowInspector) throws HiveException {
        ObjectInspector[] fieldObjectInspectors = Operator.initEvaluators(evals, rowInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColName, Arrays.asList(fieldObjectInspectors));
    }

    private void preProcessCounter() {
        ++this.inputRows;
        if (this.counterNameToEnum != null) {
            if (this.inputRows % 1000L == 0L) {
                this.incrCounter(numInputRowsCntr, this.inputRows);
                this.incrCounter(timeTakenCntr, this.totalTime);
                this.inputRows = 0L;
                this.totalTime = 0L;
            }
            this.beginTime = System.currentTimeMillis();
        }
    }

    private void postProcessCounter() {
        if (this.counterNameToEnum != null) {
            this.totalTime += System.currentTimeMillis() - this.beginTime;
        }
    }

    protected void incrCounter(String name, long amount) {
        String counterName = "CNTR_NAME_" + this.getOperatorId() + "_" + name;
        ProgressCounter pc = this.counterNameToEnum.get(counterName);
        if (pc == null) {
            this.LOG.warn((Object)("Using too many counters. Increase the total number of counters for " + counterName));
        } else if (this.reporter != null) {
            this.reporter.incrCounter((Enum)pc, amount);
        }
    }

    public ArrayList<String> getCounterNames() {
        return this.counterNames;
    }

    public void setCounterNames(ArrayList<String> counterNames) {
        this.counterNames = counterNames;
    }

    public String getOperatorId() {
        return this.operatorId;
    }

    public void initOperatorId() {
        this.setOperatorId(this.getName() + "_" + this.id);
    }

    public void setOperatorId(String operatorId) {
        this.operatorId = operatorId;
    }

    public HashMap<String, Long> getCounters() {
        return this.counters;
    }

    public void updateCounters(Counters ctrs) {
        if (this.counters == null) {
            this.counters = new HashMap();
        }
        if (this.counterNameToEnum == null) {
            return;
        }
        for (Map.Entry<String, ProgressCounter> counter : this.counterNameToEnum.entrySet()) {
            this.counters.put(counter.getKey(), ctrs.getCounter((Enum)counter.getValue()));
        }
        if (this.getChildren() != null) {
            for (Node op : this.getChildren()) {
                ((Operator)op).updateCounters(ctrs);
            }
        }
    }

    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        if (this.counterNameToEnum == null) {
            return false;
        }
        String counterName = "CNTR_NAME_" + this.getOperatorId() + "_" + fatalErrorCntr;
        ProgressCounter pc = this.counterNameToEnum.get(counterName);
        if (pc == null) {
            this.LOG.warn((Object)("Using too many counters. Increase the total number of counters for " + counterName));
        } else {
            long value = ctrs.getCounter((Enum)pc);
            this.fatalErrorMessage(errMsg, value);
            if (value != 0L) {
                return true;
            }
        }
        if (this.getChildren() != null) {
            for (Node op : this.getChildren()) {
                if (!((Operator)op).checkFatalErrors(ctrs, errMsg)) continue;
                return true;
            }
        }
        return false;
    }

    protected void fatalErrorMessage(StringBuilder errMsg, long counterValue) {
    }

    public static void resetLastEnumUsed() {
        lastEnumUsed = 0;
    }

    public void assignCounterNameToEnum() {
        if (this.counterNameToEnum != null) {
            return;
        }
        this.counterNameToEnum = new HashMap();
        for (String counterName : this.getCounterNames()) {
            if (++lastEnumUsed > totalNumCntrs) {
                this.LOG.warn((Object)"Using too many counters. Increase the total number of counters");
                return;
            }
            String enumName = "C" + lastEnumUsed;
            ProgressCounter ctr = ProgressCounter.valueOf(enumName);
            this.counterNameToEnum.put(counterName, ctr);
        }
    }

    public void initializeCounters() {
        this.initOperatorId();
        this.counterNames = new ArrayList();
        this.counterNames.add("CNTR_NAME_" + this.getOperatorId() + "_" + numInputRowsCntr);
        this.counterNames.add("CNTR_NAME_" + this.getOperatorId() + "_" + numOutputRowsCntr);
        this.counterNames.add("CNTR_NAME_" + this.getOperatorId() + "_" + timeTakenCntr);
        this.counterNames.add("CNTR_NAME_" + this.getOperatorId() + "_" + fatalErrorCntr);
        List<String> newCntrs = this.getAdditionalCounters();
        if (newCntrs != null) {
            this.counterNames.addAll(newCntrs);
        }
    }

    private List<String> getAdditionalCounters() {
        return null;
    }

    public HashMap<String, ProgressCounter> getCounterNameToEnum() {
        return this.counterNameToEnum;
    }

    public void setCounterNameToEnum(HashMap<String, ProgressCounter> counterNameToEnum) {
        this.counterNameToEnum = counterNameToEnum;
    }

    public abstract OperatorType getType();

    public void setGroupKeyObject(Object keyObject) {
        this.groupKeyObject = keyObject;
    }

    public Object getGroupKeyObject() {
        return this.groupKeyObject;
    }

    public void augmentPlan() {
    }

    public ExecMapperContext getExecContext() {
        return this.execContext;
    }

    public void setExecContext(ExecMapperContext execContext) {
        this.execContext = execContext;
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends Serializable> op = this.childOperators.get(i);
                op.setExecContext(execContext);
            }
        }
    }

    public void cleanUpInputFileChanged() throws HiveException {
        this.cleanUpInputFileChangedOp();
        if (this.childOperators != null) {
            for (int i = 0; i < this.childOperators.size(); ++i) {
                Operator<? extends Serializable> op = this.childOperators.get(i);
                op.cleanUpInputFileChanged();
            }
        }
    }

    public void cleanUpInputFileChangedOp() throws HiveException {
    }

    static {
        fatalError = false;
        seqId = 0;
        totalNumCntrs = 400;
        numInputRowsCntr = "NUM_INPUT_ROWS";
        numOutputRowsCntr = "NUM_OUTPUT_ROWS";
        timeTakenCntr = "TIME_TAKEN";
        fatalErrorCntr = "FATAL_ERROR";
    }

    public static enum ProgressCounter {
        CREATED_FILES,
        C1,
        C2,
        C3,
        C4,
        C5,
        C6,
        C7,
        C8,
        C9,
        C10,
        C11,
        C12,
        C13,
        C14,
        C15,
        C16,
        C17,
        C18,
        C19,
        C20,
        C21,
        C22,
        C23,
        C24,
        C25,
        C26,
        C27,
        C28,
        C29,
        C30,
        C31,
        C32,
        C33,
        C34,
        C35,
        C36,
        C37,
        C38,
        C39,
        C40,
        C41,
        C42,
        C43,
        C44,
        C45,
        C46,
        C47,
        C48,
        C49,
        C50,
        C51,
        C52,
        C53,
        C54,
        C55,
        C56,
        C57,
        C58,
        C59,
        C60,
        C61,
        C62,
        C63,
        C64,
        C65,
        C66,
        C67,
        C68,
        C69,
        C70,
        C71,
        C72,
        C73,
        C74,
        C75,
        C76,
        C77,
        C78,
        C79,
        C80,
        C81,
        C82,
        C83,
        C84,
        C85,
        C86,
        C87,
        C88,
        C89,
        C90,
        C91,
        C92,
        C93,
        C94,
        C95,
        C96,
        C97,
        C98,
        C99,
        C100,
        C101,
        C102,
        C103,
        C104,
        C105,
        C106,
        C107,
        C108,
        C109,
        C110,
        C111,
        C112,
        C113,
        C114,
        C115,
        C116,
        C117,
        C118,
        C119,
        C120,
        C121,
        C122,
        C123,
        C124,
        C125,
        C126,
        C127,
        C128,
        C129,
        C130,
        C131,
        C132,
        C133,
        C134,
        C135,
        C136,
        C137,
        C138,
        C139,
        C140,
        C141,
        C142,
        C143,
        C144,
        C145,
        C146,
        C147,
        C148,
        C149,
        C150,
        C151,
        C152,
        C153,
        C154,
        C155,
        C156,
        C157,
        C158,
        C159,
        C160,
        C161,
        C162,
        C163,
        C164,
        C165,
        C166,
        C167,
        C168,
        C169,
        C170,
        C171,
        C172,
        C173,
        C174,
        C175,
        C176,
        C177,
        C178,
        C179,
        C180,
        C181,
        C182,
        C183,
        C184,
        C185,
        C186,
        C187,
        C188,
        C189,
        C190,
        C191,
        C192,
        C193,
        C194,
        C195,
        C196,
        C197,
        C198,
        C199,
        C200,
        C201,
        C202,
        C203,
        C204,
        C205,
        C206,
        C207,
        C208,
        C209,
        C210,
        C211,
        C212,
        C213,
        C214,
        C215,
        C216,
        C217,
        C218,
        C219,
        C220,
        C221,
        C222,
        C223,
        C224,
        C225,
        C226,
        C227,
        C228,
        C229,
        C230,
        C231,
        C232,
        C233,
        C234,
        C235,
        C236,
        C237,
        C238,
        C239,
        C240,
        C241,
        C242,
        C243,
        C244,
        C245,
        C246,
        C247,
        C248,
        C249,
        C250,
        C251,
        C252,
        C253,
        C254,
        C255,
        C256,
        C257,
        C258,
        C259,
        C260,
        C261,
        C262,
        C263,
        C264,
        C265,
        C266,
        C267,
        C268,
        C269,
        C270,
        C271,
        C272,
        C273,
        C274,
        C275,
        C276,
        C277,
        C278,
        C279,
        C280,
        C281,
        C282,
        C283,
        C284,
        C285,
        C286,
        C287,
        C288,
        C289,
        C290,
        C291,
        C292,
        C293,
        C294,
        C295,
        C296,
        C297,
        C298,
        C299,
        C300,
        C301,
        C302,
        C303,
        C304,
        C305,
        C306,
        C307,
        C308,
        C309,
        C310,
        C311,
        C312,
        C313,
        C314,
        C315,
        C316,
        C317,
        C318,
        C319,
        C320,
        C321,
        C322,
        C323,
        C324,
        C325,
        C326,
        C327,
        C328,
        C329,
        C330,
        C331,
        C332,
        C333,
        C334,
        C335,
        C336,
        C337,
        C338,
        C339,
        C340,
        C341,
        C342,
        C343,
        C344,
        C345,
        C346,
        C347,
        C348,
        C349,
        C350,
        C351,
        C352,
        C353,
        C354,
        C355,
        C356,
        C357,
        C358,
        C359,
        C360,
        C361,
        C362,
        C363,
        C364,
        C365,
        C366,
        C367,
        C368,
        C369,
        C370,
        C371,
        C372,
        C373,
        C374,
        C375,
        C376,
        C377,
        C378,
        C379,
        C380,
        C381,
        C382,
        C383,
        C384,
        C385,
        C386,
        C387,
        C388,
        C389,
        C390,
        C391,
        C392,
        C393,
        C394,
        C395,
        C396,
        C397,
        C398,
        C399,
        C400;

    }

    public static interface OperatorFunc {
        public void func(Operator<? extends Serializable> var1);
    }

    public static enum State {
        UNINIT,
        INIT,
        CLOSE;

    }
}

