/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.ExecMapper;
import org.apache.hadoop.hive.ql.io.HiveContextAwareRecordReader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.RecordReader;

public class HiveRecordReader<K extends WritableComparable, V extends Writable>
extends HiveContextAwareRecordReader<K, V> {
    private final RecordReader recordReader;

    public HiveRecordReader(RecordReader recordReader) throws IOException {
        this.recordReader = recordReader;
    }

    @Override
    public void doClose() throws IOException {
        this.recordReader.close();
    }

    public K createKey() {
        return (K)((WritableComparable)this.recordReader.createKey());
    }

    public V createValue() {
        return (V)((Writable)this.recordReader.createValue());
    }

    public long getPos() throws IOException {
        return this.recordReader.getPos();
    }

    public float getProgress() throws IOException {
        return this.recordReader.getProgress();
    }

    @Override
    public boolean doNext(K key, V value) throws IOException {
        if (ExecMapper.getDone()) {
            return false;
        }
        return this.recordReader.next(key, value);
    }
}

