/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.ReworkMapredInputFormat;
import org.apache.hadoop.hive.ql.io.SymbolicInputFormat;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;

public class SymlinkTextInputFormat
extends SymbolicInputFormat
implements InputFormat<LongWritable, Text>,
JobConfigurable,
ContentSummaryInputFormat,
ReworkMapredInputFormat {
    public RecordReader<LongWritable, Text> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        FileSplit targetSplit = ((SymlinkTextInputSplit)split).getTargetSplit();
        TextInputFormat inputFormat = new TextInputFormat();
        inputFormat.configure(job);
        return inputFormat.getRecordReader((InputSplit)targetSplit, job, reporter);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Path[] symlinksDirs = FileInputFormat.getInputPaths((JobConf)job);
        if (symlinksDirs.length == 0) {
            throw new IOException("No input paths specified in job.");
        }
        ArrayList<Path> targetPaths = new ArrayList<Path>();
        ArrayList<Path> symlinkPaths = new ArrayList<Path>();
        try {
            SymlinkTextInputFormat.getTargetPathsFromSymlinksDirs((Configuration)job, symlinksDirs, targetPaths, symlinkPaths);
        }
        catch (Exception e) {
            throw new IOException("Error parsing symlinks from specified job input path.", e);
        }
        if (targetPaths.size() == 0) {
            return new InputSplit[0];
        }
        TextInputFormat inputFormat = new TextInputFormat();
        JobConf newjob = new JobConf((Configuration)job);
        newjob.setInputFormat(TextInputFormat.class);
        inputFormat.configure(newjob);
        ArrayList<SymlinkTextInputSplit> result = new ArrayList<SymlinkTextInputSplit>();
        int numPaths = targetPaths.size();
        int numSubSplits = (numSplits + numPaths - 1) / numPaths;
        for (int i = 0; i < numPaths; ++i) {
            InputSplit[] iss;
            Path targetPath = (Path)targetPaths.get(i);
            Path symlinkPath = (Path)symlinkPaths.get(i);
            FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{targetPath});
            for (InputSplit is : iss = inputFormat.getSplits(newjob, numSubSplits)) {
                result.add(new SymlinkTextInputSplit(symlinkPath, (FileSplit)is));
            }
        }
        return result.toArray(new InputSplit[result.size()]);
    }

    public void configure(JobConf job) {
    }

    private static void getTargetPathsFromSymlinksDirs(Configuration conf, Path[] symlinksDirs, List<Path> targetPaths, List<Path> symlinkPaths) throws IOException {
        for (Path symlinkDir : symlinksDirs) {
            FileStatus[] symlinks;
            FileSystem fileSystem = symlinkDir.getFileSystem(conf);
            for (FileStatus symlink : symlinks = fileSystem.listStatus(symlinkDir)) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)fileSystem.open(symlink.getPath())));
                while ((line = reader.readLine()) != null) {
                    targetPaths.add(new Path(line));
                    symlinkPaths.add(symlink.getPath());
                }
            }
        }
    }

    public void validateInput(JobConf job) throws IOException {
    }

    @Override
    public ContentSummary getContentSummary(Path p, JobConf job) throws IOException {
        long[] summary = new long[]{0L, 0L, 0L};
        ArrayList<Path> targetPaths = new ArrayList<Path>();
        ArrayList<Path> symlinkPaths = new ArrayList<Path>();
        try {
            SymlinkTextInputFormat.getTargetPathsFromSymlinksDirs((Configuration)job, new Path[]{p}, targetPaths, symlinkPaths);
        }
        catch (Exception e) {
            throw new IOException("Error parsing symlinks from specified job input path.", e);
        }
        for (Path path : targetPaths) {
            FileSystem fs = path.getFileSystem((Configuration)job);
            ContentSummary cs = fs.getContentSummary(path);
            summary[0] = summary[0] + cs.getLength();
            summary[1] = summary[1] + cs.getFileCount();
            summary[2] = summary[2] + cs.getDirectoryCount();
        }
        return new ContentSummary(summary[0], summary[1], summary[2]);
    }

    public static class SymlinkTextInputSplit
    extends FileSplit {
        private final FileSplit split;

        public SymlinkTextInputSplit() {
            super((Path)null, 0L, 0L, (String[])null);
            this.split = new FileSplit((Path)null, 0L, 0L, (String[])null);
        }

        public SymlinkTextInputSplit(Path symlinkPath, FileSplit split) throws IOException {
            super(symlinkPath, 0L, 0L, split.getLocations());
            this.split = split;
        }

        public FileSplit getTargetSplit() {
            return this.split;
        }

        public void write(DataOutput out) throws IOException {
            super.write(out);
            this.split.write(out);
        }

        public void readFields(DataInput in) throws IOException {
            super.readFields(in);
            this.split.readFields(in);
        }
    }
}

