/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.SkewJoinProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapredWork;

public class SkewJoinResolver
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        SkewJoinTaskDispatcher disp = new SkewJoinTaskDispatcher(pctx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.rootTasks);
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public static class SkewJoinProcCtx
    implements NodeProcessorCtx {
        private Task<? extends Serializable> currentTask;
        private ParseContext parseCtx;

        public SkewJoinProcCtx(Task<? extends Serializable> task, ParseContext parseCtx) {
            this.currentTask = task;
            this.parseCtx = parseCtx;
        }

        public Task<? extends Serializable> getCurrentTask() {
            return this.currentTask;
        }

        public void setCurrentTask(Task<? extends Serializable> currentTask) {
            this.currentTask = currentTask;
        }

        public ParseContext getParseCtx() {
            return this.parseCtx;
        }

        public void setParseCtx(ParseContext parseCtx) {
            this.parseCtx = parseCtx;
        }
    }

    class SkewJoinTaskDispatcher
    implements Dispatcher {
        private PhysicalContext physicalContext;

        public SkewJoinTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task task = (Task)nd;
            if (!task.isMapRedTask() || task instanceof ConditionalTask || ((MapredWork)task.getWork()).getReducer() == null) {
                return null;
            }
            SkewJoinProcCtx skewJoinProcContext = new SkewJoinProcCtx(task, this.physicalContext.getParseContext());
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", "JOIN%"), SkewJoinProcFactory.getJoinProc());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(SkewJoinProcFactory.getDefaultProc(), opRules, skewJoinProcContext);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(((MapredWork)task.getWork()).getReducer());
            ogw.startWalking(topNodes, null);
            return null;
        }

        public PhysicalContext getPhysicalContext() {
            return this.physicalContext;
        }

        public void setPhysicalContext(PhysicalContext physicalContext) {
            this.physicalContext = physicalContext;
        }
    }
}

