/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.apache.hadoop.hive.jdbc.HiveQueryResultSet;
import org.apache.hadoop.hive.jdbc.JdbcSessionState;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.hive.service.HiveServerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HiveStatement
implements Statement {
    private JdbcSessionState session;
    private HiveInterface client;
    private ResultSet resultSet = null;
    private int maxRows = 0;
    private SQLWarning warningChain = null;
    private boolean isClosed = false;

    public HiveStatement(JdbcSessionState session, HiveInterface client) {
        this.session = session;
        this.client = client;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void cancel() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        this.client = null;
        this.resultSet = null;
        this.isClosed = true;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        ResultSet rs = this.executeQuery(sql);
        return rs != null;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't execute after statement has been closed");
        }
        try {
            this.resultSet = null;
            this.client.execute(sql);
        }
        catch (HiveServerException e) {
            throw new SQLException(e.getMessage(), e.getSQLState(), e.getErrorCode());
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString(), "08S01");
        }
        this.resultSet = new HiveQueryResultSet(this.client, this, this.maxRows);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            this.client.execute(sql);
        }
        catch (Exception ex) {
            throw new SQLException(ex.toString());
        }
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }
}

