/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.AbstractPrimitiveLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyByteObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyIntObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyLongObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyShortObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyStringObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyVoidObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;

public final class LazyPrimitiveObjectInspectorFactory {
    public static final LazyBooleanObjectInspector LAZY_BOOLEAN_OBJECT_INSPECTOR = new LazyBooleanObjectInspector();
    public static final LazyByteObjectInspector LAZY_BYTE_OBJECT_INSPECTOR = new LazyByteObjectInspector();
    public static final LazyShortObjectInspector LAZY_SHORT_OBJECT_INSPECTOR = new LazyShortObjectInspector();
    public static final LazyIntObjectInspector LAZY_INT_OBJECT_INSPECTOR = new LazyIntObjectInspector();
    public static final LazyLongObjectInspector LAZY_LONG_OBJECT_INSPECTOR = new LazyLongObjectInspector();
    public static final LazyFloatObjectInspector LAZY_FLOAT_OBJECT_INSPECTOR = new LazyFloatObjectInspector();
    public static final LazyDoubleObjectInspector LAZY_DOUBLE_OBJECT_INSPECTOR = new LazyDoubleObjectInspector();
    public static final LazyVoidObjectInspector LAZY_VOID_OBJECT_INSPECTOR = new LazyVoidObjectInspector();
    static HashMap<ArrayList<Object>, LazyStringObjectInspector> cachedLazyStringObjectInspector = new HashMap();

    public static LazyStringObjectInspector getLazyStringObjectInspector(boolean escaped, byte escapeChar) {
        ArrayList<Comparable<Boolean>> signature = new ArrayList<Comparable<Boolean>>();
        signature.add(Boolean.valueOf(escaped));
        signature.add(Byte.valueOf(escapeChar));
        LazyStringObjectInspector result = cachedLazyStringObjectInspector.get(signature);
        if (result == null) {
            result = new LazyStringObjectInspector(escaped, escapeChar);
            cachedLazyStringObjectInspector.put(signature, result);
        }
        return result;
    }

    public static AbstractPrimitiveLazyObjectInspector<?> getLazyObjectInspector(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, boolean escaped, byte escapeChar) {
        switch (primitiveCategory) {
            case BOOLEAN: {
                return LAZY_BOOLEAN_OBJECT_INSPECTOR;
            }
            case BYTE: {
                return LAZY_BYTE_OBJECT_INSPECTOR;
            }
            case SHORT: {
                return LAZY_SHORT_OBJECT_INSPECTOR;
            }
            case INT: {
                return LAZY_INT_OBJECT_INSPECTOR;
            }
            case LONG: {
                return LAZY_LONG_OBJECT_INSPECTOR;
            }
            case FLOAT: {
                return LAZY_FLOAT_OBJECT_INSPECTOR;
            }
            case DOUBLE: {
                return LAZY_DOUBLE_OBJECT_INSPECTOR;
            }
            case STRING: {
                return LazyPrimitiveObjectInspectorFactory.getLazyStringObjectInspector(escaped, escapeChar);
            }
            case VOID: {
                return LAZY_VOID_OBJECT_INSPECTOR;
            }
        }
        throw new RuntimeException("Internal error: Cannot find ObjectInspector  for " + (Object)((Object)primitiveCategory));
    }

    private LazyPrimitiveObjectInspectorFactory() {
    }
}

