/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.service.JobTrackerState;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class HiveClusterStatus
implements TBase<HiveClusterStatus, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("HiveClusterStatus");
    private static final TField TASK_TRACKERS_FIELD_DESC = new TField("taskTrackers", 8, 1);
    private static final TField MAP_TASKS_FIELD_DESC = new TField("mapTasks", 8, 2);
    private static final TField REDUCE_TASKS_FIELD_DESC = new TField("reduceTasks", 8, 3);
    private static final TField MAX_MAP_TASKS_FIELD_DESC = new TField("maxMapTasks", 8, 4);
    private static final TField MAX_REDUCE_TASKS_FIELD_DESC = new TField("maxReduceTasks", 8, 5);
    private static final TField STATE_FIELD_DESC = new TField("state", 8, 6);
    private int taskTrackers;
    private int mapTasks;
    private int reduceTasks;
    private int maxMapTasks;
    private int maxReduceTasks;
    private JobTrackerState state;
    private static final int __TASKTRACKERS_ISSET_ID = 0;
    private static final int __MAPTASKS_ISSET_ID = 1;
    private static final int __REDUCETASKS_ISSET_ID = 2;
    private static final int __MAXMAPTASKS_ISSET_ID = 3;
    private static final int __MAXREDUCETASKS_ISSET_ID = 4;
    private BitSet __isset_bit_vector = new BitSet(5);
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HiveClusterStatus() {
    }

    public HiveClusterStatus(int taskTrackers, int mapTasks, int reduceTasks, int maxMapTasks, int maxReduceTasks, JobTrackerState state) {
        this();
        this.taskTrackers = taskTrackers;
        this.setTaskTrackersIsSet(true);
        this.mapTasks = mapTasks;
        this.setMapTasksIsSet(true);
        this.reduceTasks = reduceTasks;
        this.setReduceTasksIsSet(true);
        this.maxMapTasks = maxMapTasks;
        this.setMaxMapTasksIsSet(true);
        this.maxReduceTasks = maxReduceTasks;
        this.setMaxReduceTasksIsSet(true);
        this.state = state;
    }

    public HiveClusterStatus(HiveClusterStatus other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.taskTrackers = other.taskTrackers;
        this.mapTasks = other.mapTasks;
        this.reduceTasks = other.reduceTasks;
        this.maxMapTasks = other.maxMapTasks;
        this.maxReduceTasks = other.maxReduceTasks;
        if (other.isSetState()) {
            this.state = other.state;
        }
    }

    public HiveClusterStatus deepCopy() {
        return new HiveClusterStatus(this);
    }

    public void clear() {
        this.setTaskTrackersIsSet(false);
        this.taskTrackers = 0;
        this.setMapTasksIsSet(false);
        this.mapTasks = 0;
        this.setReduceTasksIsSet(false);
        this.reduceTasks = 0;
        this.setMaxMapTasksIsSet(false);
        this.maxMapTasks = 0;
        this.setMaxReduceTasksIsSet(false);
        this.maxReduceTasks = 0;
        this.state = null;
    }

    public int getTaskTrackers() {
        return this.taskTrackers;
    }

    public void setTaskTrackers(int taskTrackers) {
        this.taskTrackers = taskTrackers;
        this.setTaskTrackersIsSet(true);
    }

    public void unsetTaskTrackers() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetTaskTrackers() {
        return this.__isset_bit_vector.get(0);
    }

    public void setTaskTrackersIsSet(boolean value) {
        this.__isset_bit_vector.set(0, value);
    }

    public int getMapTasks() {
        return this.mapTasks;
    }

    public void setMapTasks(int mapTasks) {
        this.mapTasks = mapTasks;
        this.setMapTasksIsSet(true);
    }

    public void unsetMapTasks() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetMapTasks() {
        return this.__isset_bit_vector.get(1);
    }

    public void setMapTasksIsSet(boolean value) {
        this.__isset_bit_vector.set(1, value);
    }

    public int getReduceTasks() {
        return this.reduceTasks;
    }

    public void setReduceTasks(int reduceTasks) {
        this.reduceTasks = reduceTasks;
        this.setReduceTasksIsSet(true);
    }

    public void unsetReduceTasks() {
        this.__isset_bit_vector.clear(2);
    }

    public boolean isSetReduceTasks() {
        return this.__isset_bit_vector.get(2);
    }

    public void setReduceTasksIsSet(boolean value) {
        this.__isset_bit_vector.set(2, value);
    }

    public int getMaxMapTasks() {
        return this.maxMapTasks;
    }

    public void setMaxMapTasks(int maxMapTasks) {
        this.maxMapTasks = maxMapTasks;
        this.setMaxMapTasksIsSet(true);
    }

    public void unsetMaxMapTasks() {
        this.__isset_bit_vector.clear(3);
    }

    public boolean isSetMaxMapTasks() {
        return this.__isset_bit_vector.get(3);
    }

    public void setMaxMapTasksIsSet(boolean value) {
        this.__isset_bit_vector.set(3, value);
    }

    public int getMaxReduceTasks() {
        return this.maxReduceTasks;
    }

    public void setMaxReduceTasks(int maxReduceTasks) {
        this.maxReduceTasks = maxReduceTasks;
        this.setMaxReduceTasksIsSet(true);
    }

    public void unsetMaxReduceTasks() {
        this.__isset_bit_vector.clear(4);
    }

    public boolean isSetMaxReduceTasks() {
        return this.__isset_bit_vector.get(4);
    }

    public void setMaxReduceTasksIsSet(boolean value) {
        this.__isset_bit_vector.set(4, value);
    }

    public JobTrackerState getState() {
        return this.state;
    }

    public void setState(JobTrackerState state) {
        this.state = state;
    }

    public void unsetState() {
        this.state = null;
    }

    public boolean isSetState() {
        return this.state != null;
    }

    public void setStateIsSet(boolean value) {
        if (!value) {
            this.state = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TASK_TRACKERS: {
                if (value == null) {
                    this.unsetTaskTrackers();
                    break;
                }
                this.setTaskTrackers((Integer)value);
                break;
            }
            case MAP_TASKS: {
                if (value == null) {
                    this.unsetMapTasks();
                    break;
                }
                this.setMapTasks((Integer)value);
                break;
            }
            case REDUCE_TASKS: {
                if (value == null) {
                    this.unsetReduceTasks();
                    break;
                }
                this.setReduceTasks((Integer)value);
                break;
            }
            case MAX_MAP_TASKS: {
                if (value == null) {
                    this.unsetMaxMapTasks();
                    break;
                }
                this.setMaxMapTasks((Integer)value);
                break;
            }
            case MAX_REDUCE_TASKS: {
                if (value == null) {
                    this.unsetMaxReduceTasks();
                    break;
                }
                this.setMaxReduceTasks((Integer)value);
                break;
            }
            case STATE: {
                if (value == null) {
                    this.unsetState();
                    break;
                }
                this.setState((JobTrackerState)((Object)value));
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TASK_TRACKERS: {
                return new Integer(this.getTaskTrackers());
            }
            case MAP_TASKS: {
                return new Integer(this.getMapTasks());
            }
            case REDUCE_TASKS: {
                return new Integer(this.getReduceTasks());
            }
            case MAX_MAP_TASKS: {
                return new Integer(this.getMaxMapTasks());
            }
            case MAX_REDUCE_TASKS: {
                return new Integer(this.getMaxReduceTasks());
            }
            case STATE: {
                return this.getState();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TASK_TRACKERS: {
                return this.isSetTaskTrackers();
            }
            case MAP_TASKS: {
                return this.isSetMapTasks();
            }
            case REDUCE_TASKS: {
                return this.isSetReduceTasks();
            }
            case MAX_MAP_TASKS: {
                return this.isSetMaxMapTasks();
            }
            case MAX_REDUCE_TASKS: {
                return this.isSetMaxReduceTasks();
            }
            case STATE: {
                return this.isSetState();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HiveClusterStatus) {
            return this.equals((HiveClusterStatus)that);
        }
        return false;
    }

    public boolean equals(HiveClusterStatus that) {
        if (that == null) {
            return false;
        }
        boolean this_present_taskTrackers = true;
        boolean that_present_taskTrackers = true;
        if (this_present_taskTrackers || that_present_taskTrackers) {
            if (!this_present_taskTrackers || !that_present_taskTrackers) {
                return false;
            }
            if (this.taskTrackers != that.taskTrackers) {
                return false;
            }
        }
        boolean this_present_mapTasks = true;
        boolean that_present_mapTasks = true;
        if (this_present_mapTasks || that_present_mapTasks) {
            if (!this_present_mapTasks || !that_present_mapTasks) {
                return false;
            }
            if (this.mapTasks != that.mapTasks) {
                return false;
            }
        }
        boolean this_present_reduceTasks = true;
        boolean that_present_reduceTasks = true;
        if (this_present_reduceTasks || that_present_reduceTasks) {
            if (!this_present_reduceTasks || !that_present_reduceTasks) {
                return false;
            }
            if (this.reduceTasks != that.reduceTasks) {
                return false;
            }
        }
        boolean this_present_maxMapTasks = true;
        boolean that_present_maxMapTasks = true;
        if (this_present_maxMapTasks || that_present_maxMapTasks) {
            if (!this_present_maxMapTasks || !that_present_maxMapTasks) {
                return false;
            }
            if (this.maxMapTasks != that.maxMapTasks) {
                return false;
            }
        }
        boolean this_present_maxReduceTasks = true;
        boolean that_present_maxReduceTasks = true;
        if (this_present_maxReduceTasks || that_present_maxReduceTasks) {
            if (!this_present_maxReduceTasks || !that_present_maxReduceTasks) {
                return false;
            }
            if (this.maxReduceTasks != that.maxReduceTasks) {
                return false;
            }
        }
        boolean this_present_state = this.isSetState();
        boolean that_present_state = that.isSetState();
        if (this_present_state || that_present_state) {
            if (!this_present_state || !that_present_state) {
                return false;
            }
            if (!this.state.equals((Object)that.state)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(HiveClusterStatus other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        HiveClusterStatus typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetTaskTrackers()).compareTo(typedOther.isSetTaskTrackers());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskTrackers() && (lastComparison = TBaseHelper.compareTo((int)this.taskTrackers, (int)typedOther.taskTrackers)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMapTasks()).compareTo(typedOther.isSetMapTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMapTasks() && (lastComparison = TBaseHelper.compareTo((int)this.mapTasks, (int)typedOther.mapTasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReduceTasks()).compareTo(typedOther.isSetReduceTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReduceTasks() && (lastComparison = TBaseHelper.compareTo((int)this.reduceTasks, (int)typedOther.reduceTasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxMapTasks()).compareTo(typedOther.isSetMaxMapTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxMapTasks() && (lastComparison = TBaseHelper.compareTo((int)this.maxMapTasks, (int)typedOther.maxMapTasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetMaxReduceTasks()).compareTo(typedOther.isSetMaxReduceTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxReduceTasks() && (lastComparison = TBaseHelper.compareTo((int)this.maxReduceTasks, (int)typedOther.maxReduceTasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetState()).compareTo(typedOther.isSetState());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetState() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.state), (Comparable)((Object)typedOther.state))) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.taskTrackers = iprot.readI32();
                        this.setTaskTrackersIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 8) {
                        this.mapTasks = iprot.readI32();
                        this.setMapTasksIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 8) {
                        this.reduceTasks = iprot.readI32();
                        this.setReduceTasksIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 8) {
                        this.maxMapTasks = iprot.readI32();
                        this.setMaxMapTasksIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 8) {
                        this.maxReduceTasks = iprot.readI32();
                        this.setMaxReduceTasksIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 6: {
                    if (field.type == 8) {
                        this.state = JobTrackerState.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(TASK_TRACKERS_FIELD_DESC);
        oprot.writeI32(this.taskTrackers);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAP_TASKS_FIELD_DESC);
        oprot.writeI32(this.mapTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(REDUCE_TASKS_FIELD_DESC);
        oprot.writeI32(this.reduceTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAX_MAP_TASKS_FIELD_DESC);
        oprot.writeI32(this.maxMapTasks);
        oprot.writeFieldEnd();
        oprot.writeFieldBegin(MAX_REDUCE_TASKS_FIELD_DESC);
        oprot.writeI32(this.maxReduceTasks);
        oprot.writeFieldEnd();
        if (this.state != null) {
            oprot.writeFieldBegin(STATE_FIELD_DESC);
            oprot.writeI32(this.state.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HiveClusterStatus(");
        boolean first = true;
        sb.append("taskTrackers:");
        sb.append(this.taskTrackers);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("mapTasks:");
        sb.append(this.mapTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("reduceTasks:");
        sb.append(this.reduceTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxMapTasks:");
        sb.append(this.maxMapTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("maxReduceTasks:");
        sb.append(this.maxReduceTasks);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("state:");
        if (this.state == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.state);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TASK_TRACKERS, new FieldMetaData("taskTrackers", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAP_TASKS, new FieldMetaData("mapTasks", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.REDUCE_TASKS, new FieldMetaData("reduceTasks", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_MAP_TASKS, new FieldMetaData("maxMapTasks", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.MAX_REDUCE_TASKS, new FieldMetaData("maxReduceTasks", 3, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.STATE, new FieldMetaData("state", 3, (FieldValueMetaData)new EnumMetaData(16, JobTrackerState.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HiveClusterStatus.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TASK_TRACKERS(1, "taskTrackers"),
        MAP_TASKS(2, "mapTasks"),
        REDUCE_TASKS(3, "reduceTasks"),
        MAX_MAP_TASKS(4, "maxMapTasks"),
        MAX_REDUCE_TASKS(5, "maxReduceTasks"),
        STATE(6, "state");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TASK_TRACKERS;
                }
                case 2: {
                    return MAP_TASKS;
                }
                case 3: {
                    return REDUCE_TASKS;
                }
                case 4: {
                    return MAX_MAP_TASKS;
                }
                case 5: {
                    return MAX_REDUCE_TASKS;
                }
                case 6: {
                    return STATE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

