/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.service;

import com.facebook.fb303.fb_status;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.plan.api.QueryPlan;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.service.HiveClusterStatus;
import org.apache.hadoop.hive.service.HiveInterface;
import org.apache.hadoop.hive.service.HiveServerException;
import org.apache.hadoop.hive.service.JobTrackerState;
import org.apache.hadoop.hive.service.ThriftHive;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobTracker;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveServer
extends ThriftHive {
    private static final String VERSION = "1";

    public static void main(String[] args) {
        try {
            SessionState.initHiveLog4j();
            int port = 10000;
            int minWorkerThreads = 100;
            if (args.length >= 1) {
                port = Integer.parseInt(args[0]);
            }
            if (args.length >= 2) {
                minWorkerThreads = Integer.parseInt(args[1]);
            }
            TServerSocket serverTransport = new TServerSocket(port);
            ThriftHiveProcessorFactory hfactory = new ThriftHiveProcessorFactory(null);
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            options.minWorkerThreads = minWorkerThreads;
            TThreadPoolServer server = new TThreadPoolServer((TProcessorFactory)hfactory, (TServerTransport)serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            HiveServerHandler.LOG.info((Object)("Starting hive server on port " + port));
            server.serve();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static class ThriftHiveProcessorFactory
    extends TProcessorFactory {
        public ThriftHiveProcessorFactory(TProcessor processor) {
            super(processor);
        }

        public TProcessor getProcessor(TTransport trans) {
            try {
                HiveServerHandler handler = new HiveServerHandler();
                return new ThriftHive.Processor(handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class HiveServerHandler
    extends HiveMetaStore.HMSHandler
    implements HiveInterface {
        private Driver driver = null;
        private CommandProcessorResponse response;
        private BufferedReader pipeIn;
        private boolean isHiveQuery = false;
        public static final Log LOG = LogFactory.getLog((String)HiveServer.class.getName());

        public HiveServerHandler() throws MetaException {
            super(HiveServer.class.getName());
            SessionState session = new SessionState(new HiveConf(SessionState.class));
            SessionState.start((SessionState)session);
            this.setupSessionIO(session);
        }

        private void setupSessionIO(SessionState session) {
            try {
                LOG.info((Object)("Putting temp output to file " + session.getTmpOutputFile().toString()));
                session.in = null;
                session.out = new PrintStream((OutputStream)new FileOutputStream(session.getTmpOutputFile()), true, "UTF-8");
                session.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
            }
            catch (IOException e) {
                LOG.error((Object)"Error in creating temp output file ", (Throwable)e);
                try {
                    session.in = null;
                    session.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
                    session.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
                }
                catch (UnsupportedEncodingException ee) {
                    ee.printStackTrace();
                    session.out = null;
                    session.err = null;
                }
            }
        }

        @Override
        public void execute(String cmd) throws HiveServerException, TException {
            LOG.info((Object)("Running the query: " + cmd));
            SessionState session = SessionState.get();
            String cmd_trimmed = cmd.trim();
            String[] tokens = cmd_trimmed.split("\\s");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            int ret = 0;
            String errorMessage = "";
            String SQLState = null;
            try {
                CommandProcessor proc = CommandProcessorFactory.get((String)tokens[0]);
                if (proc != null) {
                    if (proc instanceof Driver) {
                        this.isHiveQuery = true;
                        this.driver = (Driver)proc;
                        this.response = this.driver.run(cmd);
                    } else {
                        this.isHiveQuery = false;
                        this.driver = null;
                        this.setupSessionIO(session);
                        this.response = proc.run(cmd_1);
                    }
                    ret = this.response.getResponseCode();
                    SQLState = this.response.getSQLState();
                    errorMessage = this.response.getErrorMessage();
                }
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Error running query: " + e.toString());
                ex.setErrorCode(ret == 0 ? -10000 : ret);
                throw ex;
            }
            if (ret != 0) {
                throw new HiveServerException("Query returned non-zero code: " + ret + ", cause: " + errorMessage, ret, SQLState);
            }
        }

        @Override
        public void clean() {
            SessionState session;
            if (this.driver != null) {
                this.driver.close();
                this.driver.destroy();
            }
            if ((session = SessionState.get()).getTmpOutputFile() != null) {
                session.getTmpOutputFile().delete();
            }
            this.pipeIn = null;
        }

        @Override
        public HiveClusterStatus getClusterStatus() throws HiveServerException, TException {
            HiveClusterStatus hcs;
            try {
                JobTrackerState state;
                Driver drv = new Driver();
                drv.init();
                ClusterStatus cs = drv.getClusterStatus();
                JobTracker.State jbs = cs.getJobTrackerState();
                switch (jbs) {
                    case INITIALIZING: {
                        state = JobTrackerState.INITIALIZING;
                        break;
                    }
                    case RUNNING: {
                        state = JobTrackerState.RUNNING;
                        break;
                    }
                    default: {
                        String errorMsg = "Unrecognized JobTracker state: " + jbs.toString();
                        throw new Exception(errorMsg);
                    }
                }
                hcs = new HiveClusterStatus(cs.getTaskTrackers(), cs.getMapTasks(), cs.getReduceTasks(), cs.getMaxMapTasks(), cs.getMaxReduceTasks(), state);
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get cluster status: " + e.toString());
                throw ex;
            }
            return hcs;
        }

        @Override
        public Schema getSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                Schema schema = this.response.getSchema();
                if (schema == null) {
                    return new Schema();
                }
                return schema;
            }
            assert (this.driver != null) : "getSchema() is called on a Hive query and driver is NULL.";
            try {
                Schema schema = this.driver.getSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public Schema getThriftSchema() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                return new Schema();
            }
            assert (this.driver != null) : "getThriftSchema() is called on a Hive query and driver is NULL.";
            try {
                Schema schema = this.driver.getThriftSchema();
                if (schema == null) {
                    schema = new Schema();
                }
                LOG.info((Object)("Returning schema: " + schema));
                return schema;
            }
            catch (Exception e) {
                LOG.error((Object)e.toString());
                e.printStackTrace();
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Unable to get schema: " + e.toString());
                throw ex;
            }
        }

        @Override
        public String fetchOne() throws HiveServerException, TException {
            if (!this.isHiveQuery) {
                ArrayList<String> results = new ArrayList<String>(1);
                this.readResults(results, 1);
                if (results.size() > 0) {
                    return (String)results.get(0);
                }
                throw new HiveServerException("OK", 0, "");
            }
            assert (this.driver != null) : "fetchOne() is called on a Hive query and driver is NULL.";
            ArrayList result = new ArrayList();
            this.driver.setMaxRows(1);
            try {
                if (this.driver.getResults(result)) {
                    return (String)result.get(0);
                }
                throw new HiveServerException("OK", 0, "");
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
        }

        private void cleanTmpFile() {
            if (this.pipeIn != null) {
                SessionState session = SessionState.get();
                File tmp = session.getTmpOutputFile();
                tmp.delete();
                this.pipeIn = null;
            }
        }

        private void readResults(List<String> results, int nLines) {
            if (this.pipeIn == null) {
                SessionState session = SessionState.get();
                File tmp = session.getTmpOutputFile();
                try {
                    this.pipeIn = new BufferedReader(new FileReader(tmp));
                }
                catch (FileNotFoundException e) {
                    LOG.error((Object)("File " + tmp + " not found. "), (Throwable)e);
                    return;
                }
            }
            boolean readAll = false;
            for (int i = 0; i < nLines || nLines <= 0; ++i) {
                try {
                    String line = this.pipeIn.readLine();
                    if (line == null) {
                        readAll = true;
                        break;
                    }
                    results.add(line);
                    continue;
                }
                catch (IOException e) {
                    LOG.error((Object)"Reading temp results encountered an exception: ", (Throwable)e);
                    readAll = true;
                }
            }
            if (readAll) {
                this.cleanTmpFile();
            }
        }

        @Override
        public List<String> fetchN(int numRows) throws HiveServerException, TException {
            if (numRows < 0) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage("Invalid argument for number of rows: " + numRows);
                throw ex;
            }
            ArrayList<String> result = new ArrayList<String>();
            if (!this.isHiveQuery) {
                this.readResults(result, numRows);
                return result;
            }
            assert (this.driver != null) : "fetchN() is called on a Hive query and driver is NULL.";
            this.driver.setMaxRows(numRows);
            try {
                this.driver.getResults(result);
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return result;
        }

        @Override
        public List<String> fetchAll() throws HiveServerException, TException {
            ArrayList<String> rows = new ArrayList<String>();
            ArrayList<String> result = new ArrayList<String>();
            if (!this.isHiveQuery) {
                this.readResults(result, 0);
                return result;
            }
            try {
                while (this.driver.getResults(result)) {
                    rows.addAll(result);
                    result.clear();
                }
            }
            catch (IOException e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.getMessage());
                throw ex;
            }
            return rows;
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public String getVersion() {
            return HiveServer.VERSION;
        }

        @Override
        public QueryPlan getQueryPlan() throws HiveServerException, TException {
            QueryPlan qp = new QueryPlan();
            if (!this.isHiveQuery) {
                return qp;
            }
            assert (this.driver != null) : "getQueryPlan() is called on a Hive query and driver is NULL.";
            try {
                qp.addToQueries(this.driver.getQueryPlan());
            }
            catch (Exception e) {
                HiveServerException ex = new HiveServerException();
                ex.setMessage(e.toString());
                throw ex;
            }
            return qp;
        }
    }
}

