/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.mapreduce.converter.converters;

import org.apache.hadoop.io.BooleanWritable;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.mapreduce.converter.TypeConversionException;
import org.pentaho.hadoop.mapreduce.converter.TypeConverterFactory;
import org.pentaho.hadoop.mapreduce.converter.spi.ITypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleTypeToBooleanWritableConverter
implements ITypeConverter<Object, BooleanWritable> {
    @Override
    public boolean canConvert(Class from, Class to) {
        return TypeConverterFactory.isKettleType(from) && BooleanWritable.class.equals((Object)to);
    }

    @Override
    public BooleanWritable convert(ValueMetaInterface meta, Object obj) throws TypeConversionException {
        try {
            BooleanWritable result = new BooleanWritable();
            result.set(meta.getBoolean(obj).booleanValue());
            return result;
        }
        catch (Exception ex) {
            throw new TypeConversionException(BaseMessages.getString(TypeConverterFactory.class, (String)"ErrorConverting", (Object[])new Object[]{BooleanWritable.class.getSimpleName(), obj}), ex);
        }
    }
}

