/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.PigWarning;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCombinerPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPreCombinerLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.builtin.Distinct;
import org.apache.pig.impl.plan.CompilationMessageCollector;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.plan.optimizer.OptimizerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinerOptimizer
extends MROpPlanVisitor {
    private static final String DISTINCT_UDF_CLASSNAME = Distinct.class.getName();
    private Log log = LogFactory.getLog(this.getClass());
    private int mKeyField = -1;
    private boolean[] keyFieldPositions;
    private byte mKeyType = 0;
    private CompilationMessageCollector messageCollector = null;

    public CombinerOptimizer(MROperPlan plan, String chunkSize) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
        this.messageCollector = new CompilationMessageCollector();
    }

    public CombinerOptimizer(MROperPlan plan, String chunkSize, CompilationMessageCollector messageCollector) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
        this.messageCollector = messageCollector;
    }

    public CompilationMessageCollector getMessageCollector() {
        return this.messageCollector;
    }

    @Override
    public void visitMROp(MapReduceOper mr) throws VisitorException {
        POForEach foreach;
        List<PhysicalPlan> feInners;
        List<ExprType> ap;
        this.resetState();
        this.log.trace((Object)"Entering CombinerOptimizer.visitMROp");
        if (mr.reducePlan.isEmpty()) {
            return;
        }
        List mapLeaves = mr.mapPlan.getLeaves();
        if (mapLeaves == null || mapLeaves.size() != 1) {
            this.messageCollector.collect("Expected map to have single leaf!", CompilationMessageCollector.MessageType.Warning, PigWarning.MULTI_LEAF_MAP);
            return;
        }
        PhysicalOperator mapLeaf = (PhysicalOperator)mapLeaves.get(0);
        if (!(mapLeaf instanceof POLocalRearrange)) {
            return;
        }
        POLocalRearrange rearrange = (POLocalRearrange)mapLeaf;
        List reduceRoots = mr.reducePlan.getRoots();
        if (reduceRoots.size() != 1) {
            this.messageCollector.collect("Expected reduce to have single leaf", CompilationMessageCollector.MessageType.Warning, PigWarning.MULTI_LEAF_REDUCE);
            return;
        }
        PhysicalOperator root = (PhysicalOperator)reduceRoots.get(0);
        if (!(root instanceof POPackage)) {
            this.messageCollector.collect("Expected reduce root to be a POPackage", CompilationMessageCollector.MessageType.Warning, PigWarning.NON_PACKAGE_REDUCE_PLAN_ROOT);
            return;
        }
        POPackage pack = (POPackage)root;
        List<PhysicalOperator> packSuccessors = mr.reducePlan.getSuccessors(root);
        if (packSuccessors == null || packSuccessors.size() != 1) {
            return;
        }
        PhysicalOperator successor = packSuccessors.get(0);
        if (!(successor instanceof POFilter) && successor instanceof POForEach && (ap = this.algebraic(feInners = (foreach = (POForEach)successor).getInputPlans(), foreach.getToBeFlattened())) != null) {
            this.log.info((Object)"Choosing to move algebraic foreach to combiner");
            if (mr.combinePlan.getRoots().size() != 0) {
                this.messageCollector.collect("Wasn't expecting to find anything already in the combiner!", CompilationMessageCollector.MessageType.Warning, PigWarning.NON_EMPTY_COMBINE_PLAN);
                return;
            }
            mr.combinePlan = new PhysicalPlan();
            try {
                if (this.mKeyType == 0) {
                    this.mKeyType = rearrange.getKeyType();
                }
                POForEach mfe = foreach.clone();
                POForEach cfe = foreach.clone();
                this.fixUpForeachs(mfe, cfe, foreach, ap);
                int numFields = this.mKeyField >= ap.size() ? this.mKeyField + 1 : ap.size();
                boolean[] bags = new boolean[numFields];
                for (int i = 0; i < ap.size(); ++i) {
                    bags[i] = ap.get(i) != ExprType.SIMPLE_PROJECT;
                }
                bags[this.mKeyField] = false;
                POCombinerPackage combinePack = new POCombinerPackage(pack, bags, this.keyFieldPositions);
                mr.combinePlan.add(combinePack);
                mr.combinePlan.add(cfe);
                mr.combinePlan.connect(combinePack, cfe);
                POLocalRearrange mlr = rearrange.clone();
                this.fixUpRearrange(mlr);
                this.patchUpMap(mr.mapPlan, this.getPreCombinerLR(rearrange), mfe, mlr);
                POLocalRearrange clr = rearrange.clone();
                this.fixUpRearrange(clr);
                mr.combinePlan.add(clr);
                mr.combinePlan.connect(cfe, clr);
                POCombinerPackage newReducePack = new POCombinerPackage(pack, bags, this.keyFieldPositions);
                mr.reducePlan.replace(pack, newReducePack);
                ArrayList<PhysicalOperator> packList = new ArrayList<PhysicalOperator>();
                packList.add(newReducePack);
                List<POCombinerPackage> sucs = mr.reducePlan.getSuccessors(newReducePack);
                ((PhysicalOperator)sucs.get(0)).setInputs(packList);
            }
            catch (Exception e) {
                int errCode = 2018;
                String msg = "Internal error. Unable to introduce the combiner for optimization.";
                throw new OptimizerException(msg, errCode, 4, e);
            }
        }
    }

    private void patchUpMap(PhysicalPlan mapPlan, POPreCombinerLocalRearrange preCombinerLR, POForEach mfe, POLocalRearrange mlr) throws PlanException {
        POLocalRearrange oldLR = (POLocalRearrange)mapPlan.getLeaves().get(0);
        mapPlan.replace(oldLR, preCombinerLR);
        mapPlan.add(mfe);
        mapPlan.connect(preCombinerLR, mfe);
        mapPlan.add(mlr);
        mapPlan.connect(mfe, mlr);
    }

    private POPreCombinerLocalRearrange getPreCombinerLR(POLocalRearrange rearrange) {
        String scope = rearrange.getOperatorKey().scope;
        POPreCombinerLocalRearrange pclr = new POPreCombinerLocalRearrange(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), rearrange.getRequestedParallelism(), rearrange.getInputs());
        pclr.setPlans(rearrange.getPlans());
        return pclr;
    }

    private List<ExprType> algebraic(List<PhysicalPlan> plans, List<Boolean> flattens) throws VisitorException {
        ArrayList<ExprType> types = new ArrayList<ExprType>(plans.size());
        boolean atLeastOneAlgebraic = false;
        boolean noNonAlgebraics = true;
        this.keyFieldPositions = new boolean[plans.size()];
        for (int i = 0; i < plans.size(); ++i) {
            ExprType t = this.algebraic(plans.get(i), flattens.get(i), i);
            types.add(t);
            atLeastOneAlgebraic |= t == ExprType.ALGEBRAIC || t == ExprType.DISTINCT;
            noNonAlgebraics &= t != ExprType.NOT_ALGEBRAIC;
        }
        if (!atLeastOneAlgebraic || !noNonAlgebraics) {
            return null;
        }
        return types;
    }

    private ExprType algebraic(PhysicalPlan pp, Boolean toBeFlattened, int field) throws VisitorException {
        List leaves = pp.getLeaves();
        if (leaves == null || leaves.size() != 1) {
            return ExprType.NOT_ALGEBRAIC;
        }
        AlgebraicPlanChecker apc = new AlgebraicPlanChecker(pp);
        apc.visit();
        if (apc.sawNonAlgebraic) {
            return ExprType.NOT_ALGEBRAIC;
        }
        if (apc.sawDistinctAgg) {
            return ExprType.DISTINCT;
        }
        PhysicalOperator leaf = (PhysicalOperator)leaves.get(0);
        if (leaf instanceof POProject) {
            POProject proj = (POProject)leaf;
            if (pp.getPredecessors(proj) != null) {
                return ExprType.NOT_ALGEBRAIC;
            }
            if (proj.getResultType() == 120) {
                return ExprType.NOT_ALGEBRAIC;
            }
            ArrayList<Integer> cols = proj.getColumns();
            if (cols != null && cols.size() == 1 && (Integer)cols.get(0) == 0 && pp.getPredecessors(proj) == null) {
                this.mKeyField = field;
                this.keyFieldPositions[field] = true;
                this.mKeyType = proj.getResultType();
            } else if (toBeFlattened.booleanValue()) {
                return ExprType.NOT_ALGEBRAIC;
            }
            return ExprType.SIMPLE_PROJECT;
        }
        if (leaf instanceof POUserFunc) {
            POUserFunc userFunc = (POUserFunc)leaf;
            if (!userFunc.combinable()) {
                return ExprType.NOT_ALGEBRAIC;
            }
            CheckCombinableUserFunc ccuf = new CheckCombinableUserFunc(pp);
            ccuf.visit();
            return ccuf.exprType;
        }
        return ExprType.NOT_ALGEBRAIC;
    }

    private void fixUpForeachs(POForEach mfe, POForEach cfe, POForEach rfe, List<ExprType> exprs) throws PlanException {
        List<PhysicalPlan> mPlans = mfe.getInputPlans();
        List<PhysicalPlan> cPlans = cfe.getInputPlans();
        List<PhysicalPlan> rPlans = rfe.getInputPlans();
        for (int i = 0; i < exprs.size(); ++i) {
            if (exprs.get(i) == ExprType.ALGEBRAIC) {
                this.changeFunc(mfe, mPlans.get(i), (byte)0);
                this.changeFunc(cfe, cPlans.get(i), (byte)1);
                this.changeFunc(rfe, rPlans.get(i), (byte)2);
                continue;
            }
            if (exprs.get(i) != ExprType.DISTINCT) continue;
            PhysicalPlan[] plans = new PhysicalPlan[]{mPlans.get(i), cPlans.get(i), rPlans.get(i)};
            byte[] funcTypes = new byte[]{0, 1, 2};
            for (int j = 0; j < plans.length; ++j) {
                DistinctPatcher dp = new DistinctPatcher(plans[j]);
                try {
                    dp.visit();
                }
                catch (VisitorException e) {
                    int errCode = 2073;
                    String msg = "Problem with replacing distinct operator with distinct built-in function.";
                    throw new PlanException(msg, errCode, 4, e);
                }
                PhysicalOperator leaf = (PhysicalOperator)plans[j].getLeaves().get(0);
                if (j != plans.length - 1) {
                    while (!(leaf instanceof POUserFunc) || !((POUserFunc)leaf).getFuncSpec().getClassName().startsWith(DISTINCT_UDF_CLASSNAME)) {
                        plans[j].remove(leaf);
                        leaf = (PhysicalOperator)plans[j].getLeaves().get(0);
                    }
                }
                POUserFunc distinctFunc = (POUserFunc)this.getDistinctUserFunc(plans[j], leaf);
                try {
                    distinctFunc.setAlgebraicFunction(funcTypes[j]);
                    continue;
                }
                catch (ExecException e) {
                    int errCode = 2074;
                    String msg = "Could not configure distinct's algebraic functions in map reduce plan.";
                    throw new PlanException(msg, errCode, 4, e);
                }
            }
        }
        for (PhysicalPlan mpl : mPlans) {
            try {
                new fixMapProjects(mpl).visit();
            }
            catch (VisitorException e) {
                int errCode = 2089;
                String msg = "Unable to flag project operator to use single tuple bag.";
                throw new PlanException(msg, errCode, 4, e);
            }
        }
        ArrayList<Boolean> feFlattens = new ArrayList<Boolean>(cPlans.size());
        for (int i = 0; i < cPlans.size(); ++i) {
            feFlattens.add(false);
        }
        mfe.setToBeFlattened(feFlattens);
        cfe.setToBeFlattened(feFlattens);
        if (this.mKeyField == -1) {
            this.addKeyProject(mfe);
            this.addKeyProject(cfe);
            this.mKeyField = cPlans.size() - 1;
            this.keyFieldPositions = new boolean[cPlans.size()];
            this.keyFieldPositions[this.mKeyField] = true;
        }
        this.fixProjectAndInputs(cPlans, exprs);
        this.fixProjectAndInputs(rPlans, exprs);
        mfe.setInputPlans(mPlans);
        cfe.setInputPlans(cPlans);
        rfe.setInputPlans(rPlans);
    }

    private void fixProjectAndInputs(List<PhysicalPlan> plans, List<ExprType> exprs) throws PlanException {
        for (int i = 0; i < plans.size(); ++i) {
            List leaves = plans.get(i).getLeaves();
            if (leaves == null || leaves.size() != 1) {
                int errCode = 2019;
                String msg = "Expected to find plan with single leaf. Found " + leaves.size() + " leaves.";
                throw new PlanException(msg, errCode, 4);
            }
            PhysicalOperator leaf = (PhysicalOperator)leaves.get(0);
            if (i < exprs.size() && exprs.get(i) == ExprType.DISTINCT) {
                PhysicalOperator op = this.getDistinctUserFunc(plans.get(i), leaf);
                this.setProjectInput(op, plans.get(i), i);
                continue;
            }
            if (leaf instanceof POProject) {
                ((POProject)leaf).setColumn(i);
                continue;
            }
            if (!(leaf instanceof POUserFunc)) continue;
            this.setProjectInput(leaf, plans.get(i), i);
        }
    }

    private void setProjectInput(PhysicalOperator op, PhysicalPlan plan, int index) throws PlanException {
        String scope = op.getOperatorKey().scope;
        POProject proj = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), op.getRequestedParallelism(), index);
        proj.setResultType((byte)120);
        plan.trimAbove(op);
        plan.add(proj);
        plan.connect(proj, op);
        ArrayList<PhysicalOperator> inputs = new ArrayList<PhysicalOperator>(1);
        inputs.add(proj);
        op.setInputs(inputs);
    }

    private PhysicalOperator getDistinctUserFunc(PhysicalPlan plan, PhysicalOperator operator) {
        if (operator instanceof POUserFunc && ((POUserFunc)operator).getFuncSpec().getClassName().startsWith(DISTINCT_UDF_CLASSNAME)) {
            return operator;
        }
        return this.getDistinctUserFunc(plan, plan.getPredecessors(operator).get(0));
    }

    private void addKeyProject(POForEach fe) {
        PhysicalPlan newForEachInnerPlan = new PhysicalPlan();
        String scope = fe.getOperatorKey().scope;
        POProject proj = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, 0);
        proj.setResultType(this.mKeyType);
        newForEachInnerPlan.add(proj);
        fe.addInputPlan(newForEachInnerPlan, false);
    }

    private void changeFunc(POForEach fe, PhysicalPlan plan, byte type) throws PlanException {
        List leaves = plan.getLeaves();
        if (leaves == null || leaves.size() != 1) {
            int errCode = 2019;
            String msg = "Expected to find plan with single leaf. Found " + leaves.size() + " leaves.";
            throw new PlanException(msg, errCode, 4);
        }
        PhysicalOperator leaf = (PhysicalOperator)leaves.get(0);
        if (!(leaf instanceof POUserFunc)) {
            int errCode = 2020;
            String msg = "Expected to find plan with UDF leaf. Found " + leaf.getClass().getSimpleName();
            throw new PlanException(msg, errCode, 4);
        }
        POUserFunc func = (POUserFunc)leaf;
        try {
            func.setAlgebraicFunction(type);
        }
        catch (ExecException e) {
            int errCode = 2075;
            String msg = "Could not set algebraic function type.";
            throw new PlanException(msg, errCode, 4, e);
        }
    }

    private void fixUpRearrange(POLocalRearrange rearrange) throws PlanException {
        PhysicalPlan newPlan = new PhysicalPlan();
        String scope = rearrange.getOperatorKey().scope;
        POProject proj = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, this.mKeyField);
        proj.setResultType(this.mKeyType);
        newPlan.add(proj);
        ArrayList<PhysicalPlan> plans = new ArrayList<PhysicalPlan>(1);
        plans.add(newPlan);
        rearrange.setPlansFromCombiner(plans);
    }

    private void resetState() {
        this.mKeyField = -1;
        this.mKeyType = 0;
        this.keyFieldPositions = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class fixMapProjects
    extends PhyPlanVisitor {
        public fixMapProjects(PhysicalPlan plan) {
            this(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public fixMapProjects(PhysicalPlan plan, PlanWalker<PhysicalOperator, PhysicalPlan> walker) {
            super(plan, walker);
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            if (proj.getResultType() == 120) {
                proj.setResultSingleTupleBag(true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DistinctPatcher
    extends PhyPlanVisitor {
        public boolean patched = false;

        public DistinctPatcher(PhysicalPlan plan, PlanWalker<PhysicalOperator, PhysicalPlan> walker) {
            super(plan, walker);
        }

        public DistinctPatcher(PhysicalPlan physicalPlan) {
            this(physicalPlan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(physicalPlan));
        }

        @Override
        public void visitProject(POProject proj) throws VisitorException {
            List<POProject> preds = ((PhysicalPlan)this.mPlan).getPredecessors(proj);
            if (preds == null) {
                return;
            }
            PhysicalOperator pred = preds.get(0);
            if (preds.size() == 1 && pred instanceof PODistinct) {
                if (this.patched) {
                    int errCode = 2076;
                    String msg = "Unexpected Project-Distinct pair while trying to set up plans for use with combiner.";
                    throw new OptimizerException(msg, errCode, 4);
                }
                PhysicalOperator distinctPredecessor = ((PhysicalPlan)this.mPlan).getPredecessors(pred).get(0);
                try {
                    String scope = proj.getOperatorKey().scope;
                    ArrayList<PhysicalOperator> funcInput = new ArrayList<PhysicalOperator>();
                    FuncSpec fSpec = new FuncSpec(DISTINCT_UDF_CLASSNAME);
                    funcInput.add(distinctPredecessor);
                    distinctPredecessor.setResultType((byte)110);
                    POUserFunc func = new POUserFunc(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), -1, funcInput, fSpec);
                    func.setResultType((byte)120);
                    ((PhysicalPlan)this.mPlan).replace(proj, func);
                    ((PhysicalPlan)this.mPlan).remove(pred);
                    ((PhysicalPlan)this.mPlan).connect(distinctPredecessor, func);
                }
                catch (PlanException e) {
                    int errCode = 2077;
                    String msg = "Problem with reconfiguring plan to add distinct built-in function.";
                    throw new OptimizerException(msg, errCode, 4, e);
                }
                this.patched = true;
            }
        }
    }

    private static class AlgebraicPlanChecker
    extends PhyPlanVisitor {
        boolean sawNonAlgebraic = false;
        boolean sawDistinctAgg = false;
        private boolean sawForeach = false;

        AlgebraicPlanChecker(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public void visit() throws VisitorException {
            super.visit();
            if (this.sawForeach && !this.sawDistinctAgg) {
                this.sawNonAlgebraic = true;
            }
        }

        public void visitDistinct(PODistinct distinct) throws VisitorException {
            if (this.sawDistinctAgg) {
                this.sawNonAlgebraic = true;
                return;
            }
            PhysicalOperator leaf = (PhysicalOperator)((PhysicalPlan)this.mPlan).getLeaves().get(0);
            if (leaf instanceof POUserFunc) {
                List<PhysicalOperator> preds = ((PhysicalPlan)this.mPlan).getPredecessors(leaf);
                if (preds.size() > 1) {
                    this.sawNonAlgebraic = true;
                    return;
                }
                List<PODistinct> immediateSuccs = ((PhysicalPlan)this.mPlan).getSuccessors(distinct);
                if (immediateSuccs.size() == 1 && immediateSuccs.get(0) instanceof POProject) {
                    PhysicalOperator op;
                    if (this.checkSuccessorIsLeaf(leaf, immediateSuccs.get(0))) {
                        this.sawDistinctAgg = true;
                        return;
                    }
                    List<Operator> nextSuccs = ((PhysicalPlan)this.mPlan).getSuccessors((Operator)immediateSuccs.get(0));
                    if (nextSuccs.size() == 1 && (op = (PhysicalOperator)nextSuccs.get(0)) instanceof POProject && this.checkSuccessorIsLeaf(leaf, op)) {
                        this.sawDistinctAgg = true;
                        return;
                    }
                }
            }
            this.sawNonAlgebraic = true;
        }

        public void visitLimit(POLimit limit) throws VisitorException {
            this.sawNonAlgebraic = true;
        }

        private boolean checkSuccessorIsLeaf(PhysicalOperator leaf, PhysicalOperator opToCheck) {
            PhysicalOperator op;
            List<PhysicalOperator> succs = ((PhysicalPlan)this.mPlan).getSuccessors(opToCheck);
            return succs.size() == 1 && (op = succs.get(0)) == leaf;
        }

        public void visitFilter(POFilter filter) throws VisitorException {
            this.sawNonAlgebraic = true;
        }

        public void visitPOForEach(POForEach fe) throws VisitorException {
            this.sawForeach = true;
        }

        public void visitSort(POSort sort) throws VisitorException {
            this.sawNonAlgebraic = true;
        }
    }

    private static class CheckCombinableUserFunc
    extends PhyPlanVisitor {
        private ExprType exprType = ExprType.ALGEBRAIC;

        public CheckCombinableUserFunc(PhysicalPlan plan) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(plan));
        }

        public void visit() throws VisitorException {
            super.visit();
        }

        public void visitUserFunc(POUserFunc userFunc) throws VisitorException {
            List<POUserFunc> succs = ((PhysicalPlan)this.mPlan).getSuccessors(userFunc);
            if (succs != null && !succs.isEmpty() && userFunc.combinable()) {
                this.exprType = ExprType.NOT_ALGEBRAIC;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExprType {
        SIMPLE_PROJECT,
        ALGEBRAIC,
        NOT_ALGEBRAIC,
        DISTINCT;

    }
}

