/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ColumnChainInfo;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.ColumnInfo;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.POToChange;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.SortKeyInfo;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.PORelationToExprProject;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POJoinPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPackage;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSortedDistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;

public class SecondaryKeyOptimizer
extends MROpPlanVisitor {
    private Log log = LogFactory.getLog(this.getClass());
    private int numMRUseSecondaryKey = 0;
    private int numDistinctChanged = 0;
    private int numSortRemoved = 0;

    public SecondaryKeyOptimizer(MROperPlan plan) {
        super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new DepthFirstWalker<MapReduceOper, MROperPlan>(plan));
    }

    SortKeyInfo getSortKeyInfo(POLocalRearrange rearrange) throws ExecException {
        SortKeyInfo result = new SortKeyInfo();
        List<PhysicalPlan> plans = rearrange.getPlans();
        block0: for (int i = 0; i < plans.size(); ++i) {
            PhysicalPlan plan = plans.get(i);
            ColumnChainInfo columnChainInfo = new ColumnChainInfo();
            if (plan.getRoots() == null) {
                this.log.debug((Object)"POLocalRearrange plan is null");
                return null;
            }
            if (plan.getRoots().size() != 1) continue;
            ArrayList<Integer> columns = new ArrayList<Integer>();
            columns.add(rearrange.getIndex() & 0x7F);
            columnChainInfo.insert(false, columns, (byte)110);
            PhysicalOperator node = (PhysicalOperator)plan.getRoots().get(0);
            while (node != null) {
                if (!(node instanceof POProject)) continue block0;
                POProject project = (POProject)node;
                columnChainInfo.insert(project.isStar(), project.getColumns(), project.getResultType());
                if (plan.getSuccessors(node) == null) {
                    node = null;
                    continue;
                }
                if (plan.getSuccessors(node).size() != 1) {
                    this.log.debug((Object)(node + " have more than 1 successor"));
                    node = null;
                    continue;
                }
                node = plan.getSuccessors(node).get(0);
            }
            result.insertColumnChainInfo(i, columnChainInfo, true);
        }
        return result;
    }

    public void visitMROp(MapReduceOper mr) throws VisitorException {
        PhysicalOperator mapLeaf;
        ArrayList<POToChange> distinctsToChange;
        ArrayList<POToChange> sortsToRemove;
        SortKeyInfo secondarySortKeyInfo;
        ArrayList<SortKeyInfo> sortKeyInfos;
        block39: {
            this.log.trace((Object)"Entering SecondaryKeyOptimizer.visitMROp, skip optimizing");
            sortKeyInfos = new ArrayList<SortKeyInfo>();
            secondarySortKeyInfo = null;
            sortsToRemove = null;
            distinctsToChange = null;
            if (mr.isGlobalSort()) {
                return;
            }
            List mapLeaves = mr.mapPlan.getLeaves();
            if (mapLeaves == null || mapLeaves.size() != 1) {
                this.log.debug((Object)"Expected map to have single leaf! Skip secondary key optimizing");
                return;
            }
            mapLeaf = (PhysicalOperator)mapLeaves.get(0);
            try {
                if (mapLeaf instanceof POLocalRearrange) {
                    SortKeyInfo sortKeyInfo = this.getSortKeyInfo((POLocalRearrange)mapLeaf);
                    if (sortKeyInfo == null) {
                        this.log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                        return;
                    }
                    sortKeyInfos.add(sortKeyInfo);
                    break block39;
                }
                if (mapLeaf instanceof POUnion) {
                    List<PhysicalOperator> preds = mr.mapPlan.getPredecessors(mapLeaf);
                    for (PhysicalOperator pred : preds) {
                        if (!(pred instanceof POLocalRearrange)) continue;
                        SortKeyInfo sortKeyInfo = this.getSortKeyInfo((POLocalRearrange)pred);
                        if (sortKeyInfo == null) {
                            this.log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                            return;
                        }
                        sortKeyInfos.add(sortKeyInfo);
                    }
                    break block39;
                }
                this.log.debug((Object)"Cannot find POLocalRearrange or POUnion in map leaf, skip secondary key optimizing");
                return;
            }
            catch (ExecException e) {
                this.log.debug((Object)"Cannot get sortKeyInfo from POLocalRearrange, skip secondary key optimizing");
                return;
            }
        }
        if (mr.reducePlan.isEmpty()) {
            this.log.debug((Object)"Reduce plan is empty, skip secondary key optimizing");
            return;
        }
        List reduceRoots = mr.reducePlan.getRoots();
        if (reduceRoots.size() != 1) {
            this.log.debug((Object)"Expected reduce to have single root, skip secondary key optimizing");
            return;
        }
        PhysicalOperator root = (PhysicalOperator)reduceRoots.get(0);
        if (!(root instanceof POPackage)) {
            this.log.debug((Object)"Expected reduce root to be a POPackage, skip secondary key optimizing");
            return;
        }
        PhysicalOperator currentNode = root;
        POForEach foreach = null;
        while (currentNode != null) {
            if (currentNode instanceof POPackage && !(currentNode instanceof POJoinPackage) || currentNode instanceof POFilter || currentNode instanceof POLimit) {
                List<PhysicalOperator> succs = mr.reducePlan.getSuccessors(currentNode);
                if (succs == null) {
                    return;
                }
                if (succs.size() != 1) {
                    this.log.debug((Object)("See multiple output for " + currentNode + " in reduce plan, skip secondary key optimizing"));
                    return;
                }
                currentNode = succs.get(0);
                continue;
            }
            if (currentNode instanceof POForEach) {
                foreach = (POForEach)currentNode;
                break;
            }
            return;
        }
        if (foreach == null) {
            return;
        }
        sortsToRemove = new ArrayList<POToChange>();
        distinctsToChange = new ArrayList<POToChange>();
        for (PhysicalPlan innerPlan : foreach.getInputPlans()) {
            SecondaryKeyDiscover innerPlanDiscover = new SecondaryKeyDiscover(innerPlan, sortKeyInfos, secondarySortKeyInfo);
            try {
                innerPlanDiscover.process();
            }
            catch (FrontendException e) {
                int errorCode = 2213;
                throw new VisitorException("Error visiting inner plan for ForEach", errorCode, e);
            }
            secondarySortKeyInfo = innerPlanDiscover.getSecondarySortKeyInfo();
            if (innerPlanDiscover.getSortsToRemove() != null) {
                for (POSort sort : innerPlanDiscover.getSortsToRemove()) {
                    sortsToRemove.add(new POToChange(sort, innerPlan, foreach));
                }
            }
            if (innerPlanDiscover.getDistinctsToChange() == null) continue;
            for (PODistinct distinct : innerPlanDiscover.getDistinctsToChange()) {
                distinctsToChange.add(new POToChange(distinct, innerPlan, foreach));
            }
        }
        try {
            String scope;
            for (POToChange distinctToChange : distinctsToChange) {
                ++this.numDistinctChanged;
                PODistinct oldDistinct = (PODistinct)distinctToChange.oper;
                scope = oldDistinct.getOperatorKey().scope;
                POSortedDistinct newDistinct = new POSortedDistinct(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), oldDistinct.getRequestedParallelism(), oldDistinct.getInputs());
                newDistinct.setInputs(oldDistinct.getInputs());
                newDistinct.setResultType(oldDistinct.getResultType());
                distinctToChange.plan.replace(oldDistinct, newDistinct);
                distinctToChange.forEach.getLeaves();
            }
            for (POToChange sortToRemove : sortsToRemove) {
                ++this.numSortRemoved;
                POSort oldSort = (POSort)sortToRemove.oper;
                scope = oldSort.getOperatorKey().scope;
                List<PhysicalOperator> preds = sortToRemove.plan.getPredecessors(sortToRemove.oper);
                List<PhysicalOperator> succs = sortToRemove.plan.getSuccessors(sortToRemove.oper);
                PORelationToExprProject project = null;
                if (!(preds != null && (preds.get(0).getResultType() == 120 || oldSort.getResultType() != 120) || succs != null && succs.get(0) instanceof PORelationToExprProject)) {
                    project = new PORelationToExprProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), oldSort.getRequestedParallelism());
                    project.setInputs(oldSort.getInputs());
                    project.setResultType((byte)120);
                    project.setStar(true);
                }
                if (project == null) {
                    sortToRemove.plan.removeAndReconnect(sortToRemove.oper);
                } else {
                    sortToRemove.plan.replace(oldSort, project);
                }
                sortToRemove.forEach.getLeaves();
            }
        }
        catch (PlanException e) {
            int errorCode = 2202;
            throw new VisitorException("Error change distinct/sort to use secondary key optimizer", errorCode, e);
        }
        if (secondarySortKeyInfo != null) {
            ++this.numMRUseSecondaryKey;
            mr.setUseSecondaryKey(true);
            mr.setSecondarySortOrder(secondarySortKeyInfo.getAscs());
            byte indexOfRearrangeToChange = -1;
            for (ColumnChainInfo columnChainInfo : secondarySortKeyInfo.getColumnChains()) {
                ColumnInfo currentColumn = columnChainInfo.getColumnInfos().get(0);
                byte index = currentColumn.columns.get(0).intValue();
                if (indexOfRearrangeToChange == -1) {
                    indexOfRearrangeToChange = index;
                    continue;
                }
                if (indexOfRearrangeToChange == index) continue;
                int errorCode = 2203;
                throw new VisitorException("Sort on columns from different inputs.", errorCode);
            }
            if (mapLeaf instanceof POLocalRearrange) {
                ((POLocalRearrange)mapLeaf).setUseSecondaryKey(true);
                this.setSecondaryPlan(mr.mapPlan, (POLocalRearrange)mapLeaf, secondarySortKeyInfo);
            } else if (mapLeaf instanceof POUnion) {
                List<PhysicalOperator> preds = mr.mapPlan.getPredecessors(mapLeaf);
                boolean found = false;
                for (PhysicalOperator pred : preds) {
                    POLocalRearrange rearrange = (POLocalRearrange)pred;
                    rearrange.setUseSecondaryKey(true);
                    if (rearrange.getIndex() != indexOfRearrangeToChange) continue;
                    found = true;
                    this.setSecondaryPlan(mr.mapPlan, rearrange, secondarySortKeyInfo);
                }
                if (!found) {
                    int errorCode = 2214;
                    throw new VisitorException("Cannot find POLocalRearrange to set secondary plan", errorCode);
                }
            }
            POPackage pack = (POPackage)root;
            pack.setUseSecondaryKey(true);
        }
    }

    void setSecondaryPlan(PhysicalPlan plan, POLocalRearrange rearrange, SortKeyInfo secondarySortKeyInfo) throws VisitorException {
        try {
            String scope = rearrange.getOperatorKey().scope;
            ArrayList<PhysicalPlan> secondaryPlanList = new ArrayList<PhysicalPlan>();
            for (ColumnChainInfo columnChainInfo : secondarySortKeyInfo.getColumnChains()) {
                PhysicalPlan secondaryPlan = new PhysicalPlan();
                for (int i = 1; i < columnChainInfo.size(); ++i) {
                    ColumnInfo columnInfo = columnChainInfo.getColumnInfo(i);
                    POProject project = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), rearrange.getRequestedParallelism());
                    if (columnInfo.star) {
                        project.setStar(true);
                    } else {
                        project.setColumns((ArrayList)columnInfo.columns);
                    }
                    project.setResultType(columnInfo.resultType);
                    secondaryPlan.addAsLeaf(project);
                }
                if (secondaryPlan.isEmpty()) {
                    POProject project = new POProject(new OperatorKey(scope, NodeIdGenerator.getGenerator().getNextNodeId(scope)), rearrange.getRequestedParallelism());
                    project.setStar(true);
                    secondaryPlan.addAsLeaf(project);
                }
                secondaryPlanList.add(secondaryPlan);
            }
            rearrange.setSecondaryPlans(secondaryPlanList);
        }
        catch (PlanException e) {
            int errorCode = 2204;
            throw new VisitorException("Error setting secondary key plan", errorCode, e);
        }
    }

    public int getNumMRUseSecondaryKey() {
        return this.numMRUseSecondaryKey;
    }

    public int getNumSortRemoved() {
        return this.numSortRemoved;
    }

    public int getDistinctChanged() {
        return this.numDistinctChanged;
    }

    private static boolean collectColumnChain(PhysicalPlan plan, ColumnChainInfo columnChainInfo) throws PlanException {
        if (plan.getRoots().size() != 1) {
            int errorCode = 2207;
            throw new PlanException("POForEach inner plan has more than 1 root", errorCode);
        }
        PhysicalOperator currentNode = (PhysicalOperator)plan.getRoots().get(0);
        while (currentNode != null) {
            if (!(currentNode instanceof POProject)) {
                return true;
            }
            POProject project = (POProject)currentNode;
            columnChainInfo.insertInReduce(project.isStar(), project.getColumns(), project.getResultType());
            List<PhysicalOperator> succs = plan.getSuccessors(currentNode);
            if (succs == null) break;
            if (succs.size() != 1) {
                int errorCode = 2208;
                throw new PlanException("Exception visiting foreach inner plan", errorCode);
            }
            currentNode = succs.get(0);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SecondaryKeyDiscover {
        PhysicalPlan mPlan;
        List<POSort> sortsToRemove = new ArrayList<POSort>();
        List<PODistinct> distinctsToChange = new ArrayList<PODistinct>();
        List<SortKeyInfo> sortKeyInfos;
        SortKeyInfo secondarySortKeyInfo;
        ColumnChainInfo columnChainInfo = null;

        SecondaryKeyDiscover(PhysicalPlan plan, List<SortKeyInfo> sortKeyInfos, SortKeyInfo secondarySortKeyInfo) {
            this.mPlan = plan;
            this.sortKeyInfos = sortKeyInfos;
            this.secondarySortKeyInfo = secondarySortKeyInfo;
        }

        public void process() throws FrontendException {
            List roots = this.mPlan.getRoots();
            for (PhysicalOperator root : roots) {
                this.columnChainInfo = new ColumnChainInfo();
                this.processRoot(root);
            }
        }

        public void processRoot(PhysicalOperator root) throws FrontendException {
            PhysicalOperator currentNode = root;
            while (currentNode != null) {
                boolean sawInvalidPhysicalOper = false;
                if (currentNode instanceof PODistinct) {
                    sawInvalidPhysicalOper = this.processDistinct((PODistinct)currentNode);
                } else if (currentNode instanceof POSort) {
                    sawInvalidPhysicalOper = this.processSort((POSort)currentNode);
                } else if (currentNode instanceof POProject) {
                    sawInvalidPhysicalOper = this.processProject((POProject)currentNode);
                } else if (currentNode instanceof POForEach) {
                    sawInvalidPhysicalOper = this.processForEach((POForEach)currentNode);
                } else if (currentNode instanceof POUserFunc || currentNode instanceof POUnion) break;
                if (sawInvalidPhysicalOper) break;
                List<PhysicalOperator> succs = this.mPlan.getSuccessors(currentNode);
                if (succs == null) {
                    currentNode = null;
                    continue;
                }
                if (succs.size() > 1) {
                    int errorCode = 2215;
                    throw new FrontendException("See more than 1 successors in the nested plan for " + currentNode, errorCode);
                }
                currentNode = succs.get(0);
            }
        }

        public boolean processDistinct(PODistinct distinct) throws FrontendException {
            SortKeyInfo keyInfos = new SortKeyInfo();
            try {
                keyInfos.insertColumnChainInfo(0, (ColumnChainInfo)this.columnChainInfo.clone(), true);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            for (SortKeyInfo sortKeyInfo : this.sortKeyInfos) {
                if (!sortKeyInfo.moreSpecificThan(keyInfos)) continue;
                this.distinctsToChange.add(distinct);
                return false;
            }
            if (this.secondarySortKeyInfo != null && this.secondarySortKeyInfo.moreSpecificThan(keyInfos)) {
                this.distinctsToChange.add(distinct);
                return false;
            }
            if (this.secondarySortKeyInfo == null) {
                this.distinctsToChange.add(distinct);
                this.secondarySortKeyInfo = keyInfos;
            }
            return false;
        }

        public boolean processProject(POProject project) throws FrontendException {
            this.columnChainInfo.insertInReduce(project.isStar(), project.getColumns(), project.getResultType());
            return false;
        }

        public boolean processForEach(POForEach fe) throws FrontendException {
            if (fe.getInputPlans().size() > 1) {
                throw new FrontendException("POForEach has more than 1 input plans");
            }
            boolean r = false;
            try {
                r = SecondaryKeyOptimizer.collectColumnChain(fe.getInputPlans().get(0), this.columnChainInfo);
            }
            catch (PlanException e) {
                int errorCode = 2205;
                throw new FrontendException("Error visiting POForEach inner plan", errorCode, e);
            }
            return r;
        }

        public boolean processSort(POSort sort) throws FrontendException {
            SortKeyInfo keyInfo = new SortKeyInfo();
            for (int i = 0; i < sort.getSortPlans().size(); ++i) {
                PhysicalPlan sortPlan = sort.getSortPlans().get(i);
                ColumnChainInfo sortChainInfo = null;
                try {
                    sortChainInfo = (ColumnChainInfo)this.columnChainInfo.clone();
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                boolean r = false;
                try {
                    r = SecondaryKeyOptimizer.collectColumnChain(sortPlan, sortChainInfo);
                }
                catch (PlanException e) {
                    int errorCode = 2206;
                    throw new FrontendException("Error visiting POSort inner plan", errorCode, e);
                }
                if (r) {
                    return true;
                }
                keyInfo.insertColumnChainInfo(i, sortChainInfo, sort.getMAscCols().get(i));
            }
            for (SortKeyInfo sortKeyInfo : this.sortKeyInfos) {
                if (!sortKeyInfo.moreSpecificThan(keyInfo)) continue;
                this.sortsToRemove.add(sort);
                return false;
            }
            if (this.secondarySortKeyInfo != null && this.secondarySortKeyInfo.moreSpecificThan(keyInfo)) {
                this.sortsToRemove.add(sort);
                return false;
            }
            if (this.secondarySortKeyInfo == null) {
                this.sortsToRemove.add(sort);
                this.secondarySortKeyInfo = keyInfo;
            }
            return false;
        }

        public List<POSort> getSortsToRemove() {
            return this.sortsToRemove;
        }

        public List<PODistinct> getDistinctsToChange() {
            return this.distinctsToChange;
        }

        public SortKeyInfo getSecondarySortKeyInfo() {
            return this.secondarySortKeyInfo;
        }
    }
}

