/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigLogger;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.pen.util.LineageTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhysicalOperator
extends Operator<PhyPlanVisitor>
implements Cloneable {
    private Log log = LogFactory.getLog(this.getClass());
    protected static final long serialVersionUID = 1L;
    protected int requestedParallelism;
    protected List<PhysicalOperator> inputs;
    protected List<PhysicalOperator> outputs;
    protected byte resultType = (byte)110;
    protected PhysicalPlan parentPlan;
    protected boolean inputAttached = false;
    protected Tuple input = null;
    protected Result res = null;
    protected String alias = null;
    public static PigProgressable reporter;
    protected static PigLogger pigLogger;
    protected static final DataByteArray dummyDBA;
    protected static final String dummyString;
    protected static final Double dummyDouble;
    protected static final Float dummyFloat;
    protected static final Integer dummyInt;
    protected static final Long dummyLong;
    protected static final Boolean dummyBool;
    protected static final Tuple dummyTuple;
    protected static final DataBag dummyBag;
    protected static final Map dummyMap;
    protected LineageTracer lineageTracer;
    private boolean accum;
    private transient boolean accumStart;

    public PhysicalOperator(OperatorKey k) {
        this(k, -1, null);
    }

    public PhysicalOperator(OperatorKey k, int rp) {
        this(k, rp, null);
    }

    public PhysicalOperator(OperatorKey k, List<PhysicalOperator> inp) {
        this(k, -1, inp);
    }

    public PhysicalOperator(OperatorKey k, int rp, List<PhysicalOperator> inp) {
        super(k);
        this.requestedParallelism = rp;
        this.inputs = inp;
        this.res = new Result();
    }

    public void setLineageTracer(LineageTracer lineage) {
        this.lineageTracer = lineage;
    }

    public int getRequestedParallelism() {
        return this.requestedParallelism;
    }

    public void setRequestedParallelism(int requestedParallelism) {
        this.requestedParallelism = requestedParallelism;
    }

    public byte getResultType() {
        return this.resultType;
    }

    public String getAlias() {
        return this.alias;
    }

    protected String getAliasString() {
        return this.alias == null ? "" : this.alias + ": ";
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAccumulative() {
        this.accum = true;
    }

    public boolean isAccumulative() {
        return this.accum;
    }

    public void setAccumStart() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = true;
    }

    public boolean isAccumStarted() {
        return this.accumStart;
    }

    public void setAccumEnd() {
        if (!this.accum) {
            throw new IllegalStateException("Accumulative is not turned on.");
        }
        this.accumStart = false;
    }

    public void setResultType(byte resultType) {
        this.resultType = resultType;
    }

    public List<PhysicalOperator> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<PhysicalOperator> inputs) {
        this.inputs = inputs;
    }

    public boolean isInputAttached() {
        return this.inputAttached;
    }

    public void attachInput(Tuple t) {
        this.input = t;
        this.inputAttached = true;
    }

    public void detachInput() {
        this.input = null;
        this.inputAttached = false;
    }

    public boolean isBlocking() {
        return false;
    }

    public Result processInput() throws ExecException {
        Result res = new Result();
        if (this.input == null && (this.inputs == null || this.inputs.size() == 0)) {
            res.returnStatus = (byte)3;
            return res;
        }
        if (reporter != null) {
            reporter.progress();
        }
        if (!this.isInputAttached()) {
            return this.inputs.get(0).getNext(dummyTuple);
        }
        res.result = this.input;
        res.returnStatus = res.result == null ? (byte)1 : 0;
        this.detachInput();
        return res;
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    public Result getNext(Integer i) throws ExecException {
        return this.res;
    }

    public Result getNext(Long l) throws ExecException {
        return this.res;
    }

    public Result getNext(Double d) throws ExecException {
        return this.res;
    }

    public Result getNext(Float f) throws ExecException {
        return this.res;
    }

    public Result getNext(String s) throws ExecException {
        return this.res;
    }

    public Result getNext(DataByteArray ba) throws ExecException {
        return this.res;
    }

    public Result getNext(Map m) throws ExecException {
        return this.res;
    }

    public Result getNext(Boolean b) throws ExecException {
        return this.res;
    }

    public Result getNext(Tuple t) throws ExecException {
        return this.res;
    }

    public Result getNext(DataBag db) throws ExecException {
        Result ret = null;
        DataBag tmpBag = BagFactory.getInstance().newDefaultBag();
        ret = this.getNext(dummyTuple);
        while (ret.returnStatus != 3) {
            if (ret.returnStatus == 2) {
                return ret;
            }
            tmpBag.add((Tuple)ret.result);
            ret = this.getNext(dummyTuple);
        }
        ret.result = tmpBag;
        ret.returnStatus = (byte)(tmpBag.size() == 0L ? 3 : 0);
        return ret;
    }

    public void reset() {
    }

    public static void setReporter(PigProgressable reporter) {
        PhysicalOperator.reporter = reporter;
    }

    @Override
    public PhysicalOperator clone() throws CloneNotSupportedException {
        return (PhysicalOperator)super.clone();
    }

    protected void cloneHelper(PhysicalOperator op) {
        this.resultType = op.resultType;
    }

    public void setParentPlan(PhysicalPlan physicalPlan) {
        this.parentPlan = physicalPlan;
    }

    public Log getLogger() {
        return this.log;
    }

    public static void setPigLogger(PigLogger logger) {
        pigLogger = logger;
    }

    public static PigLogger getPigLogger() {
        return pigLogger;
    }

    static {
        dummyDBA = null;
        dummyString = null;
        dummyDouble = null;
        dummyFloat = null;
        dummyInt = null;
        dummyLong = null;
        dummyBool = null;
        dummyTuple = null;
        dummyBag = null;
        dummyMap = null;
    }
}

