/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.POUserFunc;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionOperator
extends PhysicalOperator {
    private static final long serialVersionUID = 1L;
    protected Log log = LogFactory.getLog(this.getClass());

    public ExpressionOperator(OperatorKey k) {
        this(k, -1);
    }

    public ExpressionOperator(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        return new Result();
    }

    @Override
    public abstract void visit(PhyPlanVisitor var1) throws VisitorException;

    @Override
    public ExpressionOperator clone() throws CloneNotSupportedException {
        String s = "This expression operator does not implement clone.";
        this.log.error((Object)s);
        throw new CloneNotSupportedException(s);
    }

    protected abstract List<ExpressionOperator> getChildExpressions();

    public boolean containUDF() {
        if (this instanceof POUserFunc) {
            return true;
        }
        List<ExpressionOperator> l = this.getChildExpressions();
        if (l != null) {
            for (ExpressionOperator e : l) {
                if (!e.containUDF()) continue;
                return true;
            }
        }
        return false;
    }

    protected Result accumChild(List<ExpressionOperator> child, Double d) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(d);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Integer v) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(v);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Long l) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(l);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Float f) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(f);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Boolean b) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(b);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, String s) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(s);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, DataByteArray dba) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(dba);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Map map) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(map);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, Tuple t) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(t);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }

    protected Result accumChild(List<ExpressionOperator> child, DataBag db) throws ExecException {
        if (this.isAccumStarted()) {
            if (child == null) {
                child = this.getChildExpressions();
            }
            Result res = null;
            if (child != null) {
                for (ExpressionOperator e : child) {
                    if (!e.containUDF()) continue;
                    res = e.getNext(db);
                    if (res.returnStatus == 5) continue;
                    return res;
                }
            }
            res = new Result();
            res.returnStatus = (byte)5;
            return res;
        }
        return null;
    }
}

