/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryComparisonOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class GTOrEqualToExpr
extends BinaryComparisonOperator {
    private static final long serialVersionUID = 1L;
    private final transient Log log = LogFactory.getLog(this.getClass());

    public GTOrEqualToExpr(OperatorKey k) {
        this(k, -1);
    }

    public GTOrEqualToExpr(OperatorKey k, int rp) {
        super(k, rp);
        this.resultType = (byte)5;
    }

    public String name() {
        return "Greater Than or Equal[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitGTOrEqual(this);
    }

    public Result getNext(Boolean bool) throws ExecException {
        switch (this.operandType) {
            case 50: {
                Result r = this.accumChild(null, dummyDBA);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyDBA);
                Result right = this.rhs.getNext(dummyDBA);
                return this.doComparison(left, right);
            }
            case 25: {
                Result r = this.accumChild(null, dummyDouble);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyDouble);
                Result right = this.rhs.getNext(dummyDouble);
                return this.doComparison(left, right);
            }
            case 20: {
                Result r = this.accumChild(null, dummyFloat);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyFloat);
                Result right = this.rhs.getNext(dummyFloat);
                return this.doComparison(left, right);
            }
            case 10: {
                Result r = this.accumChild(null, dummyInt);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyInt);
                Result right = this.rhs.getNext(dummyInt);
                return this.doComparison(left, right);
            }
            case 15: {
                Result r = this.accumChild(null, dummyLong);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyLong);
                Result right = this.rhs.getNext(dummyLong);
                return this.doComparison(left, right);
            }
            case 55: {
                Result r = this.accumChild(null, dummyString);
                if (r != null) {
                    return r;
                }
                Result left = this.lhs.getNext(dummyString);
                Result right = this.rhs.getNext(dummyString);
                return this.doComparison(left, right);
            }
        }
        int errCode = 2067;
        String msg = this.getClass().getSimpleName() + " does not know how to " + "handle type: " + DataType.findTypeName(this.operandType);
        throw new ExecException(msg, errCode, 4);
    }

    private Result doComparison(Result left, Result right) {
        if (this.trueRef == null) {
            this.initializeRefs();
        }
        if (left.returnStatus != 0) {
            return left;
        }
        if (right.returnStatus != 0) {
            return right;
        }
        if (left.result == null || right.result == null) {
            left.result = null;
            left.returnStatus = 1;
            return left;
        }
        assert (left.result instanceof Comparable);
        assert (right.result instanceof Comparable);
        left.result = ((Comparable)left.result).compareTo((Comparable)right.result) >= 0 ? this.trueRef : this.falseRef;
        return left;
    }

    public GTOrEqualToExpr clone() throws CloneNotSupportedException {
        GTOrEqualToExpr clone = new GTOrEqualToExpr(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

