/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.BinaryExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class Multiply
extends BinaryExpressionOperator {
    private static final long serialVersionUID = 1L;

    public Multiply(OperatorKey k) {
        super(k);
    }

    public Multiply(OperatorKey k, int rp) {
        super(k, rp);
    }

    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitMultiply(this);
    }

    public String name() {
        return "Multiply[" + DataType.findTypeName(this.resultType) + "]" + " - " + this.mKey.toString();
    }

    public Result getNext(Double d) throws ExecException {
        Result r = this.accumChild(null, d);
        if (r != null) {
            return r;
        }
        Double left = null;
        Double right = null;
        Result res = this.lhs.getNext(left);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Double)res.result;
        res = this.rhs.getNext(right);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Double)res.result;
        res.result = new Double(left * right);
        return res;
    }

    public Result getNext(Float f) throws ExecException {
        Result r = this.accumChild(null, f);
        if (r != null) {
            return r;
        }
        Float left = null;
        Float right = null;
        Result res = this.lhs.getNext(left);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Float)res.result;
        res = this.rhs.getNext(right);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Float)res.result;
        res.result = new Float(left.floatValue() * right.floatValue());
        return res;
    }

    public Result getNext(Integer i) throws ExecException {
        Result r = this.accumChild(null, i);
        if (r != null) {
            return r;
        }
        Integer left = null;
        Integer right = null;
        Result res = this.lhs.getNext(left);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Integer)res.result;
        res = this.rhs.getNext(right);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Integer)res.result;
        res.result = left * right;
        return res;
    }

    public Result getNext(Long l) throws ExecException {
        Result r = this.accumChild(null, l);
        if (r != null) {
            return r;
        }
        Long left = null;
        Long right = null;
        Result res = this.lhs.getNext(left);
        byte status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        left = (Long)res.result;
        res = this.rhs.getNext(right);
        status = res.returnStatus;
        if (status != 0 || res.result == null) {
            return res;
        }
        right = (Long)res.result;
        res.result = left * right;
        return res;
    }

    public Multiply clone() throws CloneNotSupportedException {
        Multiply clone = new Multiply(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.cloneHelper(this);
        return clone;
    }
}

